package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FunctionCallOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFunctionCallOperator.builder()}.
 */
@Generated(from = "FunctionCallOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFunctionCallOperator
    implements FunctionCallOperator {
  private final ValueType valueType;
  private final String functionName;
  private final ImmutableList<Expression> args;

  private ImmutableFunctionCallOperator(
      ValueType valueType,
      String functionName,
      ImmutableList<Expression> args) {
    this.valueType = valueType;
    this.functionName = functionName;
    this.args = args;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @Override
  public ValueType getValueType() {
    return valueType;
  }

  /**
   * @return The value of the {@code functionName} attribute
   */
  @Override
  public String getFunctionName() {
    return functionName;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @Override
  public ImmutableList<Expression> getArgs() {
    return args;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FunctionCallOperator#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFunctionCallOperator withValueType(ValueType value) {
    if (this.valueType == value) return this;
    ValueType newValue = Objects.requireNonNull(value, "valueType");
    return new ImmutableFunctionCallOperator(newValue, this.functionName, this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FunctionCallOperator#getFunctionName() functionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for functionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFunctionCallOperator withFunctionName(String value) {
    String newValue = Objects.requireNonNull(value, "functionName");
    if (this.functionName.equals(newValue)) return this;
    return new ImmutableFunctionCallOperator(this.valueType, newValue, this.args);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FunctionCallOperator#getArgs() args}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFunctionCallOperator withArgs(Expression... elements) {
    ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFunctionCallOperator(this.valueType, this.functionName, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FunctionCallOperator#getArgs() args}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of args elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFunctionCallOperator withArgs(Iterable<? extends Expression> elements) {
    if (this.args == elements) return this;
    ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFunctionCallOperator(this.valueType, this.functionName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFunctionCallOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFunctionCallOperator
        && equalTo((ImmutableFunctionCallOperator) another);
  }

  private boolean equalTo(ImmutableFunctionCallOperator another) {
    return valueType.equals(another.valueType)
        && functionName.equals(another.functionName)
        && args.equals(another.args);
  }

  /**
   * Computes a hash code from attributes: {@code valueType}, {@code functionName}, {@code args}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + valueType.hashCode();
    h += (h << 5) + functionName.hashCode();
    h += (h << 5) + args.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FunctionCallOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FunctionCallOperator")
        .omitNullValues()
        .add("valueType", valueType)
        .add("functionName", functionName)
        .add("args", args)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FunctionCallOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FunctionCallOperator instance
   */
  public static ImmutableFunctionCallOperator copyOf(FunctionCallOperator instance) {
    if (instance instanceof ImmutableFunctionCallOperator) {
      return (ImmutableFunctionCallOperator) instance;
    }
    return ImmutableFunctionCallOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFunctionCallOperator ImmutableFunctionCallOperator}.
   * <pre>
   * ImmutableFunctionCallOperator.builder()
   *    .valueType(io.dialob.rule.parser.api.ValueType) // required {@link FunctionCallOperator#getValueType() valueType}
   *    .functionName(String) // required {@link FunctionCallOperator#getFunctionName() functionName}
   *    .addArgs|addAllArgs(io.dialob.session.engine.program.model.Expression) // {@link FunctionCallOperator#getArgs() args} elements
   *    .build();
   * </pre>
   * @return A new ImmutableFunctionCallOperator builder
   */
  public static ImmutableFunctionCallOperator.Builder builder() {
    return new ImmutableFunctionCallOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFunctionCallOperator ImmutableFunctionCallOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FunctionCallOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE_TYPE = 0x1L;
    private static final long INIT_BIT_FUNCTION_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ValueType valueType;
    private @Nullable String functionName;
    private ImmutableList.Builder<Expression> args = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.expr.arith.FunctionCallOperator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FunctionCallOperator instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Expression} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Expression instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof FunctionCallOperator) {
        FunctionCallOperator instance = (FunctionCallOperator) object;
        addAllArgs(instance.getArgs());
        functionName(instance.getFunctionName());
        if ((bits & 0x1L) == 0) {
          valueType(instance.getValueType());
          bits |= 0x1L;
        }
      }
      if (object instanceof Expression) {
        Expression instance = (Expression) object;
        if ((bits & 0x1L) == 0) {
          valueType(instance.getValueType());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link FunctionCallOperator#getValueType() valueType} attribute.
     * @param valueType The value for valueType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueType(ValueType valueType) {
      this.valueType = Objects.requireNonNull(valueType, "valueType");
      initBits &= ~INIT_BIT_VALUE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link FunctionCallOperator#getFunctionName() functionName} attribute.
     * @param functionName The value for functionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder functionName(String functionName) {
      this.functionName = Objects.requireNonNull(functionName, "functionName");
      initBits &= ~INIT_BIT_FUNCTION_NAME;
      return this;
    }

    /**
     * Adds one element to {@link FunctionCallOperator#getArgs() args} list.
     * @param element A args element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArgs(Expression element) {
      this.args.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FunctionCallOperator#getArgs() args} list.
     * @param elements An array of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArgs(Expression... elements) {
      this.args.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FunctionCallOperator#getArgs() args} list.
     * @param elements An iterable of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(Iterable<? extends Expression> elements) {
      this.args = ImmutableList.builder();
      return addAllArgs(elements);
    }

    /**
     * Adds elements to {@link FunctionCallOperator#getArgs() args} list.
     * @param elements An iterable of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArgs(Iterable<? extends Expression> elements) {
      this.args.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFunctionCallOperator ImmutableFunctionCallOperator}.
     * @return An immutable instance of FunctionCallOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFunctionCallOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFunctionCallOperator(valueType, functionName, args.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE_TYPE) != 0) attributes.add("valueType");
      if ((initBits & INIT_BIT_FUNCTION_NAME) != 0) attributes.add("functionName");
      return "Cannot build FunctionCallOperator, some of required attributes are not set " + attributes;
    }
  }
}
