package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CanRemoveRowOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCanRemoveRowOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCanRemoveRowOperator.of()}.
 */
@Generated(from = "CanRemoveRowOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCanRemoveRowOperator
    implements CanRemoveRowOperator {
  private final ItemId itemId;

  private ImmutableCanRemoveRowOperator(ItemId itemId) {
    this.itemId = Objects.requireNonNull(itemId, "itemId");
  }

  private ImmutableCanRemoveRowOperator(ImmutableCanRemoveRowOperator original, ItemId itemId) {
    this.itemId = itemId;
  }

  /**
   * @return The value of the {@code itemId} attribute
   */
  @Override
  public ItemId getItemId() {
    return itemId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CanRemoveRowOperator#getItemId() itemId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCanRemoveRowOperator withItemId(ItemId value) {
    if (this.itemId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "itemId");
    return new ImmutableCanRemoveRowOperator(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCanRemoveRowOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCanRemoveRowOperator
        && equalTo((ImmutableCanRemoveRowOperator) another);
  }

  private boolean equalTo(ImmutableCanRemoveRowOperator another) {
    return itemId.equals(another.itemId);
  }

  /**
   * Computes a hash code from attributes: {@code itemId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + itemId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CanRemoveRowOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CanRemoveRowOperator")
        .omitNullValues()
        .add("itemId", itemId)
        .toString();
  }

  /**
   * Construct a new immutable {@code CanRemoveRowOperator} instance.
   * @param itemId The value for the {@code itemId} attribute
   * @return An immutable CanRemoveRowOperator instance
   */
  public static ImmutableCanRemoveRowOperator of(ItemId itemId) {
    return new ImmutableCanRemoveRowOperator(itemId);
  }

  /**
   * Creates an immutable copy of a {@link CanRemoveRowOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CanRemoveRowOperator instance
   */
  public static ImmutableCanRemoveRowOperator copyOf(CanRemoveRowOperator instance) {
    if (instance instanceof ImmutableCanRemoveRowOperator) {
      return (ImmutableCanRemoveRowOperator) instance;
    }
    return ImmutableCanRemoveRowOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCanRemoveRowOperator ImmutableCanRemoveRowOperator}.
   * <pre>
   * ImmutableCanRemoveRowOperator.builder()
   *    .itemId(io.dialob.session.engine.session.model.ItemId) // required {@link CanRemoveRowOperator#getItemId() itemId}
   *    .build();
   * </pre>
   * @return A new ImmutableCanRemoveRowOperator builder
   */
  public static ImmutableCanRemoveRowOperator.Builder builder() {
    return new ImmutableCanRemoveRowOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCanRemoveRowOperator ImmutableCanRemoveRowOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CanRemoveRowOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ITEM_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId itemId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CanRemoveRowOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CanRemoveRowOperator instance) {
      Objects.requireNonNull(instance, "instance");
      itemId(instance.getItemId());
      return this;
    }

    /**
     * Initializes the value for the {@link CanRemoveRowOperator#getItemId() itemId} attribute.
     * @param itemId The value for itemId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemId(ItemId itemId) {
      this.itemId = Objects.requireNonNull(itemId, "itemId");
      initBits &= ~INIT_BIT_ITEM_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCanRemoveRowOperator ImmutableCanRemoveRowOperator}.
     * @return An immutable instance of CanRemoveRowOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCanRemoveRowOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCanRemoveRowOperator(null, itemId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ITEM_ID) != 0) attributes.add("itemId");
      return "Cannot build CanRemoveRowOperator, some of required attributes are not set " + attributes;
    }
  }
}
