package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ArrayReducerOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableArrayReducerOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableArrayReducerOperator.of()}.
 */
@Generated(from = "ArrayReducerOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableArrayReducerOperator<T>
    implements ArrayReducerOperator<T> {
  private final BinaryOperator<T> reducer;
  private final Expression arrayExpression;
  private final @Nullable Object placeholderValue;

  private ImmutableArrayReducerOperator(
      BinaryOperator<T> reducer,
      Expression arrayExpression) {
    this.reducer = Objects.requireNonNull(reducer, "reducer");
    this.arrayExpression = Objects.requireNonNull(arrayExpression, "arrayExpression");
    this.placeholderValue = ArrayReducerOperator.super.getPlaceholderValue();
  }

  private ImmutableArrayReducerOperator(ImmutableArrayReducerOperator.Builder<T> builder) {
    this.reducer = builder.reducer;
    this.arrayExpression = builder.arrayExpression;
    this.placeholderValue = builder.placeholderValueIsSet()
        ? builder.placeholderValue
        : ArrayReducerOperator.super.getPlaceholderValue();
  }

  private ImmutableArrayReducerOperator(
      BinaryOperator<T> reducer,
      Expression arrayExpression,
      @Nullable Object placeholderValue) {
    this.reducer = reducer;
    this.arrayExpression = arrayExpression;
    this.placeholderValue = placeholderValue;
  }

  /**
   * @return The value of the {@code reducer} attribute
   */
  @Override
  public BinaryOperator<T> getReducer() {
    return reducer;
  }

  /**
   * @return The value of the {@code arrayExpression} attribute
   */
  @Override
  public Expression getArrayExpression() {
    return arrayExpression;
  }

  /**
   * @return The value of the {@code placeholderValue} attribute
   */
  @Override
  public @Nullable Object getPlaceholderValue() {
    return placeholderValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArrayReducerOperator#getReducer() reducer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reducer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArrayReducerOperator<T> withReducer(BinaryOperator<T> value) {
    if (this.reducer == value) return this;
    BinaryOperator<T> newValue = Objects.requireNonNull(value, "reducer");
    return new ImmutableArrayReducerOperator<>(newValue, this.arrayExpression, this.placeholderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArrayReducerOperator#getArrayExpression() arrayExpression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for arrayExpression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArrayReducerOperator<T> withArrayExpression(Expression value) {
    if (this.arrayExpression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "arrayExpression");
    return new ImmutableArrayReducerOperator<>(this.reducer, newValue, this.placeholderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArrayReducerOperator#getPlaceholderValue() placeholderValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for placeholderValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArrayReducerOperator<T> withPlaceholderValue(@Nullable Object value) {
    if (this.placeholderValue == value) return this;
    return new ImmutableArrayReducerOperator<>(this.reducer, this.arrayExpression, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableArrayReducerOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableArrayReducerOperator<?>
        && equalTo((ImmutableArrayReducerOperator<?>) another);
  }

  private boolean equalTo(ImmutableArrayReducerOperator<?> another) {
    return reducer.equals(another.reducer)
        && arrayExpression.equals(another.arrayExpression)
        && Objects.equals(placeholderValue, another.placeholderValue);
  }

  /**
   * Computes a hash code from attributes: {@code reducer}, {@code arrayExpression}, {@code placeholderValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + reducer.hashCode();
    h += (h << 5) + arrayExpression.hashCode();
    h += (h << 5) + Objects.hashCode(placeholderValue);
    return h;
  }

  /**
   * Prints the immutable value {@code ArrayReducerOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ArrayReducerOperator")
        .omitNullValues()
        .add("reducer", reducer)
        .add("arrayExpression", arrayExpression)
        .add("placeholderValue", placeholderValue)
        .toString();
  }

  /**
   * Construct a new immutable {@code ArrayReducerOperator} instance.
 * @param <T> generic parameter T
   * @param reducer The value for the {@code reducer} attribute
   * @param arrayExpression The value for the {@code arrayExpression} attribute
   * @return An immutable ArrayReducerOperator instance
   */
  public static <T> ImmutableArrayReducerOperator<T> of(BinaryOperator<T> reducer, Expression arrayExpression) {
    return new ImmutableArrayReducerOperator<>(reducer, arrayExpression);
  }

  /**
   * Creates an immutable copy of a {@link ArrayReducerOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ArrayReducerOperator instance
   */
  public static <T> ImmutableArrayReducerOperator<T> copyOf(ArrayReducerOperator<T> instance) {
    if (instance instanceof ImmutableArrayReducerOperator<?>) {
      return (ImmutableArrayReducerOperator<T>) instance;
    }
    return ImmutableArrayReducerOperator.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableArrayReducerOperator ImmutableArrayReducerOperator}.
   * <pre>
   * ImmutableArrayReducerOperator.&amp;lt;T&amp;gt;builder()
   *    .reducer(function.BinaryOperator&amp;lt;T&amp;gt;) // required {@link ArrayReducerOperator#getReducer() reducer}
   *    .arrayExpression(io.dialob.session.engine.program.model.Expression) // required {@link ArrayReducerOperator#getArrayExpression() arrayExpression}
   *    .placeholderValue(Object | null) // nullable {@link ArrayReducerOperator#getPlaceholderValue() placeholderValue}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableArrayReducerOperator builder
   */
  public static <T> ImmutableArrayReducerOperator.Builder<T> builder() {
    return new ImmutableArrayReducerOperator.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableArrayReducerOperator ImmutableArrayReducerOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ArrayReducerOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_REDUCER = 0x1L;
    private static final long INIT_BIT_ARRAY_EXPRESSION = 0x2L;
    private static final long OPT_BIT_PLACEHOLDER_VALUE = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @javax.annotation.Nullable BinaryOperator<T> reducer;
    private @javax.annotation.Nullable Expression arrayExpression;
    private @javax.annotation.Nullable Object placeholderValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ArrayReducerOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(ArrayReducerOperator<T> instance) {
      Objects.requireNonNull(instance, "instance");
      reducer(instance.getReducer());
      arrayExpression(instance.getArrayExpression());
      @Nullable Object placeholderValueValue = instance.getPlaceholderValue();
      if (placeholderValueValue != null) {
        placeholderValue(placeholderValueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ArrayReducerOperator#getReducer() reducer} attribute.
     * @param reducer The value for reducer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> reducer(BinaryOperator<T> reducer) {
      this.reducer = Objects.requireNonNull(reducer, "reducer");
      initBits &= ~INIT_BIT_REDUCER;
      return this;
    }

    /**
     * Initializes the value for the {@link ArrayReducerOperator#getArrayExpression() arrayExpression} attribute.
     * @param arrayExpression The value for arrayExpression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> arrayExpression(Expression arrayExpression) {
      this.arrayExpression = Objects.requireNonNull(arrayExpression, "arrayExpression");
      initBits &= ~INIT_BIT_ARRAY_EXPRESSION;
      return this;
    }

    /**
     * Initializes the value for the {@link ArrayReducerOperator#getPlaceholderValue() placeholderValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ArrayReducerOperator#getPlaceholderValue() placeholderValue}.</em>
     * @param placeholderValue The value for placeholderValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> placeholderValue(@Nullable Object placeholderValue) {
      this.placeholderValue = placeholderValue;
      optBits |= OPT_BIT_PLACEHOLDER_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableArrayReducerOperator ImmutableArrayReducerOperator}.
     * @return An immutable instance of ArrayReducerOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableArrayReducerOperator<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableArrayReducerOperator<T>(this);
    }

    private boolean placeholderValueIsSet() {
      return (optBits & OPT_BIT_PLACEHOLDER_VALUE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REDUCER) != 0) attributes.add("reducer");
      if ((initBits & INIT_BIT_ARRAY_EXPRESSION) != 0) attributes.add("arrayExpression");
      return "Cannot build ArrayReducerOperator, some of required attributes are not set " + attributes;
    }
  }
}
