package io.dialob.session.engine.program.expr;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NotOnPageExpression}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNotOnPageExpression.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNotOnPageExpression.of()}.
 */
@Generated(from = "NotOnPageExpression", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNotOnPageExpression
    implements NotOnPageExpression {
  private final ItemId page;

  private ImmutableNotOnPageExpression(ItemId page) {
    this.page = Objects.requireNonNull(page, "page");
  }

  private ImmutableNotOnPageExpression(ImmutableNotOnPageExpression original, ItemId page) {
    this.page = page;
  }

  /**
   * @return The value of the {@code page} attribute
   */
  @Override
  public ItemId getPage() {
    return page;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NotOnPageExpression#getPage() page} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for page
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNotOnPageExpression withPage(ItemId value) {
    if (this.page == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "page");
    return new ImmutableNotOnPageExpression(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNotOnPageExpression} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNotOnPageExpression
        && equalTo((ImmutableNotOnPageExpression) another);
  }

  private boolean equalTo(ImmutableNotOnPageExpression another) {
    return page.equals(another.page);
  }

  /**
   * Computes a hash code from attributes: {@code page}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + page.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NotOnPageExpression} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NotOnPageExpression")
        .omitNullValues()
        .add("page", page)
        .toString();
  }

  /**
   * Construct a new immutable {@code NotOnPageExpression} instance.
   * @param page The value for the {@code page} attribute
   * @return An immutable NotOnPageExpression instance
   */
  public static ImmutableNotOnPageExpression of(ItemId page) {
    return new ImmutableNotOnPageExpression(page);
  }

  /**
   * Creates an immutable copy of a {@link NotOnPageExpression} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NotOnPageExpression instance
   */
  public static ImmutableNotOnPageExpression copyOf(NotOnPageExpression instance) {
    if (instance instanceof ImmutableNotOnPageExpression) {
      return (ImmutableNotOnPageExpression) instance;
    }
    return ImmutableNotOnPageExpression.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNotOnPageExpression ImmutableNotOnPageExpression}.
   * <pre>
   * ImmutableNotOnPageExpression.builder()
   *    .page(io.dialob.session.engine.session.model.ItemId) // required {@link NotOnPageExpression#getPage() page}
   *    .build();
   * </pre>
   * @return A new ImmutableNotOnPageExpression builder
   */
  public static ImmutableNotOnPageExpression.Builder builder() {
    return new ImmutableNotOnPageExpression.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNotOnPageExpression ImmutableNotOnPageExpression}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NotOnPageExpression", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PAGE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId page;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NotOnPageExpression} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NotOnPageExpression instance) {
      Objects.requireNonNull(instance, "instance");
      page(instance.getPage());
      return this;
    }

    /**
     * Initializes the value for the {@link NotOnPageExpression#getPage() page} attribute.
     * @param page The value for page 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder page(ItemId page) {
      this.page = Objects.requireNonNull(page, "page");
      initBits &= ~INIT_BIT_PAGE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNotOnPageExpression ImmutableNotOnPageExpression}.
     * @return An immutable instance of NotOnPageExpression
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNotOnPageExpression build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNotOnPageExpression(null, page);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PAGE) != 0) attributes.add("page");
      return "Cannot build NotOnPageExpression, some of required attributes are not set " + attributes;
    }
  }
}
