package io.dialob.session.engine.program;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.FormValidationError;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.spi.AliasesProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableProgramBuilder} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link ProgramBuilder}.
 * @see ImmutableProgramBuilder.CompilableExpression
 */
@Generated(from = "ProgramBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableProgramBuilder {
  private ImmutableProgramBuilder() {}

  /**
   * Immutable implementation of {@link ProgramBuilder.CompilableExpression}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableProgramBuilder.CompilableExpression.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableProgramBuilder.CompilableExpression.of()}.
   */
  @Generated(from = "ProgramBuilder.CompilableExpression", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class CompilableExpression
      implements ProgramBuilder.CompilableExpression {
    private final ItemId itemId;
    private final String expression;
    private final AliasesProvider aliasesProvider;
    private final Consumer<Expression> expressionConsumer;
    private final FormValidationError.Type type;
    private final @Nullable Integer index;

    private CompilableExpression(
        ItemId itemId,
        String expression,
        AliasesProvider aliasesProvider,
        Consumer<Expression> expressionConsumer,
        FormValidationError.Type type,
        Optional<Integer> index) {
      this.itemId = Objects.requireNonNull(itemId, "itemId");
      this.expression = Objects.requireNonNull(expression, "expression");
      this.aliasesProvider = Objects.requireNonNull(aliasesProvider, "aliasesProvider");
      this.expressionConsumer = Objects.requireNonNull(expressionConsumer, "expressionConsumer");
      this.type = Objects.requireNonNull(type, "type");
      this.index = index.orElse(null);
    }

    private CompilableExpression(
        ImmutableProgramBuilder.CompilableExpression original,
        ItemId itemId,
        String expression,
        AliasesProvider aliasesProvider,
        Consumer<Expression> expressionConsumer,
        FormValidationError.Type type,
        @Nullable Integer index) {
      this.itemId = itemId;
      this.expression = expression;
      this.aliasesProvider = aliasesProvider;
      this.expressionConsumer = expressionConsumer;
      this.type = type;
      this.index = index;
    }

    /**
     * @return The value of the {@code itemId} attribute
     */
    @Override
    public ItemId getItemId() {
      return itemId;
    }

    /**
     * @return The value of the {@code expression} attribute
     */
    @Override
    public String getExpression() {
      return expression;
    }

    /**
     * @return The value of the {@code aliasesProvider} attribute
     */
    @Override
    public AliasesProvider getAliasesProvider() {
      return aliasesProvider;
    }

    /**
     * @return The value of the {@code expressionConsumer} attribute
     */
    @Override
    public Consumer<Expression> getExpressionConsumer() {
      return expressionConsumer;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @Override
    public FormValidationError.Type getType() {
      return type;
    }

    /**
     * @return The value of the {@code index} attribute
     */
    @Override
    public Optional<Integer> getIndex() {
      return Optional.ofNullable(index);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ProgramBuilder.CompilableExpression#getItemId() itemId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for itemId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProgramBuilder.CompilableExpression withItemId(ItemId value) {
      if (this.itemId == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "itemId");
      return new ImmutableProgramBuilder.CompilableExpression(
          this,
          newValue,
          this.expression,
          this.aliasesProvider,
          this.expressionConsumer,
          this.type,
          this.index);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ProgramBuilder.CompilableExpression#getExpression() expression} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for expression
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProgramBuilder.CompilableExpression withExpression(String value) {
      String newValue = Objects.requireNonNull(value, "expression");
      if (this.expression.equals(newValue)) return this;
      return new ImmutableProgramBuilder.CompilableExpression(
          this,
          this.itemId,
          newValue,
          this.aliasesProvider,
          this.expressionConsumer,
          this.type,
          this.index);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ProgramBuilder.CompilableExpression#getAliasesProvider() aliasesProvider} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for aliasesProvider
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProgramBuilder.CompilableExpression withAliasesProvider(AliasesProvider value) {
      if (this.aliasesProvider == value) return this;
      AliasesProvider newValue = Objects.requireNonNull(value, "aliasesProvider");
      return new ImmutableProgramBuilder.CompilableExpression(this, this.itemId, this.expression, newValue, this.expressionConsumer, this.type, this.index);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ProgramBuilder.CompilableExpression#getExpressionConsumer() expressionConsumer} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for expressionConsumer
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProgramBuilder.CompilableExpression withExpressionConsumer(Consumer<Expression> value) {
      if (this.expressionConsumer == value) return this;
      Consumer<Expression> newValue = Objects.requireNonNull(value, "expressionConsumer");
      return new ImmutableProgramBuilder.CompilableExpression(this, this.itemId, this.expression, this.aliasesProvider, newValue, this.type, this.index);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ProgramBuilder.CompilableExpression#getType() type} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for type
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProgramBuilder.CompilableExpression withType(FormValidationError.Type value) {
      if (this.type == value) return this;
      FormValidationError.Type newValue = Objects.requireNonNull(value, "type");
      if (this.type.equals(newValue)) return this;
      return new ImmutableProgramBuilder.CompilableExpression(
          this,
          this.itemId,
          this.expression,
          this.aliasesProvider,
          this.expressionConsumer,
          newValue,
          this.index);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ProgramBuilder.CompilableExpression#getIndex() index} attribute.
     * @param value The value for index
     * @return A modified copy of {@code this} object
     */
    public final ImmutableProgramBuilder.CompilableExpression withIndex(int value) {
      @Nullable Integer newValue = value;
      if (Objects.equals(this.index, newValue)) return this;
      return new ImmutableProgramBuilder.CompilableExpression(
          this,
          this.itemId,
          this.expression,
          this.aliasesProvider,
          this.expressionConsumer,
          this.type,
          newValue);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ProgramBuilder.CompilableExpression#getIndex() index} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for index
     * @return A modified copy of {@code this} object
     */
    public final ImmutableProgramBuilder.CompilableExpression withIndex(Optional<Integer> optional) {
      @Nullable Integer value = optional.orElse(null);
      if (Objects.equals(this.index, value)) return this;
      return new ImmutableProgramBuilder.CompilableExpression(
          this,
          this.itemId,
          this.expression,
          this.aliasesProvider,
          this.expressionConsumer,
          this.type,
          value);
    }

    /**
     * This instance is equal to all instances of {@code CompilableExpression} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableProgramBuilder.CompilableExpression
          && equalTo((ImmutableProgramBuilder.CompilableExpression) another);
    }

    private boolean equalTo(ImmutableProgramBuilder.CompilableExpression another) {
      return itemId.equals(another.itemId)
          && expression.equals(another.expression)
          && aliasesProvider.equals(another.aliasesProvider)
          && expressionConsumer.equals(another.expressionConsumer)
          && type.equals(another.type)
          && Objects.equals(index, another.index);
    }

    /**
     * Computes a hash code from attributes: {@code itemId}, {@code expression}, {@code aliasesProvider}, {@code expressionConsumer}, {@code type}, {@code index}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + itemId.hashCode();
      h += (h << 5) + expression.hashCode();
      h += (h << 5) + aliasesProvider.hashCode();
      h += (h << 5) + expressionConsumer.hashCode();
      h += (h << 5) + type.hashCode();
      h += (h << 5) + Objects.hashCode(index);
      return h;
    }

    /**
     * Prints the immutable value {@code CompilableExpression} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("CompilableExpression")
          .omitNullValues()
          .add("itemId", itemId)
          .add("expression", expression)
          .add("aliasesProvider", aliasesProvider)
          .add("expressionConsumer", expressionConsumer)
          .add("type", type)
          .add("index", index)
          .toString();
    }

    /**
     * Construct a new immutable {@code CompilableExpression} instance.
     * @param itemId The value for the {@code itemId} attribute
     * @param expression The value for the {@code expression} attribute
     * @param aliasesProvider The value for the {@code aliasesProvider} attribute
     * @param expressionConsumer The value for the {@code expressionConsumer} attribute
     * @param type The value for the {@code type} attribute
     * @param index The value for the {@code index} attribute
     * @return An immutable CompilableExpression instance
     */
    public static ImmutableProgramBuilder.CompilableExpression of(ItemId itemId, String expression, AliasesProvider aliasesProvider, Consumer<Expression> expressionConsumer, FormValidationError.Type type, Optional<Integer> index) {
      return new ImmutableProgramBuilder.CompilableExpression(itemId, expression, aliasesProvider, expressionConsumer, type, index);
    }

    /**
     * Creates an immutable copy of a {@link ProgramBuilder.CompilableExpression} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable CompilableExpression instance
     */
    public static ImmutableProgramBuilder.CompilableExpression copyOf(ProgramBuilder.CompilableExpression instance) {
      if (instance instanceof ImmutableProgramBuilder.CompilableExpression) {
        return (ImmutableProgramBuilder.CompilableExpression) instance;
      }
      return ImmutableProgramBuilder.CompilableExpression.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableProgramBuilder.CompilableExpression CompilableExpression}.
     * <pre>
     * ImmutableProgramBuilder.CompilableExpression.builder()
     *    .itemId(io.dialob.session.engine.session.model.ItemId) // required {@link ProgramBuilder.CompilableExpression#getItemId() itemId}
     *    .expression(String) // required {@link ProgramBuilder.CompilableExpression#getExpression() expression}
     *    .aliasesProvider(io.dialob.session.engine.spi.AliasesProvider) // required {@link ProgramBuilder.CompilableExpression#getAliasesProvider() aliasesProvider}
     *    .expressionConsumer(function.Consumer&amp;lt;io.dialob.session.engine.program.model.Expression&amp;gt;) // required {@link ProgramBuilder.CompilableExpression#getExpressionConsumer() expressionConsumer}
     *    .type(io.dialob.api.form.FormValidationError.Type) // required {@link ProgramBuilder.CompilableExpression#getType() type}
     *    .index(Integer) // optional {@link ProgramBuilder.CompilableExpression#getIndex() index}
     *    .build();
     * </pre>
     * @return A new CompilableExpression builder
     */
    public static ImmutableProgramBuilder.CompilableExpression.Builder builder() {
      return new ImmutableProgramBuilder.CompilableExpression.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableProgramBuilder.CompilableExpression CompilableExpression}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "ProgramBuilder.CompilableExpression", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_ITEM_ID = 0x1L;
      private static final long INIT_BIT_EXPRESSION = 0x2L;
      private static final long INIT_BIT_ALIASES_PROVIDER = 0x4L;
      private static final long INIT_BIT_EXPRESSION_CONSUMER = 0x8L;
      private static final long INIT_BIT_TYPE = 0x10L;
      private long initBits = 0x1fL;

      private @Nullable ItemId itemId;
      private @Nullable String expression;
      private @Nullable AliasesProvider aliasesProvider;
      private @Nullable Consumer<Expression> expressionConsumer;
      private @Nullable FormValidationError.Type type;
      private @Nullable Integer index;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code CompilableExpression} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ProgramBuilder.CompilableExpression instance) {
        Objects.requireNonNull(instance, "instance");
        itemId(instance.getItemId());
        expression(instance.getExpression());
        aliasesProvider(instance.getAliasesProvider());
        expressionConsumer(instance.getExpressionConsumer());
        type(instance.getType());
        Optional<Integer> indexOptional = instance.getIndex();
        if (indexOptional.isPresent()) {
          index(indexOptional);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link ProgramBuilder.CompilableExpression#getItemId() itemId} attribute.
       * @param itemId The value for itemId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder itemId(ItemId itemId) {
        this.itemId = Objects.requireNonNull(itemId, "itemId");
        initBits &= ~INIT_BIT_ITEM_ID;
        return this;
      }

      /**
       * Initializes the value for the {@link ProgramBuilder.CompilableExpression#getExpression() expression} attribute.
       * @param expression The value for expression 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder expression(String expression) {
        this.expression = Objects.requireNonNull(expression, "expression");
        initBits &= ~INIT_BIT_EXPRESSION;
        return this;
      }

      /**
       * Initializes the value for the {@link ProgramBuilder.CompilableExpression#getAliasesProvider() aliasesProvider} attribute.
       * @param aliasesProvider The value for aliasesProvider 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder aliasesProvider(AliasesProvider aliasesProvider) {
        this.aliasesProvider = Objects.requireNonNull(aliasesProvider, "aliasesProvider");
        initBits &= ~INIT_BIT_ALIASES_PROVIDER;
        return this;
      }

      /**
       * Initializes the value for the {@link ProgramBuilder.CompilableExpression#getExpressionConsumer() expressionConsumer} attribute.
       * @param expressionConsumer The value for expressionConsumer 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder expressionConsumer(Consumer<Expression> expressionConsumer) {
        this.expressionConsumer = Objects.requireNonNull(expressionConsumer, "expressionConsumer");
        initBits &= ~INIT_BIT_EXPRESSION_CONSUMER;
        return this;
      }

      /**
       * Initializes the value for the {@link ProgramBuilder.CompilableExpression#getType() type} attribute.
       * @param type The value for type 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder type(FormValidationError.Type type) {
        this.type = Objects.requireNonNull(type, "type");
        initBits &= ~INIT_BIT_TYPE;
        return this;
      }

      /**
       * Initializes the optional value {@link ProgramBuilder.CompilableExpression#getIndex() index} to index.
       * @param index The value for index
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder index(int index) {
        this.index = index;
        return this;
      }

      /**
       * Initializes the optional value {@link ProgramBuilder.CompilableExpression#getIndex() index} to index.
       * @param index The value for index
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder index(Optional<Integer> index) {
        this.index = index.orElse(null);
        return this;
      }

      /**
       * Builds a new {@link ImmutableProgramBuilder.CompilableExpression CompilableExpression}.
       * @return An immutable instance of CompilableExpression
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableProgramBuilder.CompilableExpression build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableProgramBuilder.CompilableExpression(null, itemId, expression, aliasesProvider, expressionConsumer, type, index);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_ITEM_ID) != 0) attributes.add("itemId");
        if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
        if ((initBits & INIT_BIT_ALIASES_PROVIDER) != 0) attributes.add("aliasesProvider");
        if ((initBits & INIT_BIT_EXPRESSION_CONSUMER) != 0) attributes.add("expressionConsumer");
        if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
        return "Cannot build CompilableExpression, some of required attributes are not set " + attributes;
      }
    }
  }
}
