/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.sp;

import io.dialob.api.form.Form;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.questionnaire.service.api.session.BaseQuestionnaireSessionBuilder;
import io.dialob.questionnaire.service.api.session.FormFinder;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import io.dialob.session.engine.DialobProgramService;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.DialobProgram;
import io.dialob.session.engine.program.DialobSessionEvalContextFactory;
import io.dialob.session.engine.program.model.VariableItem;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ValueSetState;
import io.dialob.session.engine.sp.AsyncFunctionInvoker;
import io.dialob.session.engine.sp.DialobQuestionnaireSession;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobQuestionnaireSessionBuilder
extends BaseQuestionnaireSessionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobQuestionnaireSessionBuilder.class);
    private final QuestionnaireEventPublisher eventPublisher;
    private final DialobProgramService dialobProgramService;
    private final QuestionnaireSessionSaveService questionnaireSessionSaveService;
    private final DialobSessionEvalContextFactory sessionContextFactory;
    private final AsyncFunctionInvoker asyncFunctionInvoker;

    public DialobQuestionnaireSessionBuilder(@Nonnull QuestionnaireEventPublisher eventPublisher, @Nonnull DialobProgramService dialobProgramService, @Nonnull FormFinder formFinder, @Nonnull QuestionnaireSessionSaveService questionnaireSessionSaveService, @Nonnull DialobSessionEvalContextFactory sessionContextFactory, @Nonnull AsyncFunctionInvoker asyncFunctionInvoker) {
        super(formFinder);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.dialobProgramService = Objects.requireNonNull(dialobProgramService);
        this.questionnaireSessionSaveService = Objects.requireNonNull(questionnaireSessionSaveService);
        this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory);
        this.asyncFunctionInvoker = Objects.requireNonNull(asyncFunctionInvoker);
    }

    @Nonnull
    protected QuestionnaireSession createQuestionnaireSession(boolean newSession, @Nonnull Form formDocument) {
        Questionnaire questionnaire = this.getQuestionnaire();
        DialobProgram dialobProgram = this.dialobProgramService.findByFormIdAndRev(formDocument.getId(), formDocument.getRev());
        DialobSession dialobSession = dialobProgram.createSession(this.sessionContextFactory, formDocument.getMetadata().getTenantId(), questionnaire.getId(), this.getLanguage(), questionnaire.getActiveItem(), (itemId, item) -> {
            String id = IdUtils.toString(itemId);
            if (item instanceof VariableItem) {
                for (ContextValue contextValue : questionnaire.getContext()) {
                    if (!id.equals(contextValue.getId())) continue;
                    return Optional.ofNullable(Utils.parse(item.getValueType(), contextValue.getValue()));
                }
                for (VariableValue variableValue : questionnaire.getVariableValues()) {
                    if (!id.equals(variableValue.getId())) continue;
                    return Optional.ofNullable(Utils.parse(item.getValueType(), variableValue.getValue()));
                }
            } else {
                for (Answer answer : questionnaire.getAnswers()) {
                    if (!id.equals(answer.getId())) continue;
                    return Optional.ofNullable(answer.getValue());
                }
            }
            return Optional.empty();
        }, valueSetId -> questionnaire.getValueSets().stream().filter(valueSet -> valueSet.getId().equals(valueSetId.getValueSetId())).findFirst().map(valueSet -> valueSet.getEntries().stream().map(entry -> ValueSetState.Entry.of(entry.getKey(), entry.getValue(), true)).collect(Collectors.toList())).orElse(Collections.emptyList()), questionnaire.getMetadata().getCompleted(), questionnaire.getMetadata().getOpened(), questionnaire.getMetadata().getLastAnswer());
        if (questionnaire.getMetadata().getStatus() == Questionnaire.Metadata.Status.COMPLETED) {
            dialobSession.complete();
        }
        DialobQuestionnaireSession dialobQuestionnaireSession = null;
        try {
            dialobQuestionnaireSession = DialobQuestionnaireSession.builder().eventPublisher(this.eventPublisher).sessionContextFactory(this.sessionContextFactory).asyncFunctionInvoker(this.asyncFunctionInvoker).dialobSession(dialobSession).dialobProgram(dialobProgram).rev(questionnaire.getRev()).metadata(questionnaire.getMetadata()).questionClientVisibility(this.getQuestionClientVisibility(formDocument)).build();
            if (newSession) {
                dialobQuestionnaireSession = this.save(dialobQuestionnaireSession);
                if (!this.isCreateOnly()) {
                    dialobQuestionnaireSession.initialize();
                }
            }
            dialobQuestionnaireSession.activate();
            return dialobQuestionnaireSession;
        }
        catch (Exception e) {
            if (dialobQuestionnaireSession != null) {
                dialobQuestionnaireSession.close();
            }
            throw e;
        }
    }

    @Nonnull
    protected DialobQuestionnaireSession save(DialobQuestionnaireSession dialobQuestionnaireSession) {
        return (DialobQuestionnaireSession)this.questionnaireSessionSaveService.save((QuestionnaireSession)dialobQuestionnaireSession);
    }

    private QuestionnaireSession.QuestionClientVisibility getQuestionClientVisibility(Form formDocument) {
        QuestionnaireSession.QuestionClientVisibility questionClientVisibility = QuestionnaireSession.QuestionClientVisibility.ONLY_ENABLED;
        Object o = formDocument.getMetadata().getAdditionalProperties().get("questionClientVisibility");
        if (o instanceof String) {
            try {
                return QuestionnaireSession.QuestionClientVisibility.valueOf((String)((String)o));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Unknown question client visibility {}", o);
            }
        }
        if ((o = formDocument.getMetadata().getAdditionalProperties().get("showDisabled")) != null) {
            boolean showDisabled = false;
            if (o instanceof String) {
                showDisabled = Boolean.parseBoolean((String)o);
            } else if (o instanceof Boolean) {
                showDisabled = (Boolean)o;
            }
            if (showDisabled) {
                questionClientVisibility = QuestionnaireSession.QuestionClientVisibility.SHOW_DISABLED;
            }
        }
        return questionClientVisibility;
    }
}

