/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command.event;

import com.google.common.collect.Sets;
import io.dialob.session.engine.session.command.Triggers;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.command.event.ImmutableItemRemovedEvent;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.HashSet;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public interface RowItemsRemovedEventsProvider
extends Triggers.EventsProvider<ItemStates> {
    @Value.Parameter
    public ItemId getRowProtoTypeId();

    @Override
    default public Stream<Event> createEvents(ItemStates originalState, ItemStates updatedState) {
        if (originalState == null && updatedState == null) {
            return Stream.of(ImmutableItemRemovedEvent.of(this.getRowProtoTypeId()));
        }
        if (originalState == null) {
            return Stream.empty();
        }
        HashSet removedItems = originalState.getItemStates().keySet();
        if (updatedState != null) {
            removedItems = Sets.newHashSet(removedItems);
            removedItems.removeAll(updatedState.getItemStates().keySet());
        }
        return removedItems.stream().map(ImmutableItemRemovedEvent::of);
    }
}

