/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command.event;

import com.google.common.collect.Sets;
import io.dialob.session.engine.session.command.Triggers;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.command.event.ImmutableItemAddedEvent;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public interface ProtoTypeItemsAddedEventsProvider
extends Triggers.EventsProvider<ItemStates> {
    @Value.Parameter
    public List<ItemId> getItemPrototypeIds();

    @Override
    default public Stream<Event> createEvents(ItemStates originalState, ItemStates updatedState) {
        if (originalState == null && updatedState == null) {
            return this.getItemPrototypeIds().stream().map(itemId -> ImmutableItemAddedEvent.of(itemId, itemId));
        }
        if (updatedState == null) {
            return Stream.empty();
        }
        HashSet newItems = updatedState.getItemStates().keySet();
        if (originalState != null) {
            newItems = Sets.newHashSet(newItems);
            newItems.removeAll(originalState.getItemStates().keySet());
        }
        return newItems.stream().flatMap(itemId -> this.getItemPrototypeIds().stream().filter(itemPrototypeId -> IdUtils.matches(itemPrototypeId, itemId)).findFirst().map(foundPrototypeId -> ImmutableItemAddedEvent.of(itemId, foundPrototypeId)).map(Stream::of).orElseGet(Stream::empty));
    }
}

