/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface UpdateClassNames
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Value.Parameter(order=1)
    public Expression getExpression();

    @Override
    @Nonnull
    default public Set<EventMatcher> getEventMatchers() {
        Set<EventMatcher> eventMatchers = this.getExpression().getEvalRequiredConditions();
        if (this.getTargetId().isPartial()) {
            return Sets.union(eventMatchers, (Set)ImmutableSet.of((Object)EventMatchers.whenItemAdded(this.getTargetId())));
        }
        return eventMatchers;
    }

    @Override
    @Nonnull
    default public ItemState update(@Nonnull EvalContext context, @Nonnull ItemState itemState) {
        return itemState.update().setClassNames(this.evalExpression(context)).get();
    }

    default public List<String> evalExpression(EvalContext context) {
        List stringValues = (List)this.getExpression().eval(context);
        if (stringValues == null) {
            return Collections.emptyList();
        }
        return stringValues.stream().map(stringValue -> (String)stringValue.eval(context)).collect(Collectors.toList());
    }
}

