/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.command.CreateRowGroupItemsFromPrototypeCommand;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateRowGroupItemsFromPrototypeCommand", generator="Immutables")
@Immutable
public final class ImmutableCreateRowGroupItemsFromPrototypeCommand
implements CreateRowGroupItemsFromPrototypeCommand {
    private final ImmutableList<Trigger<ItemStates>> triggers;
    private final ItemId targetId;
    private final ItemId itemPrototypeId;

    private ImmutableCreateRowGroupItemsFromPrototypeCommand(ItemId targetId, ItemId itemPrototypeId, Iterable<? extends Trigger<ItemStates>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.itemPrototypeId = Objects.requireNonNull(itemPrototypeId, "itemPrototypeId");
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableCreateRowGroupItemsFromPrototypeCommand(ImmutableCreateRowGroupItemsFromPrototypeCommand original, ImmutableList<Trigger<ItemStates>> triggers, ItemId targetId, ItemId itemPrototypeId) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.itemPrototypeId = itemPrototypeId;
    }

    @Override
    public ImmutableList<Trigger<ItemStates>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @Override
    public ItemId getItemPrototypeId() {
        return this.itemPrototypeId;
    }

    @SafeVarargs
    public final ImmutableCreateRowGroupItemsFromPrototypeCommand withTriggers(Trigger<ItemStates> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateRowGroupItemsFromPrototypeCommand(this, (ImmutableList<Trigger<ItemStates>>)newValue, this.targetId, this.itemPrototypeId);
    }

    public final ImmutableCreateRowGroupItemsFromPrototypeCommand withTriggers(Iterable<? extends Trigger<ItemStates>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateRowGroupItemsFromPrototypeCommand(this, (ImmutableList<Trigger<ItemStates>>)newValue, this.targetId, this.itemPrototypeId);
    }

    public final ImmutableCreateRowGroupItemsFromPrototypeCommand withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableCreateRowGroupItemsFromPrototypeCommand(this, this.triggers, newValue, this.itemPrototypeId);
    }

    public final ImmutableCreateRowGroupItemsFromPrototypeCommand withItemPrototypeId(ItemId value) {
        if (this.itemPrototypeId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "itemPrototypeId");
        return new ImmutableCreateRowGroupItemsFromPrototypeCommand(this, this.triggers, this.targetId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateRowGroupItemsFromPrototypeCommand && this.equalTo((ImmutableCreateRowGroupItemsFromPrototypeCommand)another);
    }

    private boolean equalTo(ImmutableCreateRowGroupItemsFromPrototypeCommand another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && this.itemPrototypeId.equals(another.itemPrototypeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + this.itemPrototypeId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateRowGroupItemsFromPrototypeCommand").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("itemPrototypeId", (Object)this.itemPrototypeId).toString();
    }

    public static ImmutableCreateRowGroupItemsFromPrototypeCommand of(ItemId targetId, ItemId itemPrototypeId, List<Trigger<ItemStates>> triggers) {
        return ImmutableCreateRowGroupItemsFromPrototypeCommand.of(targetId, itemPrototypeId, triggers);
    }

    public static ImmutableCreateRowGroupItemsFromPrototypeCommand of(ItemId targetId, ItemId itemPrototypeId, Iterable<? extends Trigger<ItemStates>> triggers) {
        return new ImmutableCreateRowGroupItemsFromPrototypeCommand(targetId, itemPrototypeId, triggers);
    }

    public static ImmutableCreateRowGroupItemsFromPrototypeCommand copyOf(CreateRowGroupItemsFromPrototypeCommand instance) {
        if (instance instanceof ImmutableCreateRowGroupItemsFromPrototypeCommand) {
            return (ImmutableCreateRowGroupItemsFromPrototypeCommand)instance;
        }
        return ImmutableCreateRowGroupItemsFromPrototypeCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateRowGroupItemsFromPrototypeCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private static final long INIT_BIT_ITEM_PROTOTYPE_ID = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<Trigger<ItemStates>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;
        @Nullable
        private ItemId itemPrototypeId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateRowGroupItemsFromPrototypeCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId((ItemId)instance.getTargetId());
            this.itemPrototypeId(instance.getItemPrototypeId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemStates> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemStates> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemStates>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemStates>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder itemPrototypeId(ItemId itemPrototypeId) {
            this.itemPrototypeId = Objects.requireNonNull(itemPrototypeId, "itemPrototypeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCreateRowGroupItemsFromPrototypeCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateRowGroupItemsFromPrototypeCommand(null, (ImmutableList<Trigger<ItemStates>>)this.triggers.build(), this.targetId, this.itemPrototypeId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("itemPrototypeId");
            }
            return "Cannot build CreateRowGroupItemsFromPrototypeCommand, some of required attributes are not set " + attributes;
        }
    }
}

