/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.collect.ImmutableList;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.command.AddRow;
import io.dialob.session.engine.session.command.Complete;
import io.dialob.session.engine.session.command.ErrorLabelUpdateCommand;
import io.dialob.session.engine.session.command.GotoPage;
import io.dialob.session.engine.session.command.ImmutableAddRow;
import io.dialob.session.engine.session.command.ImmutableComplete;
import io.dialob.session.engine.session.command.ImmutableCreateRowGroupFromPrototypeCommand;
import io.dialob.session.engine.session.command.ImmutableCreateRowGroupItemsFromPrototypeCommand;
import io.dialob.session.engine.session.command.ImmutableDeleteRow;
import io.dialob.session.engine.session.command.ImmutableErrorLabelUpdateCommand;
import io.dialob.session.engine.session.command.ImmutableGotoPage;
import io.dialob.session.engine.session.command.ImmutableInitGroupItems;
import io.dialob.session.engine.session.command.ImmutableInitRowGroupItemsCommand;
import io.dialob.session.engine.session.command.ImmutableNextPage;
import io.dialob.session.engine.session.command.ImmutableNopCommand;
import io.dialob.session.engine.session.command.ImmutablePrevPage;
import io.dialob.session.engine.session.command.ImmutableSetAnswer;
import io.dialob.session.engine.session.command.ImmutableSetLocale;
import io.dialob.session.engine.session.command.ImmutableSetRows;
import io.dialob.session.engine.session.command.ImmutableSetVariableFailed;
import io.dialob.session.engine.session.command.ImmutableSetVariableValue;
import io.dialob.session.engine.session.command.ImmutableUpdateActivityCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateAllowedActionsCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateAvailableItemsCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateClassNames;
import io.dialob.session.engine.session.command.ImmutableUpdateDescriptionCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateDisabledCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateGroupItems;
import io.dialob.session.engine.session.command.ImmutableUpdateIsInvalidAnswersCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateLabelCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateRequiredCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateRowCanBeRemovedCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateRowsCanBeAddedCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateValidationCommand;
import io.dialob.session.engine.session.command.ImmutableUpdateValueSetCommand;
import io.dialob.session.engine.session.command.ImmutableValidationDisabledUpdateCommand;
import io.dialob.session.engine.session.command.ImmutableVariableUpdateCommand;
import io.dialob.session.engine.session.command.InitRowGroupItemsCommand;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.command.NextPage;
import io.dialob.session.engine.session.command.PrevPage;
import io.dialob.session.engine.session.command.SessionUpdateCommand;
import io.dialob.session.engine.session.command.SetAnswer;
import io.dialob.session.engine.session.command.SetLocale;
import io.dialob.session.engine.session.command.SetRows;
import io.dialob.session.engine.session.command.SetVariableFailed;
import io.dialob.session.engine.session.command.SetVariableValue;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.command.Triggers;
import io.dialob.session.engine.session.command.UpdateActivityCommand;
import io.dialob.session.engine.session.command.UpdateAllowedActionsCommand;
import io.dialob.session.engine.session.command.UpdateAvailableItemsCommand;
import io.dialob.session.engine.session.command.UpdateClassNames;
import io.dialob.session.engine.session.command.UpdateDescriptionCommand;
import io.dialob.session.engine.session.command.UpdateDisabledCommand;
import io.dialob.session.engine.session.command.UpdateIsInvalidAnswersCommand;
import io.dialob.session.engine.session.command.UpdateLabelCommand;
import io.dialob.session.engine.session.command.UpdateRequiredCommand;
import io.dialob.session.engine.session.command.UpdateRowCanBeRemovedCommand;
import io.dialob.session.engine.session.command.UpdateRowsCanBeAddedCommand;
import io.dialob.session.engine.session.command.UpdateValidationCommand;
import io.dialob.session.engine.session.command.UpdateValueSetCommand;
import io.dialob.session.engine.session.command.ValidationDisabledUpdateCommand;
import io.dialob.session.engine.session.command.VariableUpdateCommand;
import io.dialob.session.engine.session.command.event.ImmutableProtoTypeItemsAddedEventsProvider;
import io.dialob.session.engine.session.command.event.ImmutableRowItemsAddedEventsProvider;
import io.dialob.session.engine.session.command.event.ImmutableRowItemsRemovedEventsProvider;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemIdPartial;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ItemStates;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;

public final class CommandFactory {
    private static final ImmutableList<Trigger<ItemState>> ACTIVE_PAGE_TRIGGERS = ImmutableList.of(Triggers.trigger(Triggers.activePageUpdatedEvent()).when(ItemStatePredicates.ITEM_STATE_CHANGED));
    private static final NextPage NEXT_PAGE = ImmutableNextPage.of(ACTIVE_PAGE_TRIGGERS);
    private static final PrevPage PREV_PAGE = ImmutablePrevPage.of(ACTIVE_PAGE_TRIGGERS);
    private static final Complete COMPLETE = ImmutableComplete.builder().build();

    private static boolean isNew(Object itemState, Object updateState) {
        return itemState == null && updateState != null;
    }

    private static boolean isRemoved(Object itemState, Object updateState) {
        return itemState != null && updateState == null;
    }

    private static boolean isNewOrRemoved(Object itemState, Object updateState) {
        return itemState != updateState && (itemState == null || updateState == null);
    }

    private static boolean notSame(Object itemState, Object updateState) {
        return itemState != updateState;
    }

    private static boolean notRemoved(Object itemState, Object updateState) {
        return itemState == null || updateState != null;
    }

    private CommandFactory() {
    }

    public static NextPage nextPage() {
        return NEXT_PAGE;
    }

    public static PrevPage prevPage() {
        return PREV_PAGE;
    }

    public static Complete complete() {
        return COMPLETE;
    }

    public static GotoPage gotoPage(@Nonnull ItemId page) {
        return ImmutableGotoPage.of(page, ACTIVE_PAGE_TRIGGERS);
    }

    public static SetAnswer setAnswer(@Nonnull ItemId questionId, Object answer) {
        return ImmutableSetAnswer.of(questionId, answer, Arrays.asList(Triggers.trigger(Triggers.stateChangedEvent(questionId)).when(ItemStatePredicates.ITEM_STATE_CHANGED), Triggers.trigger(Triggers.validityUpdatedEvent(Triggers.onTarget(questionId))).when(ItemStatePredicates.ITEM_INVALIDITY_CHANGED), Triggers.trigger(Triggers.answeredUpdatedEvent(Triggers.onTarget(questionId))).when(ItemStatePredicates.ITEM_ANSWERED_STATE_CHANGED)));
    }

    public static SetLocale setLocale(@Nonnull String locale) {
        return ImmutableSetLocale.of(locale, Arrays.asList(Triggers.trigger(Triggers.sessionLocaleUpdatedEvent()).when(ItemStatePredicates.ALWAYS)));
    }

    public static SetVariableValue setVariableValue(@Nonnull ItemId id, Object value) {
        return ImmutableSetVariableValue.of(id, value, Arrays.asList(Triggers.trigger(Triggers.stateChangedEvent(id)).when(ItemStatePredicates.ITEM_STATE_CHANGED), Triggers.trigger(Triggers.statusUpdatedEvent(Triggers.onTarget(id))).when(ItemStatePredicates.ITEM_STATUS_CHANGED)));
    }

    public static SetVariableFailed setVariableFailed(@Nonnull ItemId id) {
        return ImmutableSetVariableFailed.of(id, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.statusUpdatedEvent(Triggers.onTarget(id))).when(ItemStatePredicates.ITEM_STATUS_CHANGED)));
    }

    public static ItemUpdateCommand deleteRow(@Nonnull ItemId toBeRemoved) {
        return toBeRemoved.getParent().map(parent -> ImmutableDeleteRow.of(parent, toBeRemoved, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.stateChangedEvent(parent)).when(ItemStatePredicates.ITEM_STATE_CHANGED)))).orElseGet(() -> ImmutableNopCommand.of(toBeRemoved, Collections.emptyList()));
    }

    public static SetRows addRows(@Nonnull ItemId id, @Nonnull List<Integer> ids) {
        return ImmutableSetRows.of(id, ids, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.stateChangedEvent(id)).when(ItemStatePredicates.ITEM_STATE_CHANGED)));
    }

    public static AddRow addRow(@Nonnull ItemId targetId) {
        return ImmutableAddRow.of(targetId, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.stateChangedEvent(targetId)).when(ItemStatePredicates.ITEM_STATE_CHANGED)));
    }

    public static InitRowGroupItemsCommand initRowGroupItemsCommand(@Nonnull ItemId targetId) {
        return ImmutableInitRowGroupItemsCommand.of(targetId, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.itemsChangedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.GROUP_ITEMS_CHANGED)));
    }

    public static UpdateActivityCommand activityUpdate(ItemId targetId, Expression expression) {
        return ImmutableUpdateActivityCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.stateChangedEvent(targetId)).when(ItemStatePredicates.ITEM_ACTIVITY_CHANGED), Triggers.trigger(Triggers.activityUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ITEM_ACTIVITY_CHANGED), Triggers.trigger(Triggers.validityUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ITEM_ACTIVITY_CHANGED), Triggers.trigger(Triggers.answeredUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ITEM_ACTIVITY_CHANGED)));
    }

    public static UpdateRowsCanBeAddedCommand rowsCanBeAddedUpdate(ItemId targetId, Expression expression) {
        return ImmutableUpdateRowsCanBeAddedCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.rowsCanBeAddedUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ROWS_CAN_BE_ADDED_CHANGED)));
    }

    public static UpdateRowCanBeRemovedCommand rowCanBeRemovedUpdate(ItemId targetId, Expression expression) {
        return ImmutableUpdateRowCanBeRemovedCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.rowCanBeRemovedUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ROWS_CAN_BE_REMOVED_CHANGED)));
    }

    public static UpdateRequiredCommand requiredUpdate(ItemId targetId, Expression expression) {
        return ImmutableUpdateRequiredCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.requiredUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ITEM_REQUIRED_CHANGED)));
    }

    public static UpdateClassNames updateClassNames(ItemId targetId, Expression expression) {
        return ImmutableUpdateClassNames.of(targetId, expression, Collections.emptyList());
    }

    public static UpdateLabelCommand labelUpdate(ItemId targetId, Expression expression) {
        return ImmutableUpdateLabelCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.labelUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ITEM_LABEL_CHANGED)));
    }

    public static UpdateDescriptionCommand descriptionUpdate(ItemId targetId, Expression expression) {
        return ImmutableUpdateDescriptionCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.descriptionUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ITEM_DESCRIPTION_CHANGED)));
    }

    public static UpdateAllowedActionsCommand allowedActionsUpdate(ItemId targetId, Expression expression) {
        return ImmutableUpdateAllowedActionsCommand.of(targetId, expression, Collections.emptyList());
    }

    public static UpdateIsInvalidAnswersCommand updateIsInvalidAnswers(ItemId targetId, Expression expression) {
        return ImmutableUpdateIsInvalidAnswersCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.anyInvalidAnswersUpdatedEvent()).when(ItemStatePredicates.ITEM_INVALID_ANSWERS_CHANGED)));
    }

    public static UpdateAvailableItemsCommand availableItemsUpdate(ItemId targetId, Expression expression) {
        return ImmutableUpdateAvailableItemsCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.availableItemsUpdatedEvent()).when(ItemStatePredicates.ITEM_STATE_CHANGED)));
    }

    public static UpdateDisabledCommand updateDisabled(ItemId targetId, Expression expression) {
        return ImmutableUpdateDisabledCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.disabledUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ITEM_STATE_CHANGED)));
    }

    public static ItemUpdateCommand updateGroupItems(ItemId targetId, Expression expression) {
        if (targetId instanceof ItemIdPartial) {
            return ImmutableInitGroupItems.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.groupItemsUpdatedEvent(targetId)).when(ItemStatePredicates.ITEM_STATE_CHANGED), Triggers.trigger(Triggers.rowGroupItemsInitEvent(targetId)).when(ItemStatePredicates.ITEM_STATE_CHANGED)));
        }
        return ImmutableUpdateGroupItems.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.groupItemsUpdatedEvent(Triggers.onTarget(targetId))).when(ItemStatePredicates.ITEM_STATE_CHANGED)));
    }

    public static ValidationDisabledUpdateCommand validationDisabledUpdate(ErrorId errorId, Expression expression) {
        return ImmutableValidationDisabledUpdateCommand.of(errorId, expression, Collections.emptyList());
    }

    public static UpdateValidationCommand updateValidationCommand(ErrorId errorId, Expression expression) {
        return ImmutableUpdateValidationCommand.of(errorId, expression, (List<Trigger<ErrorState>>)ImmutableList.of(Triggers.trigger(Triggers.validityUpdatedEvent(Triggers.onTarget(errorId.getItemId()))).when(ErrorStateMatcher.ERROR_ACTIVITY_CHANGED), Triggers.trigger(Triggers.errorActivityUpdatedEvent(errorId)).when(ErrorStateMatcher.ERROR_ACTIVITY_CHANGED)));
    }

    public static ErrorLabelUpdateCommand errorLabelUpdateCommand(ErrorId errorId, Expression expression) {
        return ImmutableErrorLabelUpdateCommand.of(errorId, expression, Collections.emptyList());
    }

    public static VariableUpdateCommand variableUpdateCommand(ItemId targetId, Expression expression) {
        return ImmutableVariableUpdateCommand.of(targetId, expression, (List<Trigger<ItemState>>)ImmutableList.of(Triggers.trigger(Triggers.stateChangedEvent(targetId)).when(ItemStatePredicates.ITEM_STATE_CHANGED)));
    }

    public static UpdateValueSetCommand updateValueSet(ValueSetId targetId, List<Value<ValueSet.Entry>> entries) {
        return ImmutableUpdateValueSetCommand.of(targetId, entries, Collections.emptyList());
    }

    public static SessionUpdateCommand createRowGroupFromPrototypeCommand(ItemId rowProtoTypeId) {
        return ImmutableCreateRowGroupFromPrototypeCommand.of(rowProtoTypeId, (List<Trigger<ItemStates>>)ImmutableList.of(Triggers.trigger(ImmutableRowItemsAddedEventsProvider.of(rowProtoTypeId)).when(ItemStatesPredicates.ITEM_STATES_CHANGED), Triggers.trigger(ImmutableRowItemsRemovedEventsProvider.of(rowProtoTypeId)).when(ItemStatesPredicates.ITEM_STATES_CHANGED)));
    }

    public static SessionUpdateCommand createRowGroupItemsFromPrototypeCommand(ItemId rowProtoTypeId, List<ItemId> itemPrototypeIds) {
        return ImmutableCreateRowGroupItemsFromPrototypeCommand.of(rowProtoTypeId, rowProtoTypeId, (List<Trigger<ItemStates>>)ImmutableList.of(Triggers.trigger(ImmutableProtoTypeItemsAddedEventsProvider.of(itemPrototypeIds)).when(ItemStatesPredicates.ITEM_STATES_CHANGED)));
    }

    static enum ErrorStateMatcher implements BiPredicate<ErrorState, ErrorState>
    {
        ERROR_STATE_CHANGED{

            @Override
            public boolean test(ErrorState itemState, ErrorState updateState) {
                return updateState != itemState;
            }
        }
        ,
        ERROR_ACTIVITY_CHANGED{

            @Override
            public boolean test(ErrorState itemState, ErrorState updateState) {
                return CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.isActive() != itemState.isActive();
            }
        };

    }

    static enum ItemStatesPredicates implements BiPredicate<ItemStates, ItemStates>
    {
        ITEM_STATES_CHANGED{

            @Override
            public boolean test(ItemStates itemState, ItemStates itemState2) {
                return itemState.getItemStates() != itemState2.getItemStates();
            }
        };

    }

    static enum ItemStatePredicates implements BiPredicate<ItemState, ItemState>
    {
        ALWAYS{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return true;
            }
        }
        ,
        ITEM_STATE_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNew(itemState, updateState) || updateState != itemState) && CommandFactory.notRemoved(itemState, updateState);
            }
        }
        ,
        GROUP_ITEMS_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || !itemState.getItems().equals(updateState.getItems()));
            }
        }
        ,
        ITEM_ACTIVITY_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.isActive() != itemState.isActive());
            }
        }
        ,
        ROWS_CAN_BE_ADDED_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.isRowsCanBeAdded() != itemState.isRowsCanBeAdded());
            }
        }
        ,
        ROWS_CAN_BE_REMOVED_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.isRowCanBeRemoved() != itemState.isRowCanBeRemoved());
            }
        }
        ,
        ITEM_LABEL_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || !Objects.equals(updateState.getLabel(), itemState.getLabel()));
            }
        }
        ,
        ITEM_DESCRIPTION_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || !Objects.equals(updateState.getDescription(), itemState.getDescription()));
            }
        }
        ,
        ITEM_REQUIRED_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.isRequired() != itemState.isRequired());
            }
        }
        ,
        ITEM_STATUS_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.getStatus() != itemState.getStatus());
            }
        }
        ,
        ITEM_INVALIDITY_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.isInvalid() != itemState.isInvalid());
            }
        }
        ,
        ITEM_INVALID_ANSWERS_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.isInvalidAnswers() != itemState.isInvalidAnswers());
            }
        }
        ,
        ITEM_ANSWERED_STATE_CHANGED{

            @Override
            public boolean test(ItemState itemState, ItemState updateState) {
                return CommandFactory.notSame(itemState, updateState) && (CommandFactory.isNewOrRemoved(itemState, updateState) || updateState.isAnswered() != itemState.isAnswered());
            }
        };

    }
}

