/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.model.Error;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.StructuralNode;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Error", generator="Immutables")
@Immutable
public final class ImmutableError
implements Error {
    private final boolean isPrototype;
    @Nullable
    private final String code;
    private final ItemId itemId;
    private final Expression validationExpression;
    @Nullable
    private final Expression disabledExpression;
    @Nullable
    private final Expression label;

    private ImmutableError(Builder builder) {
        this.code = builder.code;
        this.itemId = builder.itemId;
        this.validationExpression = builder.validationExpression;
        this.disabledExpression = builder.disabledExpression;
        this.label = builder.label;
        this.isPrototype = builder.isPrototypeIsSet() ? builder.isPrototype : Error.super.isPrototype();
    }

    private ImmutableError(boolean isPrototype, @Nullable String code, ItemId itemId, Expression validationExpression, @Nullable Expression disabledExpression, @Nullable Expression label) {
        this.isPrototype = isPrototype;
        this.code = code;
        this.itemId = itemId;
        this.validationExpression = validationExpression;
        this.disabledExpression = disabledExpression;
        this.label = label;
    }

    @Override
    public boolean isPrototype() {
        return this.isPrototype;
    }

    @Override
    @Nullable
    public String getCode() {
        return this.code;
    }

    @Override
    public ItemId getItemId() {
        return this.itemId;
    }

    @Override
    public Expression getValidationExpression() {
        return this.validationExpression;
    }

    @Override
    public Optional<Expression> getDisabledExpression() {
        return Optional.ofNullable(this.disabledExpression);
    }

    @Override
    @Nullable
    public Expression getLabel() {
        return this.label;
    }

    public final ImmutableError withIsPrototype(boolean value) {
        if (this.isPrototype == value) {
            return this;
        }
        return new ImmutableError(value, this.code, this.itemId, this.validationExpression, this.disabledExpression, this.label);
    }

    public final ImmutableError withCode(@Nullable String value) {
        if (Objects.equals(this.code, value)) {
            return this;
        }
        return new ImmutableError(this.isPrototype, value, this.itemId, this.validationExpression, this.disabledExpression, this.label);
    }

    public final ImmutableError withItemId(ItemId value) {
        if (this.itemId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "itemId");
        return new ImmutableError(this.isPrototype, this.code, newValue, this.validationExpression, this.disabledExpression, this.label);
    }

    public final ImmutableError withValidationExpression(Expression value) {
        if (this.validationExpression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "validationExpression");
        return new ImmutableError(this.isPrototype, this.code, this.itemId, newValue, this.disabledExpression, this.label);
    }

    public final ImmutableError withDisabledExpression(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "disabledExpression");
        if (this.disabledExpression == newValue) {
            return this;
        }
        return new ImmutableError(this.isPrototype, this.code, this.itemId, this.validationExpression, newValue, this.label);
    }

    public final ImmutableError withDisabledExpression(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.disabledExpression == value) {
            return this;
        }
        return new ImmutableError(this.isPrototype, this.code, this.itemId, this.validationExpression, value, this.label);
    }

    public final ImmutableError withLabel(@Nullable Expression value) {
        if (this.label == value) {
            return this;
        }
        return new ImmutableError(this.isPrototype, this.code, this.itemId, this.validationExpression, this.disabledExpression, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableError && this.equalTo((ImmutableError)another);
    }

    private boolean equalTo(ImmutableError another) {
        return this.isPrototype == another.isPrototype && Objects.equals(this.code, another.code) && this.itemId.equals(another.itemId) && this.validationExpression.equals(another.validationExpression) && Objects.equals(this.disabledExpression, another.disabledExpression) && Objects.equals(this.label, another.label);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.isPrototype);
        h += (h << 5) + Objects.hashCode(this.code);
        h += (h << 5) + this.itemId.hashCode();
        h += (h << 5) + this.validationExpression.hashCode();
        h += (h << 5) + Objects.hashCode(this.disabledExpression);
        h += (h << 5) + Objects.hashCode(this.label);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Error").omitNullValues().add("isPrototype", this.isPrototype).add("code", (Object)this.code).add("itemId", (Object)this.itemId).add("validationExpression", (Object)this.validationExpression).add("disabledExpression", (Object)this.disabledExpression).add("label", (Object)this.label).toString();
    }

    public static ImmutableError copyOf(Error instance) {
        if (instance instanceof ImmutableError) {
            return (ImmutableError)instance;
        }
        return ImmutableError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Error", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ITEM_ID = 1L;
        private static final long INIT_BIT_VALIDATION_EXPRESSION = 2L;
        private static final long OPT_BIT_IS_PROTOTYPE = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean isPrototype;
        @Nullable
        private String code;
        @Nullable
        private ItemId itemId;
        @Nullable
        private Expression validationExpression;
        @Nullable
        private Expression disabledExpression;
        @Nullable
        private Expression label;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Error instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StructuralNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StructuralNode instance;
            if (object instanceof Error) {
                Optional<Expression> disabledExpressionOptional;
                Expression labelValue;
                instance = (Error)object;
                this.itemId(instance.getItemId());
                this.validationExpression(instance.getValidationExpression());
                String codeValue = instance.getCode();
                if (codeValue != null) {
                    this.code(codeValue);
                }
                if ((labelValue = instance.getLabel()) != null) {
                    this.label(labelValue);
                }
                if ((disabledExpressionOptional = instance.getDisabledExpression()).isPresent()) {
                    this.disabledExpression(disabledExpressionOptional);
                }
            }
            if (object instanceof StructuralNode) {
                instance = (StructuralNode)object;
                this.isPrototype(instance.isPrototype());
            }
        }

        @CanIgnoreReturnValue
        public final Builder isPrototype(boolean isPrototype) {
            this.isPrototype = isPrototype;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder code(@Nullable String code) {
            this.code = code;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder itemId(ItemId itemId) {
            this.itemId = Objects.requireNonNull(itemId, "itemId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validationExpression(Expression validationExpression) {
            this.validationExpression = Objects.requireNonNull(validationExpression, "validationExpression");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder disabledExpression(Expression disabledExpression) {
            this.disabledExpression = Objects.requireNonNull(disabledExpression, "disabledExpression");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder disabledExpression(Optional<? extends Expression> disabledExpression) {
            this.disabledExpression = disabledExpression.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder label(@Nullable Expression label) {
            this.label = label;
            return this;
        }

        public ImmutableError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableError(this);
        }

        private boolean isPrototypeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("itemId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("validationExpression");
            }
            return "Cannot build Error, some of required attributes are not set " + attributes;
        }
    }
}

