/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.model.ConditionalValue;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.Value;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConditionalValue", generator="Immutables")
@Immutable
public final class ImmutableConditionalValue<T>
implements ConditionalValue<T> {
    private final Expression when;
    @Nullable
    private final T value;
    @Nullable
    private final T fallbackValue;
    private final ValueType valueType;

    private ImmutableConditionalValue(Expression when, @Nullable T value, @Nullable T fallbackValue, ValueType valueType) {
        this.when = when;
        this.value = value;
        this.fallbackValue = fallbackValue;
        this.valueType = valueType;
    }

    @Override
    public Expression getWhen() {
        return this.when;
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public T getFallbackValue() {
        return this.fallbackValue;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    public final ImmutableConditionalValue<T> withWhen(Expression value) {
        if (this.when == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "when");
        return new ImmutableConditionalValue<T>(newValue, this.value, this.fallbackValue, this.valueType);
    }

    public final ImmutableConditionalValue<T> withValue(@Nullable T value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableConditionalValue<T>(this.when, value, this.fallbackValue, this.valueType);
    }

    public final ImmutableConditionalValue<T> withFallbackValue(@Nullable T value) {
        if (this.fallbackValue == value) {
            return this;
        }
        return new ImmutableConditionalValue<T>(this.when, this.value, value, this.valueType);
    }

    public final ImmutableConditionalValue<T> withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "valueType");
        return new ImmutableConditionalValue<T>(this.when, this.value, this.fallbackValue, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConditionalValue && this.equalTo((ImmutableConditionalValue)another);
    }

    private boolean equalTo(ImmutableConditionalValue<?> another) {
        return this.when.equals(another.when) && Objects.equals(this.value, another.value) && Objects.equals(this.fallbackValue, another.fallbackValue) && this.valueType.equals(another.valueType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.when.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.fallbackValue);
        h += (h << 5) + this.valueType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConditionalValue").omitNullValues().add("when", (Object)this.when).add("value", this.value).add("fallbackValue", this.fallbackValue).add("valueType", (Object)this.valueType).toString();
    }

    public static <T> ImmutableConditionalValue<T> copyOf(ConditionalValue<T> instance) {
        if (instance instanceof ImmutableConditionalValue) {
            return (ImmutableConditionalValue)instance;
        }
        return ImmutableConditionalValue.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="ConditionalValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_WHEN = 1L;
        private static final long INIT_BIT_VALUE_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private Expression when;
        @Nullable
        private T value;
        @Nullable
        private T fallbackValue;
        @Nullable
        private ValueType valueType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(Value<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ConditionalValue<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Value instance;
            long bits = 0L;
            if (object instanceof Value) {
                instance = (Value)object;
                if ((bits & 1L) == 0L) {
                    this.valueType(instance.getValueType());
                    bits |= 1L;
                }
            }
            if (object instanceof ConditionalValue) {
                Object fallbackValueValue;
                instance = (ConditionalValue)object;
                this.when(instance.getWhen());
                Object valueValue = instance.getValue();
                if (valueValue != null) {
                    this.value(valueValue);
                }
                if ((fallbackValueValue = instance.getFallbackValue()) != null) {
                    this.fallbackValue(fallbackValueValue);
                }
                if ((bits & 1L) == 0L) {
                    this.valueType(instance.getValueType());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> when(Expression when) {
            this.when = Objects.requireNonNull(when, "when");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(@Nullable T value) {
            this.value = value;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> fallbackValue(@Nullable T fallbackValue) {
            this.fallbackValue = fallbackValue;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> valueType(ValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableConditionalValue<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConditionalValue<T>(this.when, this.value, this.fallbackValue, this.valueType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("when");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("valueType");
            }
            return "Cannot build ConditionalValue, some of required attributes are not set " + attributes;
        }
    }
}

