/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public interface ValueSetEntryToStringOperator
extends Expression {
    @Value.Parameter
    public ValueSetId getValueSetId();

    @Value.Parameter
    public Expression getExpression();

    @Override
    @Nullable
    default public String eval(@Nonnull EvalContext context) {
        Object eval = this.getExpression().eval(context);
        if (eval == null) {
            return null;
        }
        Optional<ValueSetState> valueSetState = context.getValueSetState(this.getValueSetId());
        return valueSetState.map(valueSetState1 -> {
            for (ValueSetState.Entry entry : valueSetState1.getEntries()) {
                if (!entry.getId().equals(eval)) continue;
                return entry.getLabel();
            }
            return null;
        }).orElse(null);
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getExpression().getEvalRequiredConditions();
    }
}

