/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.OperatorSymbol;
import io.dialob.session.engine.program.expr.arith.ComparableTypeOperators;
import io.dialob.session.engine.program.expr.arith.ImmutableDateMinusDateOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableDateMinusPeriodOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableDatePlusPeriodOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableNowExpression;
import io.dialob.session.engine.program.expr.arith.ImmutableTimeMinusDurationOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableTimeMinusTimeOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableTimePlusDurationOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableTodayExpression;
import io.dialob.session.engine.program.model.Expression;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimeOperators
extends ComparableTypeOperators<LocalTime> {
    private static final Expression TODAY = ImmutableTodayExpression.builder().build();
    private static final Expression NOW = ImmutableNowExpression.builder().build();

    @Nonnull
    public static Expression today() {
        return TODAY;
    }

    @Nonnull
    public static Expression now() {
        return NOW;
    }

    @Nullable
    public static Expression createOperator(@Nonnull OperatorSymbol operator, @Nonnull Expression lhs, @Nonnull Expression rhs) {
        ValueType lhsValueType = lhs.getValueType();
        ValueType rhsValueType = rhs.getValueType();
        if (operator == OperatorSymbol.MINUS) {
            if (lhsValueType == ValueType.DATE) {
                if (rhsValueType == ValueType.DATE) {
                    return ImmutableDateMinusDateOperator.builder().lhs(lhs).rhs(rhs).build();
                }
                if (rhsValueType == ValueType.PERIOD) {
                    return ImmutableDateMinusPeriodOperator.builder().lhs(lhs).rhs(rhs).build();
                }
            } else if (lhsValueType == ValueType.TIME) {
                if (rhsValueType == ValueType.TIME) {
                    return ImmutableTimeMinusTimeOperator.builder().lhs(lhs).rhs(rhs).build();
                }
                if (rhsValueType == ValueType.DURATION) {
                    return ImmutableTimeMinusDurationOperator.builder().lhs(lhs).rhs(rhs).build();
                }
            }
        } else if (operator == OperatorSymbol.PLUS) {
            if (lhsValueType == ValueType.DATE && rhsValueType == ValueType.PERIOD) {
                return ImmutableDatePlusPeriodOperator.builder().lhs(lhs).rhs(rhs).build();
            }
            if (lhsValueType == ValueType.TIME && rhsValueType == ValueType.DURATION) {
                return ImmutableTimePlusDurationOperator.builder().lhs(lhs).rhs(rhs).build();
            }
        }
        return null;
    }
}

