/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.ArrayReducerOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableArrayReducerOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableCollectRowFieldsOperator;
import io.dialob.session.engine.program.expr.arith.VariableReference;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;

public interface ReduceOperators {
    public static ItemId extractPrototypeId(Expression expression) {
        if (expression instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)expression;
            return variableReference.getItemId();
        }
        throw new IllegalStateException("Only id expressions supported for now");
    }

    public static Expression sumOf(Expression expression) {
        ItemId protoTypeId = ReduceOperators.extractPrototypeId(expression);
        ValueType valueType = expression.getValueType();
        return ImmutableArrayReducerOperator.of(ArrayReducerOperator.sumOp(valueType), ImmutableCollectRowFieldsOperator.of(protoTypeId, valueType));
    }

    public static Expression minOf(Expression expression) {
        ItemId protoTypeId = ReduceOperators.extractPrototypeId(expression);
        ValueType valueType = expression.getValueType();
        return ImmutableArrayReducerOperator.of(ArrayReducerOperator.minOp(valueType), ImmutableCollectRowFieldsOperator.of(protoTypeId, valueType));
    }

    public static Expression maxOf(Expression expression) {
        ItemId protoTypeId = ReduceOperators.extractPrototypeId(expression);
        ValueType valueType = expression.getValueType();
        return ImmutableArrayReducerOperator.of(ArrayReducerOperator.maxOp(valueType), ImmutableCollectRowFieldsOperator.of(protoTypeId, valueType));
    }
}

