/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.collect.ImmutableSet;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import java.util.Set;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface IsValidOperator
extends Expression {
    @Value.Parameter
    public ItemId getItemId();

    @Override
    default public Boolean eval(@Nonnull EvalContext context) {
        ItemId itemId = context.mapTo(this.getItemId(), false);
        return context.getItemState(itemId).map(itemState -> {
            if (Utils.isQuestionType(itemState)) {
                return context.getErrorStates().stream().filter(ErrorState::isActive).map(ErrorState::getItemId).noneMatch(itemId::equals);
            }
            return !itemState.isInvalidAnswers();
        }).orElse(true);
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return ImmutableSet.of((Object)EventMatchers.errorActivity(EventMatchers.targetError(this.getItemId())));
    }
}

