/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.collect.ImmutableSet;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface IsInvalidAnswersOnActivePage
extends Expression {
    public static final Set<EventMatcher> ANY_ERROR = ImmutableSet.of((Object)EventMatchers.errorActivity(EventMatchers.anyError()));

    public ItemId getPageContainerId();

    @Override
    default public Boolean eval(@Nonnull EvalContext context) {
        Set questionsWithErrors = context.getErrorStates().stream().filter(ErrorState::isActive).map(ErrorState::getItemId).collect(Collectors.toSet());
        if (questionsWithErrors.isEmpty()) {
            return false;
        }
        Stream<ItemId> pageItemIds = context.getItemState(this.getPageContainerId()).flatMap(ItemState::getActivePage).flatMap(context::getItemState).map(ItemState::getItems).stream().flatMap(Collection::stream);
        return this.findQuestionItems(context, pageItemIds).map(ItemState::getId).anyMatch(questionsWithErrors::contains);
    }

    default public Stream<? extends ItemState> findQuestionItems(@Nonnull EvalContext context, Stream<ItemId> items) {
        return items.map(context::getItemState).flatMap(Optional::stream).flatMap(item -> {
            if (item.getItems().isEmpty()) {
                return Stream.of(item);
            }
            return Stream.concat(Stream.of(item), this.findQuestionItems(context, item.getItems().stream()));
        });
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return ANY_ERROR;
    }
}

