/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.expr.arith.ValueSetEntryToStringOperator;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValueSetEntryToStringOperator", generator="Immutables")
@Immutable
public final class ImmutableValueSetEntryToStringOperator
implements ValueSetEntryToStringOperator {
    private final ValueSetId valueSetId;
    private final Expression expression;

    private ImmutableValueSetEntryToStringOperator(ValueSetId valueSetId, Expression expression) {
        this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    private ImmutableValueSetEntryToStringOperator(ImmutableValueSetEntryToStringOperator original, ValueSetId valueSetId, Expression expression) {
        this.valueSetId = valueSetId;
        this.expression = expression;
    }

    @Override
    public ValueSetId getValueSetId() {
        return this.valueSetId;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public final ImmutableValueSetEntryToStringOperator withValueSetId(ValueSetId value) {
        if (this.valueSetId == value) {
            return this;
        }
        ValueSetId newValue = Objects.requireNonNull(value, "valueSetId");
        return new ImmutableValueSetEntryToStringOperator(this, newValue, this.expression);
    }

    public final ImmutableValueSetEntryToStringOperator withExpression(Expression value) {
        if (this.expression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "expression");
        return new ImmutableValueSetEntryToStringOperator(this, this.valueSetId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueSetEntryToStringOperator && this.equalTo((ImmutableValueSetEntryToStringOperator)another);
    }

    private boolean equalTo(ImmutableValueSetEntryToStringOperator another) {
        return this.valueSetId.equals(another.valueSetId) && this.expression.equals(another.expression);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.valueSetId.hashCode();
        h += (h << 5) + this.expression.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValueSetEntryToStringOperator").omitNullValues().add("valueSetId", (Object)this.valueSetId).add("expression", (Object)this.expression).toString();
    }

    public static ImmutableValueSetEntryToStringOperator of(ValueSetId valueSetId, Expression expression) {
        return new ImmutableValueSetEntryToStringOperator(valueSetId, expression);
    }

    public static ImmutableValueSetEntryToStringOperator copyOf(ValueSetEntryToStringOperator instance) {
        if (instance instanceof ImmutableValueSetEntryToStringOperator) {
            return (ImmutableValueSetEntryToStringOperator)instance;
        }
        return ImmutableValueSetEntryToStringOperator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValueSetEntryToStringOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE_SET_ID = 1L;
        private static final long INIT_BIT_EXPRESSION = 2L;
        private long initBits = 3L;
        @Nullable
        private ValueSetId valueSetId;
        @Nullable
        private Expression expression;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ValueSetEntryToStringOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.valueSetId(instance.getValueSetId());
            this.expression(instance.getExpression());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSetId(ValueSetId valueSetId) {
            this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableValueSetEntryToStringOperator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueSetEntryToStringOperator(null, this.valueSetId, this.expression);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("valueSetId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expression");
            }
            return "Cannot build ValueSetEntryToStringOperator, some of required attributes are not set " + attributes;
        }
    }
}

