/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.program.expr.arith.NotOperator;
import io.dialob.session.engine.program.expr.arith.UnaryOperator;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NotOperator", generator="Immutables")
@Immutable
public final class ImmutableNotOperator
implements NotOperator {
    private final Expression expression;

    private ImmutableNotOperator(Expression expression) {
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    private ImmutableNotOperator(ImmutableNotOperator original, Expression expression) {
        this.expression = expression;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public final ImmutableNotOperator withExpression(Expression value) {
        if (this.expression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "expression");
        return new ImmutableNotOperator(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotOperator && this.equalTo((ImmutableNotOperator)another);
    }

    private boolean equalTo(ImmutableNotOperator another) {
        return this.expression.equals(another.expression);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.expression.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NotOperator").omitNullValues().add("expression", (Object)this.expression).toString();
    }

    public static ImmutableNotOperator of(Expression expression) {
        return new ImmutableNotOperator(expression);
    }

    public static ImmutableNotOperator copyOf(NotOperator instance) {
        if (instance instanceof ImmutableNotOperator) {
            return (ImmutableNotOperator)instance;
        }
        return ImmutableNotOperator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NotOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXPRESSION = 1L;
        private long initBits = 1L;
        @Nullable
        private Expression expression;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UnaryOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(NotOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof UnaryOperator) {
                UnaryOperator instance = (UnaryOperator)object;
                this.expression(instance.getExpression());
            }
        }

        @CanIgnoreReturnValue
        public final Builder expression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableNotOperator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNotOperator(null, this.expression);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expression");
            }
            return "Cannot build NotOperator, some of required attributes are not set " + attributes;
        }
    }
}

