/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.CollectRowFieldsOperator;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CollectRowFieldsOperator", generator="Immutables")
@Immutable
public final class ImmutableCollectRowFieldsOperator
implements CollectRowFieldsOperator {
    private final ItemId itemId;
    private final ValueType type;

    private ImmutableCollectRowFieldsOperator(ItemId itemId, ValueType type) {
        this.itemId = Objects.requireNonNull(itemId, "itemId");
        this.type = Objects.requireNonNull(type, "type");
    }

    private ImmutableCollectRowFieldsOperator(ImmutableCollectRowFieldsOperator original, ItemId itemId, ValueType type) {
        this.itemId = itemId;
        this.type = type;
    }

    @Override
    public ItemId getItemId() {
        return this.itemId;
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    public final ImmutableCollectRowFieldsOperator withItemId(ItemId value) {
        if (this.itemId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "itemId");
        return new ImmutableCollectRowFieldsOperator(this, newValue, this.type);
    }

    public final ImmutableCollectRowFieldsOperator withType(ValueType value) {
        if (this.type == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableCollectRowFieldsOperator(this, this.itemId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCollectRowFieldsOperator && this.equalTo((ImmutableCollectRowFieldsOperator)another);
    }

    private boolean equalTo(ImmutableCollectRowFieldsOperator another) {
        return this.itemId.equals(another.itemId) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.itemId.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CollectRowFieldsOperator").omitNullValues().add("itemId", (Object)this.itemId).add("type", (Object)this.type).toString();
    }

    public static ImmutableCollectRowFieldsOperator of(ItemId itemId, ValueType type) {
        return new ImmutableCollectRowFieldsOperator(itemId, type);
    }

    public static ImmutableCollectRowFieldsOperator copyOf(CollectRowFieldsOperator instance) {
        if (instance instanceof ImmutableCollectRowFieldsOperator) {
            return (ImmutableCollectRowFieldsOperator)instance;
        }
        return ImmutableCollectRowFieldsOperator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CollectRowFieldsOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ITEM_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private ItemId itemId;
        @Nullable
        private ValueType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CollectRowFieldsOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.itemId(instance.getItemId());
            this.type(instance.getType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder itemId(ItemId itemId) {
            this.itemId = Objects.requireNonNull(itemId, "itemId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(ValueType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCollectRowFieldsOperator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCollectRowFieldsOperator(null, this.itemId, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("itemId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CollectRowFieldsOperator, some of required attributes are not set " + attributes;
        }
    }
}

