/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.collect.Sets;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.expr.arith.Pair;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface ConditionalListOperator<T>
extends Expression {
    public List<Pair<Expression, T>> getItems();

    @Override
    default public Object eval(@Nonnull EvalContext evalContext) {
        return this.getItems().stream().filter(item -> (Boolean)((Expression)item.getLeft()).eval(evalContext)).map(Pair::getRight).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.arrayOf((ValueType)ValueType.STRING);
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getItems().stream().map(Pair::getLeft).map(Expression::getEvalRequiredConditions).reduce(Sets::union).orElse(Collections.emptySet());
    }
}

