/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.session.engine.program.expr.arith.ImmutableEqOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableGeOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableGtOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableLeOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableLtOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableNeOperator;
import io.dialob.session.engine.program.expr.arith.InfixOperator;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.model.Expression;

public class ComparableTypeOperators<T extends Comparable<T>>
implements Operators {
    @Override
    public InfixOperator<Boolean> eq(Expression lhs, Expression rhs) {
        return ImmutableEqOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator<Boolean> le(Expression lhs, Expression rhs) {
        return ImmutableLeOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator<Boolean> ne(Expression lhs, Expression rhs) {
        return ImmutableNeOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator<Boolean> lt(Expression lhs, Expression rhs) {
        return ImmutableLtOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator<Boolean> ge(Expression lhs, Expression rhs) {
        return ImmutableGeOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator<Boolean> gt(Expression lhs, Expression rhs) {
        return ImmutableGtOperator.builder().lhs(lhs).rhs(rhs).build();
    }
}

