/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr;

import com.google.common.collect.ImmutableSet;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface ExpressionList
extends Expression {
    public List<Expression> getExpressions();

    @Override
    default public Object eval(@Nonnull EvalContext evalContext) {
        return this.getExpressions().stream().map(expression -> expression.eval(evalContext)).filter(Objects::nonNull).flatMap(o -> {
            if (o instanceof Collection) {
                return ((Collection)o).stream();
            }
            return Stream.of(o);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    default public ValueType getValueType() {
        return ValueType.arrayOf((ValueType)ValueType.STRING);
    }

    @Override
    @Nonnull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        ImmutableSet.Builder deps = ImmutableSet.builder();
        this.getExpressions().forEach(arg -> deps.addAll(arg.getEvalRequiredConditions()));
        return deps.build();
    }
}

