/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.FormValueSetEntry;
import io.dialob.api.form.ImmutableFormValidationError;
import io.dialob.form.service.api.validation.FormValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSetValidator
implements FormValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueSetValidator.class);

    private List<FormValidationError> checkValueSet(FormValueSet valueSet) {
        ArrayList<FormValidationError> result = new ArrayList<FormValidationError>();
        if (valueSet.getEntries().isEmpty()) {
            result.add((FormValidationError)ImmutableFormValidationError.builder().type(FormValidationError.Type.VALUESET).level(FormValidationError.Level.WARNING).message("VALUESET_EMPTY").itemId(valueSet.getId()).build());
            return result;
        }
        valueSet.getEntries().stream().collect(Collectors.groupingBy(FormValueSetEntry::getId, Collectors.toList())).values().stream().filter(l -> l.size() > 1).flatMap(Collection::stream).map(e -> ImmutableFormValidationError.builder().type(FormValidationError.Type.VALUESET).level(FormValidationError.Level.ERROR).message("VALUESET_DUPLICATE_KEY").itemId(valueSet.getId()).expression(e.getId()).index(valueSet.getEntries().indexOf(e)).build()).forEach(result::add);
        valueSet.getEntries().stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).map(e -> ImmutableFormValidationError.builder().type(FormValidationError.Type.VALUESET).level(FormValidationError.Level.ERROR).message("VALUESET_EMPTY_KEY").itemId(valueSet.getId()).index(valueSet.getEntries().indexOf(e)).build()).forEach(result::add);
        return result;
    }

    @Nonnull
    public List<FormValidationError> validate(Form form) {
        return form.getValueSets().stream().map(this::checkValueSet).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

