/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.api.form.FormValidationError;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.AbstractItemBuilder;
import io.dialob.session.engine.program.ValueSetBuilder;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.ImmutableConditionalValue;
import io.dialob.session.engine.program.model.ImmutableConstantValue;
import io.dialob.session.engine.program.model.ImmutableValueSet;
import io.dialob.session.engine.program.model.ProgramNode;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.model.IdUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ValueSetEntryBuilder
extends AbstractItemBuilder<ValueSetEntryBuilder, ValueSetBuilder> {
    private String key;
    private String when;
    private int index;

    public ValueSetEntryBuilder(ValueSetBuilder valueSetBuilder, String key, int index) {
        super(valueSetBuilder.getProgramBuilder(), valueSetBuilder, valueSetBuilder.getHoistingGroup().orElse(null), IdUtils.toString(valueSetBuilder.getId()) + ":" + index);
        this.key = Objects.requireNonNull(key, "Entry id may not be null");
        this.index = index;
    }

    @Override
    protected ValueSetEntryBuilder setActiveWhen(Expression activeWhen) {
        return (ValueSetEntryBuilder)super.setActiveWhen(activeWhen);
    }

    @Override
    protected void afterExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        this.requireBooleanExpression(this.activeWhen, this.getActiveWhenExpressionErrorType(), errorConsumer);
        ProgramNode entryValue = null;
        entryValue = this.activeWhen != null ? ImmutableConditionalValue.builder().when(this.activeWhen).value(ImmutableValueSet.Entry.builder().key(this.key).label(this.createLabelOperator(this.label)).build()).valueType(ValueType.STRING).build() : ImmutableConstantValue.builder().value(ImmutableValueSet.Entry.builder().key(this.key).label(this.createLabelOperator(this.label)).build()).build();
        ((ValueSetBuilder)this.getParent()).addValueEntry((Value<ValueSet.Entry>)((Object)entryValue));
    }

    @Override
    public Optional<Integer> getIndex() {
        return Optional.of(this.index);
    }

    @Override
    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FormValidationError.Type getActiveWhenExpressionErrorType() {
        return FormValidationError.Type.VALUESET_ENTRY;
    }
}

