/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.api.form.FormValidationError;
import io.dialob.session.engine.program.AbstractItemBuilder;
import io.dialob.session.engine.program.BuilderParent;
import io.dialob.session.engine.program.ProgramBuilder;
import io.dialob.session.engine.program.ValueSetEntryBuilder;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.ImmutableValueSet;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.spi.AliasesProvider;
import io.dialob.session.engine.spi.ExpressionCompiler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ValueSetBuilder
extends AbstractItemBuilder<ValueSetBuilder, ProgramBuilder>
implements ExpressionCompiler,
BuilderParent {
    private List<ValueSetEntryBuilder> valueSetEntryBuilders = new ArrayList<ValueSetEntryBuilder>();
    private List<Value<ValueSet.Entry>> values = new ArrayList<Value<ValueSet.Entry>>();

    public ValueSetBuilder(ProgramBuilder programBuilder, String id) {
        super(programBuilder, programBuilder, null, id);
    }

    @Override
    protected void afterExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        this.valueSetEntryBuilders.forEach(valueSetEntryBuilder -> valueSetEntryBuilder.afterExpressionCompilation(errorConsumer));
        this.getProgramBuilder().add(ImmutableValueSet.builder().id(this.getIdStr()).entries(this.values).build());
    }

    public ValueSetEntryBuilder addValue(String id) {
        ValueSetEntryBuilder entryBuilder = new ValueSetEntryBuilder(this, id, this.valueSetEntryBuilders.size());
        this.valueSetEntryBuilders.add(entryBuilder);
        return entryBuilder;
    }

    void addValueEntry(Value<ValueSet.Entry> entry) {
        this.values.add(entry);
    }

    @Override
    protected void doBuild() {
        this.valueSetEntryBuilders.forEach(AbstractItemBuilder::build);
    }

    @Override
    public boolean compile(@NotNull ItemId itemId, @NotNull String expression, @NotNull AliasesProvider aliasesProvider, @NotNull Consumer<Expression> consumer, @NotNull FormValidationError.Type type, Optional<Integer> index) {
        return ((ProgramBuilder)this.getParent()).compile(itemId, expression, aliasesProvider, consumer, type, index);
    }
}

