/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import com.google.common.collect.Sets;
import io.dialob.session.engine.DebugUtil;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.CommandFactory;
import io.dialob.session.engine.session.command.ErrorLabelUpdateCommand;
import io.dialob.session.engine.session.command.InitRowGroupItemsCommand;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.command.SessionUpdateCommand;
import io.dialob.session.engine.session.command.UpdateActivityCommand;
import io.dialob.session.engine.session.command.UpdateAllowedActionsCommand;
import io.dialob.session.engine.session.command.UpdateAvailableItemsCommand;
import io.dialob.session.engine.session.command.UpdateClassNames;
import io.dialob.session.engine.session.command.UpdateDescriptionCommand;
import io.dialob.session.engine.session.command.UpdateDisabledCommand;
import io.dialob.session.engine.session.command.UpdateIsInvalidAnswersCommand;
import io.dialob.session.engine.session.command.UpdateLabelCommand;
import io.dialob.session.engine.session.command.UpdateRequiredCommand;
import io.dialob.session.engine.session.command.UpdateRowCanBeRemovedCommand;
import io.dialob.session.engine.session.command.UpdateRowsCanBeAddedCommand;
import io.dialob.session.engine.session.command.UpdateValidationCommand;
import io.dialob.session.engine.session.command.UpdateValueSetCommand;
import io.dialob.session.engine.session.command.ValidationDisabledUpdateCommand;
import io.dialob.session.engine.session.command.VariableUpdateCommand;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateCommandFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateCommandFactory.class);
    private final Set<Command<?>> allCommands = Sets.newHashSet();
    private final Set<ErrorId> targetIds = Sets.newHashSet();

    UpdateCommandFactory() {
    }

    private <C extends Command<?>> C add(C command) {
        assert (!this.allCommands.contains(command));
        this.allCommands.add(command);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Command '{}' created", (Object)DebugUtil.commandToString(command));
        }
        return command;
    }

    public Set<Command<?>> getAllCommands() {
        return Collections.unmodifiableSet(this.allCommands);
    }

    public VariableUpdateCommand createUpdateVariable(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.variableUpdateCommand(id, expression));
    }

    public UpdateClassNames createUpdateClass(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.updateClassNames(id, expression));
    }

    public UpdateLabelCommand createUpdateLabel(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.labelUpdate(id, expression));
    }

    public UpdateDescriptionCommand createUpdateDescription(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.descriptionUpdate(id, expression));
    }

    public UpdateDisabledCommand createUpdateDisabled(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.updateDisabled(id, expression));
    }

    public UpdateActivityCommand createUpdateActivity(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.activityUpdate(id, expression));
    }

    public UpdateRowsCanBeAddedCommand createUpdateRowsCanBeAddedCommand(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.rowsCanBeAddedUpdate(id, expression));
    }

    public UpdateRowCanBeRemovedCommand createUpdateRowCanBeRemovedCommand(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.rowCanBeRemovedUpdate(id, expression));
    }

    public UpdateRequiredCommand createUpdateRequired(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.requiredUpdate(id, expression));
    }

    public UpdateAllowedActionsCommand createUpdateAllowedActions(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.allowedActionsUpdate(id, expression));
    }

    public UpdateIsInvalidAnswersCommand createUpdateIsInvalidAnswersCommand(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.updateIsInvalidAnswers(id, expression));
    }

    public UpdateAvailableItemsCommand createUpdateAvailableItems(@Nonnull ItemId id, @Nonnull Expression expression) {
        return this.add(CommandFactory.availableItemsUpdate(id, expression));
    }

    public ItemUpdateCommand createUpdateGroupItems(@Nonnull ItemId groupId, @Nonnull Expression expression) {
        return this.add(CommandFactory.updateGroupItems(groupId, expression));
    }

    public ValidationDisabledUpdateCommand createUpdateValidationDisabled(@Nonnull ErrorId targetId, @Nonnull Expression expression) {
        return this.add(CommandFactory.validationDisabledUpdate(targetId, expression));
    }

    public UpdateValidationCommand createUpdateValidationCommand(@Nonnull ErrorId targetId, @Nonnull Expression expression) {
        assert (!this.targetIds.contains(targetId));
        this.targetIds.add(targetId);
        return this.add(CommandFactory.updateValidationCommand(targetId, expression));
    }

    public ErrorLabelUpdateCommand createErrorLabelUpdateCommand(@Nonnull ErrorId targetId, @Nonnull Expression expression) {
        return this.add(CommandFactory.errorLabelUpdateCommand(targetId, expression));
    }

    public SessionUpdateCommand createRowGroupFromPrototype(ItemId rowGroupPrototypeId) {
        return this.add(CommandFactory.createRowGroupFromPrototypeCommand(rowGroupPrototypeId));
    }

    public SessionUpdateCommand createRowGroupItemsFromPrototype(ItemId rowGroupPrototypeId, List<ItemId> itemIds) {
        return this.add(CommandFactory.createRowGroupItemsFromPrototypeCommand(rowGroupPrototypeId, itemIds));
    }

    public InitRowGroupItemsCommand initRowGroupItems(ItemId groupId) {
        return this.add(CommandFactory.initRowGroupItemsCommand(groupId));
    }

    public UpdateValueSetCommand createUpdateValueSetCommand(ValueSetId valueSetId, List<Value<ValueSet.Entry>> entries) {
        return this.add(CommandFactory.updateValueSet(valueSetId, entries));
    }
}

