/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.api.form.FormValidationError;
import io.dialob.api.proto.Action;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.AbstractItemBuilder;
import io.dialob.session.engine.program.BuilderParent;
import io.dialob.session.engine.program.ProgramBuilder;
import io.dialob.session.engine.program.expr.ImmutableNotOnPageExpression;
import io.dialob.session.engine.program.expr.arith.BooleanOperators;
import io.dialob.session.engine.program.expr.arith.ImmutableCanAddRowsOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableCanRemoveRowOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableConditionalListOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableConstant;
import io.dialob.session.engine.program.expr.arith.ImmutableIsActiveOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsAnyInvalidAnswersOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsInvalidAnswersOnActivePage;
import io.dialob.session.engine.program.expr.arith.ImmutableIsOnFirstPage;
import io.dialob.session.engine.program.expr.arith.ImmutableIsOnLastPage;
import io.dialob.session.engine.program.expr.arith.ImmutablePair;
import io.dialob.session.engine.program.expr.arith.ImmutableRowItemsExpression;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.expr.arith.Pair;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.ImmutableGroup;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableItemIdPartial;
import io.dialob.session.engine.session.model.ImmutableItemRef;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class GroupBuilder
extends AbstractItemBuilder<GroupBuilder, ProgramBuilder>
implements BuilderParent {
    public static final Expression EMPTY_ARRAY_EXPRESSION = ImmutableConstant.builder().valueType(ValueType.arrayOf((ValueType)ValueType.STRING)).value(Collections.emptyList()).build();
    private List<ItemId> itemIds;
    private Expression canAddRowWhen = BooleanOperators.TRUE;
    private Expression canRemoveRowWhen = BooleanOperators.TRUE;
    private List<String> items = new ArrayList<String>();
    private Type type;
    private String view;
    private String valueSetId;

    public GroupBuilder(ProgramBuilder programBuilder, GroupBuilder hoistingGroupBuilder, String id) {
        super(programBuilder, programBuilder, hoistingGroupBuilder, id);
    }

    public GroupBuilder root() {
        this.type = Type.ROOT;
        return this;
    }

    public GroupBuilder page() {
        this.type = Type.PAGE;
        return this;
    }

    public GroupBuilder group() {
        this.type = Type.GROUP;
        return this;
    }

    public GroupBuilder rowgroup() {
        this.type = Type.ROWGROUP;
        return this;
    }

    public GroupBuilder surveyGroup() {
        this.type = Type.SURVEYGROUP;
        return this;
    }

    public GroupBuilder setView(String view) {
        this.view = view;
        return this;
    }

    public GroupBuilder addItem(String id) {
        this.items.add(id);
        return this;
    }

    public GroupBuilder addItems(Collection<String> id) {
        this.items.addAll(id);
        return this;
    }

    public GroupBuilder setValueSet(String valueSetId) {
        this.valueSetId = valueSetId;
        return this;
    }

    public GroupBuilder setCanAddRowWhen(Expression canAddRowWhen) {
        this.canAddRowWhen = canAddRowWhen;
        return this;
    }

    public GroupBuilder setCanAddRowWhen(String canAddRowWhen) {
        if (StringUtils.isNotBlank((CharSequence)canAddRowWhen)) {
            this.compileExpression(canAddRowWhen, this::setCanAddRowWhen, FormValidationError.Type.CANADDROW, this.getIndex());
        }
        return this;
    }

    public GroupBuilder setCanRemoveRowWhen(Expression canRemoveRowWhen) {
        this.canRemoveRowWhen = canRemoveRowWhen;
        return this;
    }

    public GroupBuilder setCanRemoveRowWhen(String canRemoveRowWhen) {
        if (StringUtils.isNotBlank((CharSequence)canRemoveRowWhen)) {
            this.compileExpression(canRemoveRowWhen, this::setCanRemoveRowWhen, FormValidationError.Type.CANREMOVEROW, this.getIndex());
        }
        return this;
    }

    @Nonnull
    public Collection<ItemId> getItemIds() {
        return Collections.unmodifiableList(this.itemIds);
    }

    protected boolean hoistsItem(String itemId) {
        return this.items.contains(itemId);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public Optional<ValueType> getValueType() {
        if (this.type == Type.ROWGROUP) {
            return Optional.of(ValueType.arrayOf((ValueType)ValueType.INTEGER));
        }
        return Optional.empty();
    }

    @Override
    protected void beforeExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        super.beforeExpressionCompilation(errorConsumer);
        this.itemIds = this.items.stream().map(item -> this.getProgramBuilder().findItemBuilder((String)item)).filter(Optional::isPresent).map(Optional::get).map(AbstractItemBuilder::getId).map(this.getType() == Type.ROWGROUP ? itemId -> ((ImmutableItemRef)itemId).withParent(ImmutableItemIdPartial.of(Optional.of(this.getId()))) : itemId -> itemId).collect(Collectors.toList());
    }

    @Override
    protected void afterExpressionCompilation(Consumer<FormValidationError> errorConsumer) {
        super.afterExpressionCompilation(errorConsumer);
        this.requireBooleanExpression(this.canRemoveRowWhen, FormValidationError.Type.VISIBILITY, errorConsumer);
        this.requireBooleanExpression(this.canAddRowWhen, FormValidationError.Type.VISIBILITY, errorConsumer);
        Objects.requireNonNull(this.type, "group type missing");
        ItemId id = this.getId();
        this.getHoistingGroup().ifPresent(hoistingGroupBuilder -> {
            this.activeWhen = this.activeWhen == BooleanOperators.TRUE ? ImmutableIsActiveOperator.builder().itemId(hoistingGroupBuilder.getId()).build() : Operators.and(ImmutableIsActiveOperator.builder().itemId(hoistingGroupBuilder.getId()).build(), this.activeWhen);
        });
        ImmutableGroup.Builder builder = ImmutableGroup.builder().id(id).type(this.type.getItemType()).view(this.view).itemsExpression(EMPTY_ARRAY_EXPRESSION).isPrototype(false).activeExpression(this.activeWhen).canAddRowWhenExpression(this.canAddRowWhen).canRemoveRowWhenExpression(this.canRemoveRowWhen).className(ImmutableConstant.builder().valueType(ValueType.arrayOf((ValueType)ValueType.STRING)).value(this.classNames).build()).labelExpression(this.createLabelOperator(this.label)).descriptionExpression(this.createLabelOperator(this.description)).props(this.props);
        switch (this.type) {
            case ROOT: {
                builder = builder.allowedActionsExpression(ImmutableConditionalListOperator.builder().addItems((Pair<Expression, Action.Type>)ImmutablePair.of(Operators.not(ImmutableIsOnFirstPage.builder().build()), Action.Type.PREVIOUS)).addItems((Pair<Expression, Action.Type>)ImmutablePair.of(Operators.and(Operators.not(ImmutableIsOnLastPage.builder().build()), Operators.not(ImmutableIsInvalidAnswersOnActivePage.builder().pageContainerId(IdUtils.QUESTIONNAIRE_ID).build())), Action.Type.NEXT)).addItems((Pair<Expression, Action.Type>)ImmutablePair.of(Operators.not(ImmutableIsAnyInvalidAnswersOperator.builder().build()), Action.Type.COMPLETE)).addItems((Pair<Expression, Action.Type>)ImmutablePair.of(BooleanOperators.TRUE, Action.Type.ANSWER)).build());
                break;
            }
            case PAGE: {
                builder = builder.disabledExpression(Optional.of(ImmutableNotOnPageExpression.builder().page(id).build()));
                break;
            }
            case ROWGROUP: {
                builder = builder.allowedActionsExpression(ImmutableConditionalListOperator.builder().addItems((Pair<Expression, Action.Type>)ImmutablePair.of(ImmutableCanAddRowsOperator.of(id), Action.Type.ADD_ROW)).build());
                builder = builder.disabledExpression(this.getHoistingGroup().map(hoistingGroup -> Operators.isDisabled(hoistingGroup.getId())));
                break;
            }
            case GROUP: 
            case SURVEYGROUP: {
                builder = builder.disabledExpression(this.getHoistingGroup().map(hoistingGroup -> Operators.isDisabled(hoistingGroup.getId())));
            }
        }
        if (this.type.haveSubItems()) {
            builder = builder.itemsExpression(ImmutableConstant.builder().valueType(ValueType.arrayOf((ValueType)ValueType.STRING)).value(this.itemIds).build());
        }
        switch (this.type) {
            case PAGE: 
            case GROUP: {
                break;
            }
            case SURVEYGROUP: {
                builder = builder.valueSetId(Optional.ofNullable(this.valueSetId));
                break;
            }
            case ROWGROUP: {
                builder = builder.valueType(ValueType.arrayOf((ValueType)ValueType.INTEGER));
                break;
            }
            case ROOT: {
                builder = builder.availableItemsExpression(ImmutableConditionalListOperator.builder().addAllItems(this.itemIds.stream().map(item -> ImmutablePair.of(ImmutableIsActiveOperator.of(item), item)).collect(Collectors.toList())).build()).isInvalidAnswersExpression(ImmutableIsAnyInvalidAnswersOperator.builder().build());
            }
        }
        this.getProgramBuilder().addItem(builder.build());
        if (this.type == Type.ROWGROUP) {
            ImmutableItemIdPartial rowGroupPrototypeId = ImmutableItemIdPartial.of(Optional.of(id));
            this.getProgramBuilder().addItem(builder.id(rowGroupPrototypeId).type("row").isPrototype(true).valueType(null).itemsExpression(ImmutableRowItemsExpression.builder().itemIds(this.itemIds.stream().map(itemId -> ImmutableItemRef.of(itemId.getValue(), Optional.of(rowGroupPrototypeId))).collect(Collectors.toList())).build()).allowedActionsExpression(ImmutableConditionalListOperator.builder().addItems((Pair<Expression, Action.Type>)ImmutablePair.of(ImmutableCanRemoveRowOperator.of(rowGroupPrototypeId), Action.Type.DELETE_ROW)).build()).build());
        }
    }

    static enum Type {
        ROOT("questionnaire", true),
        PAGE("group", true),
        GROUP("group", true),
        ROWGROUP("rowgroup", false),
        SURVEYGROUP("surveygroup", true);

        private final String itemType;
        private final boolean haveSubItems;

        public boolean haveSubItems() {
            return this.haveSubItems;
        }

        public String getItemType() {
            return this.itemType;
        }

        private Type(String itemType, boolean haveSubItems) {
            this.itemType = itemType;
            this.haveSubItems = haveSubItems;
        }
    }
}

