/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormValidationError;
import io.dialob.form.service.api.validation.FormValidator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormValidatorExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormValidatorExecutor.class);
    private final List<FormValidator> formValidators;

    public FormValidatorExecutor(List<FormValidator> formValidators) {
        this.formValidators = formValidators;
    }

    @Nonnull
    public List<FormValidationError> validate(@Nonnull Form form) {
        return this.formValidators.stream().map(formValidator -> formValidator.validate(form)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

