/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.session.engine.program.expr.OutputFormatter;
import io.dialob.session.engine.session.AsyncFunctionCall;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.Scope;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface EvalContext {
    @Nonnull
    public Optional<ItemState> getItemState(@Nonnull ItemId var1);

    @Nonnull
    public Optional<ItemState> getOriginalItemState(@Nonnull ItemId var1);

    @Nonnull
    public Optional<ItemState> findPrototype(@Nonnull ItemId var1);

    @Nonnull
    public Stream<ErrorState> findErrorPrototypes(@Nonnull ItemId var1);

    @Nonnull
    public Optional<ValueSetState> getValueSetState(@Nonnull ValueSetId var1);

    @Nullable
    public Object getItemValue(ItemId var1);

    public EvalContext withScope(Scope var1);

    public EvalContext getParent();

    public void registerUpdate(ItemState var1, ItemState var2);

    public void registerUpdate(ErrorState var1, ErrorState var2);

    public void registerUpdate(@Nonnull ValueSetState var1, ValueSetState var2);

    public void accept(@Nonnull UpdatedItemsVisitor var1);

    public String getLanguage();

    public void setLanguage(String var1);

    @Nonnull
    public Consumer<Event> getEventsConsumer();

    public Collection<ErrorState> getErrorStates();

    @Nonnull
    public FunctionRegistry getFunctionRegistry();

    @Nonnull
    default public LocalDate today() {
        return LocalDate.now(this.getClock());
    }

    @Nonnull
    default public LocalTime now() {
        return LocalTime.now(this.getClock());
    }

    @Nonnull
    public Clock getClock();

    @Nonnull
    public OutputFormatter getOutputFormatter();

    public boolean isActivating();

    public Optional<ItemState> findHoistingGroup(ItemId var1);

    public ItemId mapTo(ItemId var1, boolean var2);

    public boolean complete();

    public String queueAsyncFunctionCall(AsyncFunctionCall var1);

    public static abstract class AbstractDelegateUpdatedItemsVisitor
    implements UpdatedItemsVisitor {
        private final UpdatedItemsVisitor delegate;

        public AbstractDelegateUpdatedItemsVisitor(UpdatedItemsVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void start() {
            this.delegate.start();
        }

        @Override
        public Optional<UpdatedItemsVisitor.UpdatedItemStateVisitor> visitUpdatedItems() {
            return this.delegate.visitUpdatedItems();
        }

        @Override
        public Optional<UpdatedItemsVisitor.UpdatedErrorStateVisitor> visitUpdatedErrorStates() {
            return this.delegate.visitUpdatedErrorStates();
        }

        @Override
        public Optional<UpdatedItemsVisitor.UpdatedValueSetVisitor> visitUpdatedValueSets() {
            return this.delegate.visitUpdatedValueSets();
        }

        @Override
        public Optional<UpdatedItemsVisitor.AsyncFunctionCallVisitor> visitAsyncFunctionCalls() {
            return this.delegate.visitAsyncFunctionCalls();
        }

        @Override
        public void visitCompleted() {
            this.delegate.visitCompleted();
        }

        @Override
        public Optional<UpdatedItemsVisitor.UpdatedSessionStateVisitor> visitSession() {
            return this.delegate.visitSession();
        }

        @Override
        public void end() {
            this.delegate.end();
        }
    }

    public static interface UpdatedItemsVisitor {
        public Optional<UpdatedSessionStateVisitor> visitSession();

        default public void start() {
        }

        default public Optional<UpdatedItemStateVisitor> visitUpdatedItems() {
            return Optional.empty();
        }

        default public Optional<UpdatedErrorStateVisitor> visitUpdatedErrorStates() {
            return Optional.empty();
        }

        default public Optional<UpdatedValueSetVisitor> visitUpdatedValueSets() {
            return Optional.empty();
        }

        default public Optional<AsyncFunctionCallVisitor> visitAsyncFunctionCalls() {
            return Optional.empty();
        }

        default public void visitCompleted() {
        }

        default public void end() {
        }

        @FunctionalInterface
        public static interface AsyncFunctionCallVisitor {
            public void visitAsyncFunctionCall(@Nonnull AsyncFunctionCall var1);

            default public void end() {
            }
        }

        @FunctionalInterface
        public static interface UpdatedValueSetVisitor {
            public void visitUpdatedValueSet(@Nullable ValueSetState var1, @Nullable ValueSetState var2);

            default public void end() {
            }
        }

        @FunctionalInterface
        public static interface UpdatedErrorStateVisitor {
            public void visitUpdatedErrorState(@Nullable ErrorState var1, @Nullable ErrorState var2);

            default public void end() {
            }
        }

        @FunctionalInterface
        public static interface UpdatedItemStateVisitor {
            public void visitUpdatedItemState(@Nullable ItemState var1, @Nullable ItemState var2);

            default public void end() {
            }
        }

        @FunctionalInterface
        public static interface UpdatedSessionStateVisitor {
            public void visitLanguageChange(@Nonnull String var1, @Nonnull String var2);

            default public void end() {
            }
        }
    }
}

