/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import com.google.common.collect.Lists;
import io.dialob.api.proto.Action;
import io.dialob.session.engine.program.DependencyResolverVisitor;
import io.dialob.session.engine.program.DialobSessionEvalContextFactory;
import io.dialob.session.engine.program.model.Item;
import io.dialob.session.engine.program.model.Program;
import io.dialob.session.engine.session.ActiveDialobSessionUpdater;
import io.dialob.session.engine.session.CreateDialobSessionProgramVisitor;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.CommandFactory;
import io.dialob.session.engine.session.command.ErrorUpdateCommand;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.command.event.ItemAddedEvent;
import io.dialob.session.engine.session.command.event.ItemRemovedEvent;
import io.dialob.session.engine.session.command.event.RowGroupItemsInitEvent;
import io.dialob.session.engine.session.command.event.TargetEvent;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ItemId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobProgram
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobProgram.class);
    private static final long serialVersionUID = 2922819825920407874L;
    private final Program program;
    private final Map<EventMatcher, List<Command<?>>> inputUpdates;
    private final Map<ItemId, List<Command<?>>> itemCommands;
    private final Map<Command<?>, Set<Command<?>>> commandsToCommands;

    private DialobProgram(@Nonnull Program program, @Nonnull Map<EventMatcher, List<Command<?>>> inputUpdates, @Nonnull Map<ItemId, List<Command<?>>> itemCommands, @Nonnull Map<Command<?>, Set<Command<?>>> commandsToCommands) {
        this.program = Objects.requireNonNull(program);
        this.inputUpdates = Objects.requireNonNull(inputUpdates);
        this.itemCommands = Objects.requireNonNull(itemCommands);
        this.commandsToCommands = Objects.requireNonNull(commandsToCommands);
    }

    @Nonnull
    public static DialobProgram createDialobProgram(@Nonnull Program program) {
        DependencyResolverVisitor visitor = new DependencyResolverVisitor();
        program.accept(visitor);
        return new DialobProgram(program, visitor.getInputUpdates(), visitor.getItemCommands(), visitor.getCommandsToCommands());
    }

    public Stream<Command<?>> findDependencies(@Nonnull Event event) {
        return this.inputUpdates.entrySet().stream().filter(entry -> ((EventMatcher)entry.getKey()).matches(event)).flatMap(entry -> ((List)entry.getValue()).stream()).filter(Objects::nonNull).flatMap(command -> this.mapTo(event, command));
    }

    private <T, C extends Command<T>> Stream<C> mapTo(Event event, C command) {
        if (command instanceof ErrorUpdateCommand) {
            ErrorUpdateCommand updateCommand = (ErrorUpdateCommand)command;
            ErrorId errorId = (ErrorId)updateCommand.getTargetId();
            if (event instanceof ItemAddedEvent) {
                return Stream.of(updateCommand.withTargetId(errorId.withItemId(((ItemAddedEvent)event).getAddItemId())));
            }
            if (event instanceof ItemRemovedEvent) {
                return Stream.of(updateCommand.withTargetId(errorId.withItemId(((ItemRemovedEvent)event).getRemoveItemId())));
            }
            if (event instanceof RowGroupItemsInitEvent) {
                return Stream.of(updateCommand.withTargetId(errorId.withItemId(((RowGroupItemsInitEvent)event).getGroupId())));
            }
            if (errorId.isPartial() && event instanceof TargetEvent) {
                return Stream.of(updateCommand.withTargetId(errorId.withItemId(errorId.getItemId().withParent(((TargetEvent)event).getTargetId().getParent()))));
            }
        } else if (command instanceof UpdateCommand) {
            UpdateCommand updateCommand = (UpdateCommand)command;
            if (event instanceof ItemAddedEvent) {
                return Stream.of(updateCommand.withTargetId(((ItemAddedEvent)event).getAddItemId()));
            }
            if (event instanceof ItemRemovedEvent) {
                return Stream.of(updateCommand.withTargetId(((ItemRemovedEvent)event).getRemoveItemId()));
            }
            if (event instanceof RowGroupItemsInitEvent) {
                return Stream.of(updateCommand.withTargetId(((RowGroupItemsInitEvent)event).getGroupId()));
            }
        }
        return Stream.of(command);
    }

    public Set<Event> allUpdates() {
        return this.inputUpdates.values().stream().flatMap(Collection::stream).map(Command::getTriggers).flatMap(Collection::stream).map(Trigger::getAllEvents).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Deprecated
    public DialobSession createSession(@Nonnull DialobSessionEvalContextFactory sessionContextFactory, String tenantId, String sessionId, String language, String activePage) {
        return this.createSession(sessionContextFactory, tenantId, sessionId, language, activePage, (itemId, item) -> Optional.empty(), valueSetId -> Collections.emptyList(), null, null, null);
    }

    public DialobSession createSession(@Nonnull DialobSessionEvalContextFactory sessionContextFactory, String tenantId, String sessionId, String language, final String activePage, @Nonnull CreateDialobSessionProgramVisitor.InitialValueResolver initialValueResolver, CreateDialobSessionProgramVisitor.ProvidedValueSetEntriesResolver findProvidedValueSetEntries, Date completed, Date opened, Date lastAnswer) {
        final CreateDialobSessionProgramVisitor createDialobSessionProgramVisitor = new CreateDialobSessionProgramVisitor(tenantId, sessionId, language, activePage, initialValueResolver, findProvidedValueSetEntries, this.itemCommands, null, null, null);
        this.program.accept(createDialobSessionProgramVisitor);
        DialobSession dialobSession = createDialobSessionProgramVisitor.getDialobSession();
        new ActiveDialobSessionUpdater(sessionContextFactory, this, dialobSession){

            @Override
            protected void applyUpdates(@Nonnull Iterable<Action> actions) {
                createDialobSessionProgramVisitor.getUpdates().forEach(this::queueCommand);
                if (activePage == null) {
                    this.evalQueue.add(CommandFactory.nextPage());
                }
            }
        }.dispatchActions(Collections.emptyList());
        return dialobSession;
    }

    public Program getProgram() {
        return this.program;
    }

    public String toString() {
        return this.program.toString();
    }

    public Optional<Item> getItem(ItemId id) {
        return this.program.getItem(id);
    }

    public Set<Command<?>> getCommandsToCommands(Command<?> updateCommand) {
        return this.commandsToCommands.getOrDefault(updateCommand, Collections.emptySet());
    }

    private <T> List<T> merge(List<T> o, List<T> o1) {
        ArrayList list = Lists.newArrayList(o);
        list.addAll(o1);
        return list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialobProgram)) {
            return false;
        }
        DialobProgram other = (DialobProgram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Program this$program = this.getProgram();
        Program other$program = other.getProgram();
        if (this$program == null ? other$program != null : !this$program.equals(other$program)) {
            return false;
        }
        Map<EventMatcher, List<Command<?>>> this$inputUpdates = this.inputUpdates;
        Map<EventMatcher, List<Command<?>>> other$inputUpdates = other.inputUpdates;
        if (this$inputUpdates == null ? other$inputUpdates != null : !((Object)this$inputUpdates).equals(other$inputUpdates)) {
            return false;
        }
        Map<ItemId, List<Command<?>>> this$itemCommands = this.itemCommands;
        Map<ItemId, List<Command<?>>> other$itemCommands = other.itemCommands;
        if (this$itemCommands == null ? other$itemCommands != null : !((Object)this$itemCommands).equals(other$itemCommands)) {
            return false;
        }
        Map<Command<?>, Set<Command<?>>> this$commandsToCommands = this.commandsToCommands;
        Map<Command<?>, Set<Command<?>>> other$commandsToCommands = other.commandsToCommands;
        return !(this$commandsToCommands == null ? other$commandsToCommands != null : !((Object)this$commandsToCommands).equals(other$commandsToCommands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DialobProgram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Program $program = this.getProgram();
        result = result * 59 + ($program == null ? 43 : $program.hashCode());
        Map<EventMatcher, List<Command<?>>> $inputUpdates = this.inputUpdates;
        result = result * 59 + ($inputUpdates == null ? 43 : ((Object)$inputUpdates).hashCode());
        Map<ItemId, List<Command<?>>> $itemCommands = this.itemCommands;
        result = result * 59 + ($itemCommands == null ? 43 : ((Object)$itemCommands).hashCode());
        Map<Command<?>, Set<Command<?>>> $commandsToCommands = this.commandsToCommands;
        result = result * 59 + ($commandsToCommands == null ? 43 : ((Object)$commandsToCommands).hashCode());
        return result;
    }
}

