/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.ImmutableFormValidationError;
import io.dialob.session.engine.DebugUtil;
import io.dialob.session.engine.DependencyLoopException;
import io.dialob.session.engine.program.UpdateCommandFactory;
import io.dialob.session.engine.program.expr.arith.RowItemsExpression;
import io.dialob.session.engine.program.model.AbstractItemVisitor;
import io.dialob.session.engine.program.model.DisplayItem;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.Group;
import io.dialob.session.engine.program.model.ProgramVisitor;
import io.dialob.session.engine.program.model.VariableItem;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableErrorId;
import io.dialob.session.engine.session.model.ImmutableValueSetId;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DependencyResolverVisitor
implements ProgramVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyResolverVisitor.class);
    private final Map<EventMatcher, List<Command<?>>> inputUpdates = Maps.newHashMap();
    private final Map<ItemId, List<Command<?>>> itemCommands = Maps.newHashMap();
    private final UpdateCommandFactory updateCommandFactory = new UpdateCommandFactory();
    private Map<Command<?>, Set<Command<?>>> commandsToCommands;

    DependencyResolverVisitor() {
    }

    @Override
    public Optional<ProgramVisitor.ItemVisitor> visitItems() {
        return Optional.of(new AbstractItemVisitor(){

            @Override
            public void visitGroup(@Nonnull Group group) {
                ItemId groupId;
                this.visitDisplayItem(group);
                if (DependencyResolverVisitor.this.isRowgroup(group.getType()) || DependencyResolverVisitor.this.isRow(group.getType())) {
                    groupId = group.getId();
                    if (group.isPrototype()) {
                        Expression itemsExpression = group.getItemsExpression();
                        if (itemsExpression instanceof RowItemsExpression) {
                            RowItemsExpression rowItemsExpression = (RowItemsExpression)itemsExpression;
                            DependencyResolverVisitor.this.updateCommandFactory.createRowGroupItemsFromPrototype(groupId, rowItemsExpression.getItemIds());
                        }
                        DependencyResolverVisitor.this.updateCommandFactory.createUpdateGroupItems(groupId, itemsExpression);
                        group.getCanRemoveRowWhenExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateRowCanBeRemovedCommand(groupId, (Expression)expression));
                    } else {
                        DependencyResolverVisitor.this.updateCommandFactory.initRowGroupItems(groupId);
                        group.getCanAddRowWhenExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateRowsCanBeAddedCommand(groupId, (Expression)expression));
                    }
                } else {
                    groupId = group.getId();
                    DependencyResolverVisitor.this.updateCommandFactory.createUpdateGroupItems(groupId, group.getItemsExpression());
                }
                group.getAvailableItemsExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateAvailableItems(groupId, (Expression)expression));
                group.getIsInvalidAnswersExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateIsInvalidAnswersCommand(groupId, (Expression)expression));
                group.getAllowedActionsExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateAllowedActions(groupId, (Expression)expression));
            }

            @Override
            public void visitDisplayItem(@Nonnull DisplayItem displayItem) {
                ItemId itemId = displayItem.getId();
                displayItem.getActiveExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateActivity(itemId, (Expression)expression));
                displayItem.getRequiredExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateRequired(itemId, (Expression)expression));
                displayItem.getDisabledExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateDisabled(itemId, (Expression)expression));
                displayItem.getLabelExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateLabel(itemId, (Expression)expression));
                displayItem.getDescriptionExpression().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateDescription(itemId, (Expression)expression));
                displayItem.getClassName().ifPresent(expression -> DependencyResolverVisitor.this.updateCommandFactory.createUpdateClass(itemId, (Expression)expression));
                if (displayItem.isPrototype() && DependencyResolverVisitor.this.isRow(displayItem.getType())) {
                    DependencyResolverVisitor.this.updateCommandFactory.createRowGroupFromPrototype(itemId);
                }
            }

            @Override
            public void visitVariableItem(@Nonnull VariableItem variableItem) {
                DependencyResolverVisitor.this.updateCommandFactory.createUpdateVariable(variableItem.getId(), variableItem.getValueExpression());
            }
        });
    }

    private boolean isRowgroup(@Nonnull String type) {
        return "rowgroup".equals(type);
    }

    private boolean isRow(@Nonnull String type) {
        return "row".equals(type);
    }

    @Override
    public Optional<ProgramVisitor.ErrorVisitor> visitErrors() {
        return Optional.of(error -> {
            ImmutableErrorId targetId = ImmutableErrorId.of(error.getItemId(), error.getCode());
            this.updateCommandFactory.createUpdateValidationCommand(targetId, error.getValidationExpression());
            error.getDisabledExpression().ifPresent(disabledExpression -> this.updateCommandFactory.createUpdateValidationDisabled(targetId, (Expression)disabledExpression));
            if (error.getLabel() != null) {
                this.updateCommandFactory.createErrorLabelUpdateCommand(targetId, error.getLabel());
            }
        });
    }

    @Override
    public Optional<ProgramVisitor.ValueSetVisitor> visitValueSets() {
        return Optional.of(valueSet -> this.updateCommandFactory.createUpdateValueSetCommand(ImmutableValueSetId.of(valueSet.getId()), valueSet.getEntries()));
    }

    @Override
    public void end() {
        this.updateCommandFactory.getAllCommands().stream().filter(command -> command instanceof UpdateCommand).map(command -> (UpdateCommand)command).forEach(updateCommand -> this.itemCommands.computeIfAbsent((ItemId)updateCommand.getTargetId(), (Function<ItemId, List<Command<?>>>)((Function<ItemId, List>)targetId -> Lists.newArrayList())).add(updateCommand));
        this.updateCommandFactory.getAllCommands().stream().forEach(updateCommand -> updateCommand.getEventMatchers().forEach(eventMatcher -> this.inputUpdates.computeIfAbsent(Objects.requireNonNull(eventMatcher), key -> Lists.newArrayList()).add(updateCommand)));
        this.commandsToCommands = this.updateCommandFactory.getAllCommands().stream().collect(Collectors.toMap(command -> command, command -> this.findTriggers((Command)command).map(Trigger::getAllEvents).flatMap(Collection::stream).flatMap(event -> this.inputUpdates.entrySet().stream().filter(entry -> ((EventMatcher)entry.getKey()).matches((Event)event)).flatMap(entry -> ((List)entry.getValue()).stream())).collect(Collectors.toSet())));
        this.loopScan();
        this.commandsToCommands.entrySet().stream().forEach(entry -> {
            Set set;
            Set prevSet;
            boolean same;
            do {
                prevSet = (Set)entry.getValue();
                set = prevSet.stream().flatMap(updateCommand -> Streams.concat((Stream[])new Stream[]{Stream.of(updateCommand), this.commandsToCommands.get(updateCommand).stream()})).collect(Collectors.toSet());
                entry.setValue(set);
                if (!set.contains(entry.getKey())) continue;
                throw new RuntimeException("Command loop! " + entry.getKey());
            } while (!(same = prevSet.equals(set)));
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>> Command dependencies >>>");
            this.commandsToCommands.forEach((key, value) -> {
                LOGGER.debug("Command : {}", (Object)DebugUtil.commandToString(key));
                value.forEach(command -> LOGGER.debug("  <= {}", (Object)DebugUtil.commandToString(command)));
            });
            LOGGER.debug("<<< Command dependencies <<<");
        }
    }

    private <T> Stream<Trigger<T>> findTriggers(Command<T> command) {
        return command.getTriggers().stream();
    }

    private void loopScan() {
        for (Map.Entry<Command<?>, Set<Command<?>>> entry : this.commandsToCommands.entrySet()) {
            Command<?> key = entry.getKey();
            ArrayList path = new ArrayList();
            path.add(key);
            this.loopScan(path, key);
        }
    }

    private void loopScan(List<Command<?>> path, Command<?> next) {
        for (Command<?> command : this.commandsToCommands.get(next)) {
            boolean contains = path.contains(command);
            path.add(command);
            if (contains) {
                ItemId itemId = IdUtils.QUESTIONNAIRE_ID;
                if (command instanceof UpdateCommand) {
                    itemId = ((UpdateCommand)command).getTargetId();
                }
                throw new DependencyLoopException("dependency loop", (List<FormValidationError>)ImmutableList.of((Object)ImmutableFormValidationError.builder().type(FormValidationError.Type.GENERAL).level(FormValidationError.Level.ERROR).message("dependency loop").itemId(IdUtils.toString(itemId)).build()));
            }
            this.loopScan(path, command);
            path.remove(command);
        }
    }

    @Nonnull
    public Map<EventMatcher, List<Command<?>>> getInputUpdates() {
        return this.inputUpdates;
    }

    @Nonnull
    public Map<ItemId, List<Command<?>>> getItemCommands() {
        return this.itemCommands;
    }

    @Nonnull
    public Map<Command<?>, Set<Command<?>>> getCommandsToCommands() {
        return this.commandsToCommands == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.commandsToCommands);
    }
}

