package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ItemIdPartial}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemIdPartial.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableItemIdPartial.of()}.
 */
@Generated(from = "ItemIdPartial", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemIdPartial implements ItemIdPartial {
  private final @Nullable ItemId parent;

  @SuppressWarnings("unchecked") // safe covariant cast
  private ImmutableItemIdPartial(Optional<? extends ItemId> parent) {
    this.parent = parent.orElse(null);
  }

  private ImmutableItemIdPartial(
      ImmutableItemIdPartial original,
      @Nullable ItemId parent) {
    this.parent = parent;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @Override
  public Optional<ItemId> getParent() {
    return Optional.ofNullable(parent);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ItemIdPartial#getParent() parent} attribute.
   * @param value The value for parent
   * @return A modified copy of {@code this} object
   */
  public final ImmutableItemIdPartial withParent(ItemId value) {
    @Nullable ItemId newValue = Objects.requireNonNull(value, "parent");
    if (this.parent == newValue) return this;
    return new ImmutableItemIdPartial(this, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ItemIdPartial#getParent() parent} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for parent
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableItemIdPartial withParent(Optional<? extends ItemId> optional) {
    @Nullable ItemId value = optional.orElse(null);
    if (this.parent == value) return this;
    return new ImmutableItemIdPartial(this, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemIdPartial} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemIdPartial
        && equalTo((ImmutableItemIdPartial) another);
  }

  private boolean equalTo(ImmutableItemIdPartial another) {
    return Objects.equals(parent, another.parent);
  }

  /**
   * Computes a hash code from attributes: {@code parent}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(parent);
    return h;
  }

  /**
   * Prints the immutable value {@code ItemIdPartial} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ItemIdPartial")
        .omitNullValues()
        .add("parent", parent)
        .toString();
  }

  /**
   * Construct a new immutable {@code ItemIdPartial} instance.
   * @param parent The value for the {@code parent} attribute
   * @return An immutable ItemIdPartial instance
   */
  public static ImmutableItemIdPartial of(Optional<? extends ItemId> parent) {
    return new ImmutableItemIdPartial(parent);
  }

  /**
   * Creates an immutable copy of a {@link ItemIdPartial} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemIdPartial instance
   */
  public static ImmutableItemIdPartial copyOf(ItemIdPartial instance) {
    if (instance instanceof ImmutableItemIdPartial) {
      return (ImmutableItemIdPartial) instance;
    }
    return ImmutableItemIdPartial.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemIdPartial ImmutableItemIdPartial}.
   * <pre>
   * ImmutableItemIdPartial.builder()
   *    .parent(io.dialob.session.engine.session.model.ItemId) // optional {@link ItemIdPartial#getParent() parent}
   *    .build();
   * </pre>
   * @return A new ImmutableItemIdPartial builder
   */
  public static ImmutableItemIdPartial.Builder builder() {
    return new ImmutableItemIdPartial.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemIdPartial ImmutableItemIdPartial}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemIdPartial", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable ItemId parent;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.model.ItemId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemId instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.model.ItemIdPartial} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemIdPartial instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ItemId) {
        ItemId instance = (ItemId) object;
        Optional<ItemId> parentOptional = instance.getParent();
        if (parentOptional.isPresent()) {
          parent(parentOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link ItemIdPartial#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(ItemId parent) {
      this.parent = Objects.requireNonNull(parent, "parent");
      return this;
    }

    /**
     * Initializes the optional value {@link ItemIdPartial#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(Optional<? extends ItemId> parent) {
      this.parent = parent.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemIdPartial ImmutableItemIdPartial}.
     * @return An immutable instance of ItemIdPartial
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemIdPartial build() {
      return new ImmutableItemIdPartial(null, parent);
    }
  }
}
