package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ErrorId}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableErrorId.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableErrorId.of()}.
 */
@Generated(from = "ErrorId", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableErrorId implements ErrorId {
  private final ItemId itemId;
  private final @Nullable String code;

  private ImmutableErrorId(
      ItemId itemId,
      @Nullable String code) {
    this.itemId = Objects.requireNonNull(itemId, "itemId");
    this.code = code;
  }

  private ImmutableErrorId(
      ImmutableErrorId original,
      ItemId itemId,
      @Nullable String code) {
    this.itemId = itemId;
    this.code = code;
  }

  /**
   * @return The value of the {@code itemId} attribute
   */
  @Override
  public ItemId getItemId() {
    return itemId;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @Override
  public @Nullable String getCode() {
    return code;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorId#getItemId() itemId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorId withItemId(ItemId value) {
    if (this.itemId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "itemId");
    return new ImmutableErrorId(this, newValue, this.code);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorId#getCode() code} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorId withCode(@Nullable String value) {
    if (Objects.equals(this.code, value)) return this;
    return new ImmutableErrorId(this, this.itemId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableErrorId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableErrorId
        && equalTo((ImmutableErrorId) another);
  }

  private boolean equalTo(ImmutableErrorId another) {
    return itemId.equals(another.itemId)
        && Objects.equals(code, another.code);
  }

  /**
   * Computes a hash code from attributes: {@code itemId}, {@code code}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + itemId.hashCode();
    h += (h << 5) + Objects.hashCode(code);
    return h;
  }

  /**
   * Prints the immutable value {@code ErrorId} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorId")
        .omitNullValues()
        .add("itemId", itemId)
        .add("code", code)
        .toString();
  }

  /**
   * Construct a new immutable {@code ErrorId} instance.
   * @param itemId The value for the {@code itemId} attribute
   * @param code The value for the {@code code} attribute
   * @return An immutable ErrorId instance
   */
  public static ImmutableErrorId of(ItemId itemId, @Nullable String code) {
    return new ImmutableErrorId(itemId, code);
  }

  /**
   * Creates an immutable copy of a {@link ErrorId} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ErrorId instance
   */
  public static ImmutableErrorId copyOf(ErrorId instance) {
    if (instance instanceof ImmutableErrorId) {
      return (ImmutableErrorId) instance;
    }
    return ImmutableErrorId.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableErrorId ImmutableErrorId}.
   * <pre>
   * ImmutableErrorId.builder()
   *    .itemId(io.dialob.session.engine.session.model.ItemId) // required {@link ErrorId#getItemId() itemId}
   *    .code(String | null) // nullable {@link ErrorId#getCode() code}
   *    .build();
   * </pre>
   * @return A new ImmutableErrorId builder
   */
  public static ImmutableErrorId.Builder builder() {
    return new ImmutableErrorId.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableErrorId ImmutableErrorId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ErrorId", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ITEM_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId itemId;
    private @Nullable String code;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ErrorId} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ErrorId instance) {
      Objects.requireNonNull(instance, "instance");
      itemId(instance.getItemId());
      @Nullable String codeValue = instance.getCode();
      if (codeValue != null) {
        code(codeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorId#getItemId() itemId} attribute.
     * @param itemId The value for itemId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemId(ItemId itemId) {
      this.itemId = Objects.requireNonNull(itemId, "itemId");
      initBits &= ~INIT_BIT_ITEM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorId#getCode() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder code(@Nullable String code) {
      this.code = code;
      return this;
    }

    /**
     * Builds a new {@link ImmutableErrorId ImmutableErrorId}.
     * @return An immutable instance of ErrorId
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableErrorId build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableErrorId(null, itemId, code);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ITEM_ID) != 0) attributes.add("itemId");
      return "Cannot build ErrorId, some of required attributes are not set " + attributes;
    }
  }
}
