package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TargetEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTargetEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTargetEvent.of()}.
 */
@Generated(from = "TargetEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTargetEvent implements TargetEvent {
  private final ItemId targetId;

  private ImmutableTargetEvent(ItemId targetId) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
  }

  private ImmutableTargetEvent(ImmutableTargetEvent original, ItemId targetId) {
    this.targetId = targetId;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TargetEvent#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTargetEvent withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableTargetEvent(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTargetEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTargetEvent
        && equalTo((ImmutableTargetEvent) another);
  }

  private boolean equalTo(ImmutableTargetEvent another) {
    return targetId.equals(another.targetId);
  }

  /**
   * Computes a hash code from attributes: {@code targetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + targetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TargetEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TargetEvent")
        .omitNullValues()
        .add("targetId", targetId)
        .toString();
  }

  /**
   * Construct a new immutable {@code TargetEvent} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @return An immutable TargetEvent instance
   */
  public static ImmutableTargetEvent of(ItemId targetId) {
    return new ImmutableTargetEvent(targetId);
  }

  /**
   * Creates an immutable copy of a {@link TargetEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TargetEvent instance
   */
  public static ImmutableTargetEvent copyOf(TargetEvent instance) {
    if (instance instanceof ImmutableTargetEvent) {
      return (ImmutableTargetEvent) instance;
    }
    return ImmutableTargetEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTargetEvent ImmutableTargetEvent}.
   * <pre>
   * ImmutableTargetEvent.builder()
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link TargetEvent#getTargetId() targetId}
   *    .build();
   * </pre>
   * @return A new ImmutableTargetEvent builder
   */
  public static ImmutableTargetEvent.Builder builder() {
    return new ImmutableTargetEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTargetEvent ImmutableTargetEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TargetEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId targetId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TargetEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TargetEvent instance) {
      Objects.requireNonNull(instance, "instance");
      targetId(instance.getTargetId());
      return this;
    }

    /**
     * Initializes the value for the {@link TargetEvent#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTargetEvent ImmutableTargetEvent}.
     * @return An immutable instance of TargetEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTargetEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTargetEvent(null, targetId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      return "Cannot build TargetEvent, some of required attributes are not set " + attributes;
    }
  }
}
