package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ItemRemovedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemRemovedEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableItemRemovedEvent.of()}.
 */
@Generated(from = "ItemRemovedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemRemovedEvent
    implements ItemRemovedEvent {
  private final ItemId removeItemId;

  private ImmutableItemRemovedEvent(ItemId removeItemId) {
    this.removeItemId = Objects.requireNonNull(removeItemId, "removeItemId");
  }

  private ImmutableItemRemovedEvent(ImmutableItemRemovedEvent original, ItemId removeItemId) {
    this.removeItemId = removeItemId;
  }

  /**
   * @return The value of the {@code removeItemId} attribute
   */
  @Override
  public ItemId getRemoveItemId() {
    return removeItemId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRemovedEvent#getRemoveItemId() removeItemId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for removeItemId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRemovedEvent withRemoveItemId(ItemId value) {
    if (this.removeItemId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "removeItemId");
    return new ImmutableItemRemovedEvent(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemRemovedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemRemovedEvent
        && equalTo((ImmutableItemRemovedEvent) another);
  }

  private boolean equalTo(ImmutableItemRemovedEvent another) {
    return removeItemId.equals(another.removeItemId);
  }

  /**
   * Computes a hash code from attributes: {@code removeItemId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + removeItemId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemRemovedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ItemRemovedEvent")
        .omitNullValues()
        .add("removeItemId", removeItemId)
        .toString();
  }

  /**
   * Construct a new immutable {@code ItemRemovedEvent} instance.
   * @param removeItemId The value for the {@code removeItemId} attribute
   * @return An immutable ItemRemovedEvent instance
   */
  public static ImmutableItemRemovedEvent of(ItemId removeItemId) {
    return new ImmutableItemRemovedEvent(removeItemId);
  }

  /**
   * Creates an immutable copy of a {@link ItemRemovedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemRemovedEvent instance
   */
  public static ImmutableItemRemovedEvent copyOf(ItemRemovedEvent instance) {
    if (instance instanceof ImmutableItemRemovedEvent) {
      return (ImmutableItemRemovedEvent) instance;
    }
    return ImmutableItemRemovedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemRemovedEvent ImmutableItemRemovedEvent}.
   * <pre>
   * ImmutableItemRemovedEvent.builder()
   *    .removeItemId(io.dialob.session.engine.session.model.ItemId) // required {@link ItemRemovedEvent#getRemoveItemId() removeItemId}
   *    .build();
   * </pre>
   * @return A new ImmutableItemRemovedEvent builder
   */
  public static ImmutableItemRemovedEvent.Builder builder() {
    return new ImmutableItemRemovedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemRemovedEvent ImmutableItemRemovedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemRemovedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REMOVE_ITEM_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId removeItemId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemRemovedEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemRemovedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      removeItemId(instance.getRemoveItemId());
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRemovedEvent#getRemoveItemId() removeItemId} attribute.
     * @param removeItemId The value for removeItemId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder removeItemId(ItemId removeItemId) {
      this.removeItemId = Objects.requireNonNull(removeItemId, "removeItemId");
      initBits &= ~INIT_BIT_REMOVE_ITEM_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemRemovedEvent ImmutableItemRemovedEvent}.
     * @return An immutable instance of ItemRemovedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemRemovedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemRemovedEvent(null, removeItemId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REMOVE_ITEM_ID) != 0) attributes.add("removeItemId");
      return "Cannot build ItemRemovedEvent, some of required attributes are not set " + attributes;
    }
  }
}
