package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DisabledUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDisabledUpdatedEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDisabledUpdatedEvent.of()}.
 */
@Generated(from = "DisabledUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDisabledUpdatedEvent
    implements DisabledUpdatedEvent {
  private final TargetEvent target;

  private ImmutableDisabledUpdatedEvent(TargetEvent target) {
    this.target = Objects.requireNonNull(target, "target");
  }

  private ImmutableDisabledUpdatedEvent(
      ImmutableDisabledUpdatedEvent original,
      TargetEvent target) {
    this.target = target;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @Override
  public TargetEvent getTarget() {
    return target;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DisabledUpdatedEvent#getTarget() target} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDisabledUpdatedEvent withTarget(TargetEvent value) {
    if (this.target == value) return this;
    TargetEvent newValue = Objects.requireNonNull(value, "target");
    return new ImmutableDisabledUpdatedEvent(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDisabledUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDisabledUpdatedEvent
        && equalTo((ImmutableDisabledUpdatedEvent) another);
  }

  private boolean equalTo(ImmutableDisabledUpdatedEvent another) {
    return target.equals(another.target);
  }

  /**
   * Computes a hash code from attributes: {@code target}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + target.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DisabledUpdatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DisabledUpdatedEvent")
        .omitNullValues()
        .add("target", target)
        .toString();
  }

  /**
   * Construct a new immutable {@code DisabledUpdatedEvent} instance.
   * @param target The value for the {@code target} attribute
   * @return An immutable DisabledUpdatedEvent instance
   */
  public static ImmutableDisabledUpdatedEvent of(TargetEvent target) {
    return new ImmutableDisabledUpdatedEvent(target);
  }

  /**
   * Creates an immutable copy of a {@link DisabledUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DisabledUpdatedEvent instance
   */
  public static ImmutableDisabledUpdatedEvent copyOf(DisabledUpdatedEvent instance) {
    if (instance instanceof ImmutableDisabledUpdatedEvent) {
      return (ImmutableDisabledUpdatedEvent) instance;
    }
    return ImmutableDisabledUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDisabledUpdatedEvent ImmutableDisabledUpdatedEvent}.
   * <pre>
   * ImmutableDisabledUpdatedEvent.builder()
   *    .target(io.dialob.session.engine.session.command.event.TargetEvent) // required {@link DisabledUpdatedEvent#getTarget() target}
   *    .build();
   * </pre>
   * @return A new ImmutableDisabledUpdatedEvent builder
   */
  public static ImmutableDisabledUpdatedEvent.Builder builder() {
    return new ImmutableDisabledUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDisabledUpdatedEvent ImmutableDisabledUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DisabledUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET = 0x1L;
    private long initBits = 0x1L;

    private @Nullable TargetEvent target;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.AttributeEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AttributeEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.DisabledUpdatedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DisabledUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AttributeEvent) {
        AttributeEvent instance = (AttributeEvent) object;
        target(instance.getTarget());
      }
    }

    /**
     * Initializes the value for the {@link DisabledUpdatedEvent#getTarget() target} attribute.
     * @param target The value for target 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder target(TargetEvent target) {
      this.target = Objects.requireNonNull(target, "target");
      initBits &= ~INIT_BIT_TARGET;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDisabledUpdatedEvent ImmutableDisabledUpdatedEvent}.
     * @return An immutable instance of DisabledUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDisabledUpdatedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDisabledUpdatedEvent(null, target);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET) != 0) attributes.add("target");
      return "Cannot build DisabledUpdatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
