package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DescriptionUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDescriptionUpdatedEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDescriptionUpdatedEvent.of()}.
 */
@Generated(from = "DescriptionUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDescriptionUpdatedEvent
    implements DescriptionUpdatedEvent {
  private final TargetEvent target;

  private ImmutableDescriptionUpdatedEvent(TargetEvent target) {
    this.target = Objects.requireNonNull(target, "target");
  }

  private ImmutableDescriptionUpdatedEvent(
      ImmutableDescriptionUpdatedEvent original,
      TargetEvent target) {
    this.target = target;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @Override
  public TargetEvent getTarget() {
    return target;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DescriptionUpdatedEvent#getTarget() target} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDescriptionUpdatedEvent withTarget(TargetEvent value) {
    if (this.target == value) return this;
    TargetEvent newValue = Objects.requireNonNull(value, "target");
    return new ImmutableDescriptionUpdatedEvent(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDescriptionUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDescriptionUpdatedEvent
        && equalTo((ImmutableDescriptionUpdatedEvent) another);
  }

  private boolean equalTo(ImmutableDescriptionUpdatedEvent another) {
    return target.equals(another.target);
  }

  /**
   * Computes a hash code from attributes: {@code target}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + target.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DescriptionUpdatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DescriptionUpdatedEvent")
        .omitNullValues()
        .add("target", target)
        .toString();
  }

  /**
   * Construct a new immutable {@code DescriptionUpdatedEvent} instance.
   * @param target The value for the {@code target} attribute
   * @return An immutable DescriptionUpdatedEvent instance
   */
  public static ImmutableDescriptionUpdatedEvent of(TargetEvent target) {
    return new ImmutableDescriptionUpdatedEvent(target);
  }

  /**
   * Creates an immutable copy of a {@link DescriptionUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DescriptionUpdatedEvent instance
   */
  public static ImmutableDescriptionUpdatedEvent copyOf(DescriptionUpdatedEvent instance) {
    if (instance instanceof ImmutableDescriptionUpdatedEvent) {
      return (ImmutableDescriptionUpdatedEvent) instance;
    }
    return ImmutableDescriptionUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDescriptionUpdatedEvent ImmutableDescriptionUpdatedEvent}.
   * <pre>
   * ImmutableDescriptionUpdatedEvent.builder()
   *    .target(io.dialob.session.engine.session.command.event.TargetEvent) // required {@link DescriptionUpdatedEvent#getTarget() target}
   *    .build();
   * </pre>
   * @return A new ImmutableDescriptionUpdatedEvent builder
   */
  public static ImmutableDescriptionUpdatedEvent.Builder builder() {
    return new ImmutableDescriptionUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDescriptionUpdatedEvent ImmutableDescriptionUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DescriptionUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET = 0x1L;
    private long initBits = 0x1L;

    private @Nullable TargetEvent target;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.AttributeEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AttributeEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.DescriptionUpdatedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DescriptionUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AttributeEvent) {
        AttributeEvent instance = (AttributeEvent) object;
        target(instance.getTarget());
      }
    }

    /**
     * Initializes the value for the {@link DescriptionUpdatedEvent#getTarget() target} attribute.
     * @param target The value for target 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder target(TargetEvent target) {
      this.target = Objects.requireNonNull(target, "target");
      initBits &= ~INIT_BIT_TARGET;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDescriptionUpdatedEvent ImmutableDescriptionUpdatedEvent}.
     * @return An immutable instance of DescriptionUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDescriptionUpdatedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDescriptionUpdatedEvent(null, target);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET) != 0) attributes.add("target");
      return "Cannot build DescriptionUpdatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
