package io.dialob.session.engine.session.command.event;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ActivePageUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableActivePageUpdatedEvent.builder()}.
 */
@Generated(from = "ActivePageUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableActivePageUpdatedEvent
    implements ActivePageUpdatedEvent {

  private ImmutableActivePageUpdatedEvent(ImmutableActivePageUpdatedEvent.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableActivePageUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableActivePageUpdatedEvent
        && equalTo((ImmutableActivePageUpdatedEvent) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ImmutableActivePageUpdatedEvent another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 0;
  }

  /**
   * Prints the immutable value {@code ActivePageUpdatedEvent}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ActivePageUpdatedEvent{}";
  }

  /**
   * Creates an immutable copy of a {@link ActivePageUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ActivePageUpdatedEvent instance
   */
  public static ImmutableActivePageUpdatedEvent copyOf(ActivePageUpdatedEvent instance) {
    if (instance instanceof ImmutableActivePageUpdatedEvent) {
      return (ImmutableActivePageUpdatedEvent) instance;
    }
    return ImmutableActivePageUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableActivePageUpdatedEvent ImmutableActivePageUpdatedEvent}.
   * <pre>
   * ImmutableActivePageUpdatedEvent.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableActivePageUpdatedEvent builder
   */
  public static ImmutableActivePageUpdatedEvent.Builder builder() {
    return new ImmutableActivePageUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableActivePageUpdatedEvent ImmutableActivePageUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ActivePageUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ActivePageUpdatedEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ActivePageUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableActivePageUpdatedEvent ImmutableActivePageUpdatedEvent}.
     * @return An immutable instance of ActivePageUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableActivePageUpdatedEvent build() {
      return new ImmutableActivePageUpdatedEvent(this);
    }
  }
}
