package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.command.event.TargetEvent;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableTriggers} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link Triggers}.
 * @see ImmutableTriggers.RowGroupItemsInitEventsProvider
 * @see ImmutableTriggers.GroupItemsUpdatedEventProvider
 * @see ImmutableTriggers.GroupItemsUpdatedEventsProvider
 */
@Generated(from = "Triggers", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTriggers {
  private ImmutableTriggers() {}

  /**
   * Immutable implementation of {@link Triggers.RowGroupItemsInitEventsProvider}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTriggers.RowGroupItemsInitEventsProvider.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTriggers.RowGroupItemsInitEventsProvider.of()}.
   */
  @Generated(from = "Triggers.RowGroupItemsInitEventsProvider", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class RowGroupItemsInitEventsProvider
      implements Triggers.RowGroupItemsInitEventsProvider {
    private final ItemId prototypeId;

    private RowGroupItemsInitEventsProvider(ItemId prototypeId) {
      this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
    }

    private RowGroupItemsInitEventsProvider(
        ImmutableTriggers.RowGroupItemsInitEventsProvider original,
        ItemId prototypeId) {
      this.prototypeId = prototypeId;
    }

    /**
     * @return The value of the {@code prototypeId} attribute
     */
    @Override
    public ItemId getPrototypeId() {
      return prototypeId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Triggers.RowGroupItemsInitEventsProvider#getPrototypeId() prototypeId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for prototypeId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTriggers.RowGroupItemsInitEventsProvider withPrototypeId(ItemId value) {
      if (this.prototypeId == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "prototypeId");
      return new ImmutableTriggers.RowGroupItemsInitEventsProvider(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code RowGroupItemsInitEventsProvider} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTriggers.RowGroupItemsInitEventsProvider
          && equalTo((ImmutableTriggers.RowGroupItemsInitEventsProvider) another);
    }

    private boolean equalTo(ImmutableTriggers.RowGroupItemsInitEventsProvider another) {
      return prototypeId.equals(another.prototypeId);
    }

    /**
     * Computes a hash code from attributes: {@code prototypeId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + prototypeId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code RowGroupItemsInitEventsProvider} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("RowGroupItemsInitEventsProvider")
          .omitNullValues()
          .add("prototypeId", prototypeId)
          .toString();
    }

    /**
     * Construct a new immutable {@code RowGroupItemsInitEventsProvider} instance.
     * @param prototypeId The value for the {@code prototypeId} attribute
     * @return An immutable RowGroupItemsInitEventsProvider instance
     */
    public static ImmutableTriggers.RowGroupItemsInitEventsProvider of(ItemId prototypeId) {
      return new ImmutableTriggers.RowGroupItemsInitEventsProvider(prototypeId);
    }

    /**
     * Creates an immutable copy of a {@link Triggers.RowGroupItemsInitEventsProvider} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable RowGroupItemsInitEventsProvider instance
     */
    public static ImmutableTriggers.RowGroupItemsInitEventsProvider copyOf(Triggers.RowGroupItemsInitEventsProvider instance) {
      if (instance instanceof ImmutableTriggers.RowGroupItemsInitEventsProvider) {
        return (ImmutableTriggers.RowGroupItemsInitEventsProvider) instance;
      }
      return ImmutableTriggers.RowGroupItemsInitEventsProvider.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTriggers.RowGroupItemsInitEventsProvider RowGroupItemsInitEventsProvider}.
     * <pre>
     * ImmutableTriggers.RowGroupItemsInitEventsProvider.builder()
     *    .prototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link Triggers.RowGroupItemsInitEventsProvider#getPrototypeId() prototypeId}
     *    .build();
     * </pre>
     * @return A new RowGroupItemsInitEventsProvider builder
     */
    public static ImmutableTriggers.RowGroupItemsInitEventsProvider.Builder builder() {
      return new ImmutableTriggers.RowGroupItemsInitEventsProvider.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTriggers.RowGroupItemsInitEventsProvider RowGroupItemsInitEventsProvider}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Triggers.RowGroupItemsInitEventsProvider", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_PROTOTYPE_ID = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId prototypeId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code RowGroupItemsInitEventsProvider} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(Triggers.RowGroupItemsInitEventsProvider instance) {
        Objects.requireNonNull(instance, "instance");
        prototypeId(instance.getPrototypeId());
        return this;
      }

      /**
       * Initializes the value for the {@link Triggers.RowGroupItemsInitEventsProvider#getPrototypeId() prototypeId} attribute.
       * @param prototypeId The value for prototypeId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder prototypeId(ItemId prototypeId) {
        this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        initBits &= ~INIT_BIT_PROTOTYPE_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTriggers.RowGroupItemsInitEventsProvider RowGroupItemsInitEventsProvider}.
       * @return An immutable instance of RowGroupItemsInitEventsProvider
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTriggers.RowGroupItemsInitEventsProvider build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTriggers.RowGroupItemsInitEventsProvider(null, prototypeId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_PROTOTYPE_ID) != 0) attributes.add("prototypeId");
        return "Cannot build RowGroupItemsInitEventsProvider, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Triggers.GroupItemsUpdatedEventProvider}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTriggers.GroupItemsUpdatedEventProvider.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTriggers.GroupItemsUpdatedEventProvider.of()}.
   */
  @Generated(from = "Triggers.GroupItemsUpdatedEventProvider", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class GroupItemsUpdatedEventProvider
      implements Triggers.GroupItemsUpdatedEventProvider {
    private final TargetEvent targetEvent;

    private GroupItemsUpdatedEventProvider(TargetEvent targetEvent) {
      this.targetEvent = Objects.requireNonNull(targetEvent, "targetEvent");
    }

    private GroupItemsUpdatedEventProvider(
        ImmutableTriggers.GroupItemsUpdatedEventProvider original,
        TargetEvent targetEvent) {
      this.targetEvent = targetEvent;
    }

    /**
     * @return The value of the {@code targetEvent} attribute
     */
    @Override
    public TargetEvent getTargetEvent() {
      return targetEvent;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Triggers.GroupItemsUpdatedEventProvider#getTargetEvent() targetEvent} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetEvent
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTriggers.GroupItemsUpdatedEventProvider withTargetEvent(TargetEvent value) {
      if (this.targetEvent == value) return this;
      TargetEvent newValue = Objects.requireNonNull(value, "targetEvent");
      return new ImmutableTriggers.GroupItemsUpdatedEventProvider(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code GroupItemsUpdatedEventProvider} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTriggers.GroupItemsUpdatedEventProvider
          && equalTo((ImmutableTriggers.GroupItemsUpdatedEventProvider) another);
    }

    private boolean equalTo(ImmutableTriggers.GroupItemsUpdatedEventProvider another) {
      return targetEvent.equals(another.targetEvent);
    }

    /**
     * Computes a hash code from attributes: {@code targetEvent}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetEvent.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code GroupItemsUpdatedEventProvider} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("GroupItemsUpdatedEventProvider")
          .omitNullValues()
          .add("targetEvent", targetEvent)
          .toString();
    }

    /**
     * Construct a new immutable {@code GroupItemsUpdatedEventProvider} instance.
     * @param targetEvent The value for the {@code targetEvent} attribute
     * @return An immutable GroupItemsUpdatedEventProvider instance
     */
    public static ImmutableTriggers.GroupItemsUpdatedEventProvider of(TargetEvent targetEvent) {
      return new ImmutableTriggers.GroupItemsUpdatedEventProvider(targetEvent);
    }

    /**
     * Creates an immutable copy of a {@link Triggers.GroupItemsUpdatedEventProvider} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable GroupItemsUpdatedEventProvider instance
     */
    public static ImmutableTriggers.GroupItemsUpdatedEventProvider copyOf(Triggers.GroupItemsUpdatedEventProvider instance) {
      if (instance instanceof ImmutableTriggers.GroupItemsUpdatedEventProvider) {
        return (ImmutableTriggers.GroupItemsUpdatedEventProvider) instance;
      }
      return ImmutableTriggers.GroupItemsUpdatedEventProvider.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTriggers.GroupItemsUpdatedEventProvider GroupItemsUpdatedEventProvider}.
     * <pre>
     * ImmutableTriggers.GroupItemsUpdatedEventProvider.builder()
     *    .targetEvent(io.dialob.session.engine.session.command.event.TargetEvent) // required {@link Triggers.GroupItemsUpdatedEventProvider#getTargetEvent() targetEvent}
     *    .build();
     * </pre>
     * @return A new GroupItemsUpdatedEventProvider builder
     */
    public static ImmutableTriggers.GroupItemsUpdatedEventProvider.Builder builder() {
      return new ImmutableTriggers.GroupItemsUpdatedEventProvider.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTriggers.GroupItemsUpdatedEventProvider GroupItemsUpdatedEventProvider}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Triggers.GroupItemsUpdatedEventProvider", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_EVENT = 0x1L;
      private long initBits = 0x1L;

      private @Nullable TargetEvent targetEvent;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code GroupItemsUpdatedEventProvider} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(Triggers.GroupItemsUpdatedEventProvider instance) {
        Objects.requireNonNull(instance, "instance");
        targetEvent(instance.getTargetEvent());
        return this;
      }

      /**
       * Initializes the value for the {@link Triggers.GroupItemsUpdatedEventProvider#getTargetEvent() targetEvent} attribute.
       * @param targetEvent The value for targetEvent 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetEvent(TargetEvent targetEvent) {
        this.targetEvent = Objects.requireNonNull(targetEvent, "targetEvent");
        initBits &= ~INIT_BIT_TARGET_EVENT;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTriggers.GroupItemsUpdatedEventProvider GroupItemsUpdatedEventProvider}.
       * @return An immutable instance of GroupItemsUpdatedEventProvider
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTriggers.GroupItemsUpdatedEventProvider build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTriggers.GroupItemsUpdatedEventProvider(null, targetEvent);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_EVENT) != 0) attributes.add("targetEvent");
        return "Cannot build GroupItemsUpdatedEventProvider, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Triggers.GroupItemsUpdatedEventsProvider}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTriggers.GroupItemsUpdatedEventsProvider.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTriggers.GroupItemsUpdatedEventsProvider.of()}.
   */
  @Generated(from = "Triggers.GroupItemsUpdatedEventsProvider", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class GroupItemsUpdatedEventsProvider
      implements Triggers.GroupItemsUpdatedEventsProvider {
    private final ItemId prototypeId;

    private GroupItemsUpdatedEventsProvider(ItemId prototypeId) {
      this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
    }

    private GroupItemsUpdatedEventsProvider(
        ImmutableTriggers.GroupItemsUpdatedEventsProvider original,
        ItemId prototypeId) {
      this.prototypeId = prototypeId;
    }

    /**
     * @return The value of the {@code prototypeId} attribute
     */
    @Override
    public ItemId getPrototypeId() {
      return prototypeId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Triggers.GroupItemsUpdatedEventsProvider#getPrototypeId() prototypeId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for prototypeId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTriggers.GroupItemsUpdatedEventsProvider withPrototypeId(ItemId value) {
      if (this.prototypeId == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "prototypeId");
      return new ImmutableTriggers.GroupItemsUpdatedEventsProvider(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code GroupItemsUpdatedEventsProvider} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTriggers.GroupItemsUpdatedEventsProvider
          && equalTo((ImmutableTriggers.GroupItemsUpdatedEventsProvider) another);
    }

    private boolean equalTo(ImmutableTriggers.GroupItemsUpdatedEventsProvider another) {
      return prototypeId.equals(another.prototypeId);
    }

    /**
     * Computes a hash code from attributes: {@code prototypeId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + prototypeId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code GroupItemsUpdatedEventsProvider} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("GroupItemsUpdatedEventsProvider")
          .omitNullValues()
          .add("prototypeId", prototypeId)
          .toString();
    }

    /**
     * Construct a new immutable {@code GroupItemsUpdatedEventsProvider} instance.
     * @param prototypeId The value for the {@code prototypeId} attribute
     * @return An immutable GroupItemsUpdatedEventsProvider instance
     */
    public static ImmutableTriggers.GroupItemsUpdatedEventsProvider of(ItemId prototypeId) {
      return new ImmutableTriggers.GroupItemsUpdatedEventsProvider(prototypeId);
    }

    /**
     * Creates an immutable copy of a {@link Triggers.GroupItemsUpdatedEventsProvider} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable GroupItemsUpdatedEventsProvider instance
     */
    public static ImmutableTriggers.GroupItemsUpdatedEventsProvider copyOf(Triggers.GroupItemsUpdatedEventsProvider instance) {
      if (instance instanceof ImmutableTriggers.GroupItemsUpdatedEventsProvider) {
        return (ImmutableTriggers.GroupItemsUpdatedEventsProvider) instance;
      }
      return ImmutableTriggers.GroupItemsUpdatedEventsProvider.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTriggers.GroupItemsUpdatedEventsProvider GroupItemsUpdatedEventsProvider}.
     * <pre>
     * ImmutableTriggers.GroupItemsUpdatedEventsProvider.builder()
     *    .prototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link Triggers.GroupItemsUpdatedEventsProvider#getPrototypeId() prototypeId}
     *    .build();
     * </pre>
     * @return A new GroupItemsUpdatedEventsProvider builder
     */
    public static ImmutableTriggers.GroupItemsUpdatedEventsProvider.Builder builder() {
      return new ImmutableTriggers.GroupItemsUpdatedEventsProvider.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTriggers.GroupItemsUpdatedEventsProvider GroupItemsUpdatedEventsProvider}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Triggers.GroupItemsUpdatedEventsProvider", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_PROTOTYPE_ID = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId prototypeId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code GroupItemsUpdatedEventsProvider} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(Triggers.GroupItemsUpdatedEventsProvider instance) {
        Objects.requireNonNull(instance, "instance");
        prototypeId(instance.getPrototypeId());
        return this;
      }

      /**
       * Initializes the value for the {@link Triggers.GroupItemsUpdatedEventsProvider#getPrototypeId() prototypeId} attribute.
       * @param prototypeId The value for prototypeId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder prototypeId(ItemId prototypeId) {
        this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        initBits &= ~INIT_BIT_PROTOTYPE_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTriggers.GroupItemsUpdatedEventsProvider GroupItemsUpdatedEventsProvider}.
       * @return An immutable instance of GroupItemsUpdatedEventsProvider
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTriggers.GroupItemsUpdatedEventsProvider build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTriggers.GroupItemsUpdatedEventsProvider(null, prototypeId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_PROTOTYPE_ID) != 0) attributes.add("prototypeId");
        return "Cannot build GroupItemsUpdatedEventsProvider, some of required attributes are not set " + attributes;
      }
    }
  }
}
