package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SetRows}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSetRows.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSetRows.of()}.
 */
@Generated(from = "SetRows", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSetRows implements SetRows {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;
  private final ImmutableList<Integer> ids;

  private ImmutableSetRows(
      ItemId targetId,
      Iterable<Integer> ids,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.ids = ImmutableList.copyOf(ids);
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableSetRows(
      ImmutableSetRows original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId,
      ImmutableList<Integer> ids) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.ids = ids;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code ids} attribute
   */
  @Override
  public ImmutableList<Integer> getIds() {
    return ids;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetRows#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableSetRows withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetRows(this, newValue, this.targetId, this.ids);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetRows#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSetRows withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetRows(this, newValue, this.targetId, this.ids);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SetRows#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSetRows withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableSetRows(this, this.triggers, newValue, this.ids);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetRows#getIds() ids}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSetRows withIds(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableSetRows(this, this.triggers, this.targetId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetRows#getIds() ids}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ids elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSetRows withIds(Iterable<Integer> elements) {
    if (this.ids == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetRows(this, this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSetRows} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSetRows
        && equalTo((ImmutableSetRows) another);
  }

  private boolean equalTo(ImmutableSetRows another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && ids.equals(another.ids);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code ids}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + ids.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetRows} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SetRows")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("ids", ids)
        .toString();
  }

  /**
   * Construct a new immutable {@code SetRows} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param ids The value for the {@code ids} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable SetRows instance
   */
  public static ImmutableSetRows of(ItemId targetId, List<Integer> ids, List<Trigger<ItemState>> triggers) {
    return of(targetId, (Iterable<Integer>) ids, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code SetRows} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param ids The value for the {@code ids} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable SetRows instance
   */
  public static ImmutableSetRows of(ItemId targetId, Iterable<Integer> ids, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableSetRows(targetId, ids, triggers);
  }

  /**
   * Creates an immutable copy of a {@link SetRows} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SetRows instance
   */
  public static ImmutableSetRows copyOf(SetRows instance) {
    if (instance instanceof ImmutableSetRows) {
      return (ImmutableSetRows) instance;
    }
    return ImmutableSetRows.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSetRows ImmutableSetRows}.
   * <pre>
   * ImmutableSetRows.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ItemState&amp;gt;) // {@link SetRows#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link SetRows#getTargetId() targetId}
   *    .addIds|addAllIds(int) // {@link SetRows#getIds() ids} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSetRows builder
   */
  public static ImmutableSetRows.Builder builder() {
    return new ImmutableSetRows.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSetRows ImmutableSetRows}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SetRows", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;
    private ImmutableList.Builder<Integer> ids = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetRows} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SetRows instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      targetId(instance.getTargetId());
      addAllIds(instance.getIds());
      return this;
    }

    /**
     * Adds one element to {@link SetRows#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SetRows#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SetRows#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link SetRows#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link SetRows#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Adds one element to {@link SetRows#getIds() ids} list.
     * @param element A ids element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIds(int element) {
      this.ids.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SetRows#getIds() ids} list.
     * @param elements An array of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIds(int... elements) {
      this.ids.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SetRows#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ids(Iterable<Integer> elements) {
      this.ids = ImmutableList.builder();
      return addAllIds(elements);
    }

    /**
     * Adds elements to {@link SetRows#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllIds(Iterable<Integer> elements) {
      this.ids.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSetRows ImmutableSetRows}.
     * @return An immutable instance of SetRows
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSetRows build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSetRows(null, triggers.build(), targetId, ids.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      return "Cannot build SetRows, some of required attributes are not set " + attributes;
    }
  }
}
