package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RemoveRowItemsCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRemoveRowItemsCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRemoveRowItemsCommand.of()}.
 */
@Generated(from = "RemoveRowItemsCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRemoveRowItemsCommand
    implements RemoveRowItemsCommand {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;

  private ImmutableRemoveRowItemsCommand(
      ItemId targetId,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableRemoveRowItemsCommand(
      ImmutableRemoveRowItemsCommand original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId) {
    this.triggers = triggers;
    this.targetId = targetId;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RemoveRowItemsCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableRemoveRowItemsCommand withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRemoveRowItemsCommand(this, newValue, this.targetId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RemoveRowItemsCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRemoveRowItemsCommand withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRemoveRowItemsCommand(this, newValue, this.targetId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoveRowItemsCommand#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoveRowItemsCommand withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableRemoveRowItemsCommand(this, this.triggers, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRemoveRowItemsCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRemoveRowItemsCommand
        && equalTo((ImmutableRemoveRowItemsCommand) another);
  }

  private boolean equalTo(ImmutableRemoveRowItemsCommand another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveRowItemsCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RemoveRowItemsCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .toString();
  }

  /**
   * Construct a new immutable {@code RemoveRowItemsCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable RemoveRowItemsCommand instance
   */
  public static ImmutableRemoveRowItemsCommand of(ItemId targetId, List<Trigger<ItemState>> triggers) {
    return of(targetId, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code RemoveRowItemsCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable RemoveRowItemsCommand instance
   */
  public static ImmutableRemoveRowItemsCommand of(ItemId targetId, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableRemoveRowItemsCommand(targetId, triggers);
  }

  /**
   * Creates an immutable copy of a {@link RemoveRowItemsCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RemoveRowItemsCommand instance
   */
  public static ImmutableRemoveRowItemsCommand copyOf(RemoveRowItemsCommand instance) {
    if (instance instanceof ImmutableRemoveRowItemsCommand) {
      return (ImmutableRemoveRowItemsCommand) instance;
    }
    return ImmutableRemoveRowItemsCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRemoveRowItemsCommand ImmutableRemoveRowItemsCommand}.
   * <pre>
   * ImmutableRemoveRowItemsCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ItemState&amp;gt;) // {@link RemoveRowItemsCommand#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link RemoveRowItemsCommand#getTargetId() targetId}
   *    .build();
   * </pre>
   * @return A new ImmutableRemoveRowItemsCommand builder
   */
  public static ImmutableRemoveRowItemsCommand.Builder builder() {
    return new ImmutableRemoveRowItemsCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRemoveRowItemsCommand ImmutableRemoveRowItemsCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RemoveRowItemsCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveRowItemsCommand} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RemoveRowItemsCommand instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      targetId(instance.getTargetId());
      return this;
    }

    /**
     * Adds one element to {@link RemoveRowItemsCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RemoveRowItemsCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RemoveRowItemsCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link RemoveRowItemsCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveRowItemsCommand#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRemoveRowItemsCommand ImmutableRemoveRowItemsCommand}.
     * @return An immutable instance of RemoveRowItemsCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRemoveRowItemsCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRemoveRowItemsCommand(null, triggers.build(), targetId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      return "Cannot build RemoveRowItemsCommand, some of required attributes are not set " + attributes;
    }
  }
}
