package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NextPage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNextPage.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNextPage.of()}.
 */
@Generated(from = "NextPage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNextPage implements NextPage {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;

  private ImmutableNextPage(
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.triggers = ImmutableList.copyOf(triggers);
    this.targetId = Objects.requireNonNull(NextPage.super.getTargetId(), "targetId");
  }

  private ImmutableNextPage(ImmutableNextPage.Builder builder) {
    this.triggers = builder.triggers.build();
    this.targetId = builder.targetId != null
        ? builder.targetId
        : Objects.requireNonNull(NextPage.super.getTargetId(), "targetId");
  }

  private ImmutableNextPage(
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId) {
    this.triggers = triggers;
    this.targetId = targetId;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NextPage#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableNextPage withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNextPage(newValue, this.targetId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NextPage#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNextPage withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNextPage(newValue, this.targetId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NextPage#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNextPage withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableNextPage(this.triggers, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNextPage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNextPage
        && equalTo((ImmutableNextPage) another);
  }

  private boolean equalTo(ImmutableNextPage another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NextPage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NextPage")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .toString();
  }

  /**
   * Construct a new immutable {@code NextPage} instance.
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable NextPage instance
   */
  public static ImmutableNextPage of(List<Trigger<ItemState>> triggers) {
    return of((Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code NextPage} instance.
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable NextPage instance
   */
  public static ImmutableNextPage of(Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableNextPage(triggers);
  }

  /**
   * Creates an immutable copy of a {@link NextPage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NextPage instance
   */
  public static ImmutableNextPage copyOf(NextPage instance) {
    if (instance instanceof ImmutableNextPage) {
      return (ImmutableNextPage) instance;
    }
    return ImmutableNextPage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNextPage ImmutableNextPage}.
   * <pre>
   * ImmutableNextPage.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ItemState&amp;gt;) // {@link NextPage#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // optional {@link NextPage#getTargetId() targetId}
   *    .build();
   * </pre>
   * @return A new ImmutableNextPage builder
   */
  public static ImmutableNextPage.Builder builder() {
    return new ImmutableNextPage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNextPage ImmutableNextPage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NextPage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.NextPage} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NextPage instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.AbstractPageCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractPageCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof NextPage) {
        NextPage instance = (NextPage) object;
        if ((bits & 0x1L) == 0) {
          targetId(instance.getTargetId());
          bits |= 0x1L;
        }
        addAllTriggers(instance.getTriggers());
      }
      if (object instanceof AbstractPageCommand) {
        AbstractPageCommand instance = (AbstractPageCommand) object;
        if ((bits & 0x1L) == 0) {
          targetId(instance.getTargetId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link NextPage#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NextPage#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NextPage#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link NextPage#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link NextPage#getTargetId() targetId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link NextPage#getTargetId() targetId}.</em>
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      return this;
    }

    /**
     * Builds a new {@link ImmutableNextPage ImmutableNextPage}.
     * @return An immutable instance of NextPage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNextPage build() {
      return new ImmutableNextPage(this);
    }
  }
}
