package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GotoPage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGotoPage.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableGotoPage.of()}.
 */
@Generated(from = "GotoPage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGotoPage implements GotoPage {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;
  private final ItemId page;

  private ImmutableGotoPage(
      ItemId page,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.page = Objects.requireNonNull(page, "page");
    this.triggers = ImmutableList.copyOf(triggers);
    this.targetId = Objects.requireNonNull(GotoPage.super.getTargetId(), "targetId");
  }

  private ImmutableGotoPage(ImmutableGotoPage.Builder builder) {
    this.triggers = builder.triggers.build();
    this.page = builder.page;
    this.targetId = builder.targetId != null
        ? builder.targetId
        : Objects.requireNonNull(GotoPage.super.getTargetId(), "targetId");
  }

  private ImmutableGotoPage(
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId,
      ItemId page) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.page = page;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code page} attribute
   */
  @Override
  public ItemId getPage() {
    return page;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GotoPage#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableGotoPage withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableGotoPage(newValue, this.targetId, this.page);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GotoPage#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGotoPage withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableGotoPage(newValue, this.targetId, this.page);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GotoPage#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGotoPage withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableGotoPage(this.triggers, newValue, this.page);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GotoPage#getPage() page} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for page
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGotoPage withPage(ItemId value) {
    if (this.page == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "page");
    return new ImmutableGotoPage(this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGotoPage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGotoPage
        && equalTo((ImmutableGotoPage) another);
  }

  private boolean equalTo(ImmutableGotoPage another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && page.equals(another.page);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code page}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + page.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GotoPage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GotoPage")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("page", page)
        .toString();
  }

  /**
   * Construct a new immutable {@code GotoPage} instance.
   * @param page The value for the {@code page} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable GotoPage instance
   */
  public static ImmutableGotoPage of(ItemId page, List<Trigger<ItemState>> triggers) {
    return of(page, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code GotoPage} instance.
   * @param page The value for the {@code page} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable GotoPage instance
   */
  public static ImmutableGotoPage of(ItemId page, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableGotoPage(page, triggers);
  }

  /**
   * Creates an immutable copy of a {@link GotoPage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GotoPage instance
   */
  public static ImmutableGotoPage copyOf(GotoPage instance) {
    if (instance instanceof ImmutableGotoPage) {
      return (ImmutableGotoPage) instance;
    }
    return ImmutableGotoPage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGotoPage ImmutableGotoPage}.
   * <pre>
   * ImmutableGotoPage.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ItemState&amp;gt;) // {@link GotoPage#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // optional {@link GotoPage#getTargetId() targetId}
   *    .page(io.dialob.session.engine.session.model.ItemId) // required {@link GotoPage#getPage() page}
   *    .build();
   * </pre>
   * @return A new ImmutableGotoPage builder
   */
  public static ImmutableGotoPage.Builder builder() {
    return new ImmutableGotoPage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGotoPage ImmutableGotoPage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GotoPage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PAGE = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;
    private @Nullable ItemId page;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.GotoPage} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GotoPage instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.AbstractPageCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractPageCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof GotoPage) {
        GotoPage instance = (GotoPage) object;
        if ((bits & 0x1L) == 0) {
          targetId(instance.getTargetId());
          bits |= 0x1L;
        }
        addAllTriggers(instance.getTriggers());
        page(instance.getPage());
      }
      if (object instanceof AbstractPageCommand) {
        AbstractPageCommand instance = (AbstractPageCommand) object;
        if ((bits & 0x1L) == 0) {
          targetId(instance.getTargetId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link GotoPage#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link GotoPage#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GotoPage#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link GotoPage#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link GotoPage#getTargetId() targetId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GotoPage#getTargetId() targetId}.</em>
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      return this;
    }

    /**
     * Initializes the value for the {@link GotoPage#getPage() page} attribute.
     * @param page The value for page 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder page(ItemId page) {
      this.page = Objects.requireNonNull(page, "page");
      initBits &= ~INIT_BIT_PAGE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGotoPage ImmutableGotoPage}.
     * @return An immutable instance of GotoPage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGotoPage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGotoPage(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PAGE) != 0) attributes.add("page");
      return "Cannot build GotoPage, some of required attributes are not set " + attributes;
    }
  }
}
