package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableEventMatchers} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link EventMatchers}.
 * @see ImmutableEventMatchers.TargetIdEventMatcher
 * @see ImmutableEventMatchers.IsActiveTargetEventMatcher
 * @see ImmutableEventMatchers.IsRequiredTargetEventMatcher
 * @see ImmutableEventMatchers.IsDisabledTargetEventMatcher
 * @see ImmutableEventMatchers.IsValidTargetEventMatcher
 * @see ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher
 * @see ImmutableEventMatchers.ItemAddedEventMatcher
 * @see ImmutableEventMatchers.ItemRemovedEventMatcher
 * @see ImmutableEventMatchers.RowGroupItemsInitEventMatcher
 * @see ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher
 * @see ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher
 * @see ImmutableEventMatchers.ItemsChangedEventMatcher
 * @see ImmutableEventMatchers.AnsweredTargetEventMatcher
 * @see ImmutableEventMatchers.ActivePageEventMatcher
 * @see ImmutableEventMatchers.AvailableItemsEventMatcher
 * @see ImmutableEventMatchers.AnyErrorEventMatcher
 * @see ImmutableEventMatchers.TargetErrorEventMatcher
 * @see ImmutableEventMatchers.ErrorIdEventMatcher
 * @see ImmutableEventMatchers.ErrorActivityEventMatcher
 */
@Generated(from = "EventMatchers", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEventMatchers {
  private ImmutableEventMatchers() {}

  /**
   * Immutable implementation of {@link EventMatchers.TargetIdEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.TargetIdEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.TargetIdEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.TargetIdEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class TargetIdEventMatcher
      implements EventMatchers.TargetIdEventMatcher {
    private final ItemId targetId;

    private TargetIdEventMatcher(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
    }

    private TargetIdEventMatcher(
        ImmutableEventMatchers.TargetIdEventMatcher original,
        ItemId targetId) {
      this.targetId = targetId;
    }

    /**
     * @return The value of the {@code targetId} attribute
     */
    @Override
    public ItemId getTargetId() {
      return targetId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.TargetIdEventMatcher#getTargetId() targetId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.TargetIdEventMatcher withTargetId(ItemId value) {
      if (this.targetId == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "targetId");
      return new ImmutableEventMatchers.TargetIdEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code TargetIdEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.TargetIdEventMatcher
          && equalTo((ImmutableEventMatchers.TargetIdEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.TargetIdEventMatcher another) {
      return targetId.equals(another.targetId);
    }

    /**
     * Computes a hash code from attributes: {@code targetId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code TargetIdEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TargetIdEventMatcher")
          .omitNullValues()
          .add("targetId", targetId)
          .toString();
    }

    /**
     * Construct a new immutable {@code TargetIdEventMatcher} instance.
     * @param targetId The value for the {@code targetId} attribute
     * @return An immutable TargetIdEventMatcher instance
     */
    public static ImmutableEventMatchers.TargetIdEventMatcher of(ItemId targetId) {
      return new ImmutableEventMatchers.TargetIdEventMatcher(targetId);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.TargetIdEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TargetIdEventMatcher instance
     */
    public static ImmutableEventMatchers.TargetIdEventMatcher copyOf(EventMatchers.TargetIdEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.TargetIdEventMatcher) {
        return (ImmutableEventMatchers.TargetIdEventMatcher) instance;
      }
      return ImmutableEventMatchers.TargetIdEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.TargetIdEventMatcher TargetIdEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.TargetIdEventMatcher.builder()
     *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.TargetIdEventMatcher#getTargetId() targetId}
     *    .build();
     * </pre>
     * @return A new TargetIdEventMatcher builder
     */
    public static ImmutableEventMatchers.TargetIdEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.TargetIdEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.TargetIdEventMatcher TargetIdEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.TargetIdEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_ID = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId targetId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code TargetIdEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.TargetIdEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        targetId(instance.getTargetId());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.TargetIdEventMatcher#getTargetId() targetId} attribute.
       * @param targetId The value for targetId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetId(ItemId targetId) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        initBits &= ~INIT_BIT_TARGET_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.TargetIdEventMatcher TargetIdEventMatcher}.
       * @return An immutable instance of TargetIdEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.TargetIdEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.TargetIdEventMatcher(null, targetId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
        return "Cannot build TargetIdEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.IsActiveTargetEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.IsActiveTargetEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.IsActiveTargetEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.IsActiveTargetEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class IsActiveTargetEventMatcher
      implements EventMatchers.IsActiveTargetEventMatcher {
    private final ItemId targetMatcher;

    private IsActiveTargetEventMatcher(ItemId targetMatcher) {
      this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
    }

    private IsActiveTargetEventMatcher(
        ImmutableEventMatchers.IsActiveTargetEventMatcher original,
        ItemId targetMatcher) {
      this.targetMatcher = targetMatcher;
    }

    /**
     * @return The value of the {@code targetMatcher} attribute
     */
    @Override
    public ItemId getTargetMatcher() {
      return targetMatcher;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.IsActiveTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetMatcher
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.IsActiveTargetEventMatcher withTargetMatcher(ItemId value) {
      if (this.targetMatcher == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
      return new ImmutableEventMatchers.IsActiveTargetEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code IsActiveTargetEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.IsActiveTargetEventMatcher
          && equalTo((ImmutableEventMatchers.IsActiveTargetEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.IsActiveTargetEventMatcher another) {
      return targetMatcher.equals(another.targetMatcher);
    }

    /**
     * Computes a hash code from attributes: {@code targetMatcher}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetMatcher.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code IsActiveTargetEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IsActiveTargetEventMatcher")
          .omitNullValues()
          .add("targetMatcher", targetMatcher)
          .toString();
    }

    /**
     * Construct a new immutable {@code IsActiveTargetEventMatcher} instance.
     * @param targetMatcher The value for the {@code targetMatcher} attribute
     * @return An immutable IsActiveTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.IsActiveTargetEventMatcher of(ItemId targetMatcher) {
      return new ImmutableEventMatchers.IsActiveTargetEventMatcher(targetMatcher);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.IsActiveTargetEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable IsActiveTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.IsActiveTargetEventMatcher copyOf(EventMatchers.IsActiveTargetEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.IsActiveTargetEventMatcher) {
        return (ImmutableEventMatchers.IsActiveTargetEventMatcher) instance;
      }
      return ImmutableEventMatchers.IsActiveTargetEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.IsActiveTargetEventMatcher IsActiveTargetEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.IsActiveTargetEventMatcher.builder()
     *    .targetMatcher(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.IsActiveTargetEventMatcher#getTargetMatcher() targetMatcher}
     *    .build();
     * </pre>
     * @return A new IsActiveTargetEventMatcher builder
     */
    public static ImmutableEventMatchers.IsActiveTargetEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.IsActiveTargetEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.IsActiveTargetEventMatcher IsActiveTargetEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.IsActiveTargetEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_MATCHER = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId targetMatcher;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code IsActiveTargetEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.IsActiveTargetEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        targetMatcher(instance.getTargetMatcher());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.IsActiveTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
       * @param targetMatcher The value for targetMatcher 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetMatcher(ItemId targetMatcher) {
        this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        initBits &= ~INIT_BIT_TARGET_MATCHER;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.IsActiveTargetEventMatcher IsActiveTargetEventMatcher}.
       * @return An immutable instance of IsActiveTargetEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.IsActiveTargetEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.IsActiveTargetEventMatcher(null, targetMatcher);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_MATCHER) != 0) attributes.add("targetMatcher");
        return "Cannot build IsActiveTargetEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.IsRequiredTargetEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.IsRequiredTargetEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.IsRequiredTargetEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.IsRequiredTargetEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class IsRequiredTargetEventMatcher
      implements EventMatchers.IsRequiredTargetEventMatcher {
    private final ItemId targetMatcher;

    private IsRequiredTargetEventMatcher(ItemId targetMatcher) {
      this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
    }

    private IsRequiredTargetEventMatcher(
        ImmutableEventMatchers.IsRequiredTargetEventMatcher original,
        ItemId targetMatcher) {
      this.targetMatcher = targetMatcher;
    }

    /**
     * @return The value of the {@code targetMatcher} attribute
     */
    @Override
    public ItemId getTargetMatcher() {
      return targetMatcher;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.IsRequiredTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetMatcher
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.IsRequiredTargetEventMatcher withTargetMatcher(ItemId value) {
      if (this.targetMatcher == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
      return new ImmutableEventMatchers.IsRequiredTargetEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code IsRequiredTargetEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.IsRequiredTargetEventMatcher
          && equalTo((ImmutableEventMatchers.IsRequiredTargetEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.IsRequiredTargetEventMatcher another) {
      return targetMatcher.equals(another.targetMatcher);
    }

    /**
     * Computes a hash code from attributes: {@code targetMatcher}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetMatcher.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code IsRequiredTargetEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IsRequiredTargetEventMatcher")
          .omitNullValues()
          .add("targetMatcher", targetMatcher)
          .toString();
    }

    /**
     * Construct a new immutable {@code IsRequiredTargetEventMatcher} instance.
     * @param targetMatcher The value for the {@code targetMatcher} attribute
     * @return An immutable IsRequiredTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.IsRequiredTargetEventMatcher of(ItemId targetMatcher) {
      return new ImmutableEventMatchers.IsRequiredTargetEventMatcher(targetMatcher);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.IsRequiredTargetEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable IsRequiredTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.IsRequiredTargetEventMatcher copyOf(EventMatchers.IsRequiredTargetEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.IsRequiredTargetEventMatcher) {
        return (ImmutableEventMatchers.IsRequiredTargetEventMatcher) instance;
      }
      return ImmutableEventMatchers.IsRequiredTargetEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.IsRequiredTargetEventMatcher IsRequiredTargetEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.IsRequiredTargetEventMatcher.builder()
     *    .targetMatcher(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.IsRequiredTargetEventMatcher#getTargetMatcher() targetMatcher}
     *    .build();
     * </pre>
     * @return A new IsRequiredTargetEventMatcher builder
     */
    public static ImmutableEventMatchers.IsRequiredTargetEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.IsRequiredTargetEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.IsRequiredTargetEventMatcher IsRequiredTargetEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.IsRequiredTargetEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_MATCHER = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId targetMatcher;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code IsRequiredTargetEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.IsRequiredTargetEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        targetMatcher(instance.getTargetMatcher());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.IsRequiredTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
       * @param targetMatcher The value for targetMatcher 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetMatcher(ItemId targetMatcher) {
        this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        initBits &= ~INIT_BIT_TARGET_MATCHER;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.IsRequiredTargetEventMatcher IsRequiredTargetEventMatcher}.
       * @return An immutable instance of IsRequiredTargetEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.IsRequiredTargetEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.IsRequiredTargetEventMatcher(null, targetMatcher);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_MATCHER) != 0) attributes.add("targetMatcher");
        return "Cannot build IsRequiredTargetEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.IsDisabledTargetEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.IsDisabledTargetEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.IsDisabledTargetEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.IsDisabledTargetEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class IsDisabledTargetEventMatcher
      implements EventMatchers.IsDisabledTargetEventMatcher {
    private final ItemId targetMatcher;

    private IsDisabledTargetEventMatcher(ItemId targetMatcher) {
      this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
    }

    private IsDisabledTargetEventMatcher(
        ImmutableEventMatchers.IsDisabledTargetEventMatcher original,
        ItemId targetMatcher) {
      this.targetMatcher = targetMatcher;
    }

    /**
     * @return The value of the {@code targetMatcher} attribute
     */
    @Override
    public ItemId getTargetMatcher() {
      return targetMatcher;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.IsDisabledTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetMatcher
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.IsDisabledTargetEventMatcher withTargetMatcher(ItemId value) {
      if (this.targetMatcher == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
      return new ImmutableEventMatchers.IsDisabledTargetEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code IsDisabledTargetEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.IsDisabledTargetEventMatcher
          && equalTo((ImmutableEventMatchers.IsDisabledTargetEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.IsDisabledTargetEventMatcher another) {
      return targetMatcher.equals(another.targetMatcher);
    }

    /**
     * Computes a hash code from attributes: {@code targetMatcher}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetMatcher.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code IsDisabledTargetEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IsDisabledTargetEventMatcher")
          .omitNullValues()
          .add("targetMatcher", targetMatcher)
          .toString();
    }

    /**
     * Construct a new immutable {@code IsDisabledTargetEventMatcher} instance.
     * @param targetMatcher The value for the {@code targetMatcher} attribute
     * @return An immutable IsDisabledTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.IsDisabledTargetEventMatcher of(ItemId targetMatcher) {
      return new ImmutableEventMatchers.IsDisabledTargetEventMatcher(targetMatcher);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.IsDisabledTargetEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable IsDisabledTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.IsDisabledTargetEventMatcher copyOf(EventMatchers.IsDisabledTargetEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.IsDisabledTargetEventMatcher) {
        return (ImmutableEventMatchers.IsDisabledTargetEventMatcher) instance;
      }
      return ImmutableEventMatchers.IsDisabledTargetEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.IsDisabledTargetEventMatcher IsDisabledTargetEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.IsDisabledTargetEventMatcher.builder()
     *    .targetMatcher(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.IsDisabledTargetEventMatcher#getTargetMatcher() targetMatcher}
     *    .build();
     * </pre>
     * @return A new IsDisabledTargetEventMatcher builder
     */
    public static ImmutableEventMatchers.IsDisabledTargetEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.IsDisabledTargetEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.IsDisabledTargetEventMatcher IsDisabledTargetEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.IsDisabledTargetEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_MATCHER = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId targetMatcher;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code IsDisabledTargetEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.IsDisabledTargetEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        targetMatcher(instance.getTargetMatcher());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.IsDisabledTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
       * @param targetMatcher The value for targetMatcher 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetMatcher(ItemId targetMatcher) {
        this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        initBits &= ~INIT_BIT_TARGET_MATCHER;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.IsDisabledTargetEventMatcher IsDisabledTargetEventMatcher}.
       * @return An immutable instance of IsDisabledTargetEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.IsDisabledTargetEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.IsDisabledTargetEventMatcher(null, targetMatcher);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_MATCHER) != 0) attributes.add("targetMatcher");
        return "Cannot build IsDisabledTargetEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.IsValidTargetEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.IsValidTargetEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.IsValidTargetEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.IsValidTargetEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class IsValidTargetEventMatcher
      implements EventMatchers.IsValidTargetEventMatcher {
    private final ItemId targetMatcher;

    private IsValidTargetEventMatcher(ItemId targetMatcher) {
      this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
    }

    private IsValidTargetEventMatcher(
        ImmutableEventMatchers.IsValidTargetEventMatcher original,
        ItemId targetMatcher) {
      this.targetMatcher = targetMatcher;
    }

    /**
     * @return The value of the {@code targetMatcher} attribute
     */
    @Override
    public ItemId getTargetMatcher() {
      return targetMatcher;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.IsValidTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetMatcher
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.IsValidTargetEventMatcher withTargetMatcher(ItemId value) {
      if (this.targetMatcher == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
      return new ImmutableEventMatchers.IsValidTargetEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code IsValidTargetEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.IsValidTargetEventMatcher
          && equalTo((ImmutableEventMatchers.IsValidTargetEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.IsValidTargetEventMatcher another) {
      return targetMatcher.equals(another.targetMatcher);
    }

    /**
     * Computes a hash code from attributes: {@code targetMatcher}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetMatcher.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code IsValidTargetEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IsValidTargetEventMatcher")
          .omitNullValues()
          .add("targetMatcher", targetMatcher)
          .toString();
    }

    /**
     * Construct a new immutable {@code IsValidTargetEventMatcher} instance.
     * @param targetMatcher The value for the {@code targetMatcher} attribute
     * @return An immutable IsValidTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.IsValidTargetEventMatcher of(ItemId targetMatcher) {
      return new ImmutableEventMatchers.IsValidTargetEventMatcher(targetMatcher);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.IsValidTargetEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable IsValidTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.IsValidTargetEventMatcher copyOf(EventMatchers.IsValidTargetEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.IsValidTargetEventMatcher) {
        return (ImmutableEventMatchers.IsValidTargetEventMatcher) instance;
      }
      return ImmutableEventMatchers.IsValidTargetEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.IsValidTargetEventMatcher IsValidTargetEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.IsValidTargetEventMatcher.builder()
     *    .targetMatcher(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.IsValidTargetEventMatcher#getTargetMatcher() targetMatcher}
     *    .build();
     * </pre>
     * @return A new IsValidTargetEventMatcher builder
     */
    public static ImmutableEventMatchers.IsValidTargetEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.IsValidTargetEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.IsValidTargetEventMatcher IsValidTargetEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.IsValidTargetEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_MATCHER = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId targetMatcher;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code IsValidTargetEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.IsValidTargetEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        targetMatcher(instance.getTargetMatcher());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.IsValidTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
       * @param targetMatcher The value for targetMatcher 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetMatcher(ItemId targetMatcher) {
        this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        initBits &= ~INIT_BIT_TARGET_MATCHER;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.IsValidTargetEventMatcher IsValidTargetEventMatcher}.
       * @return An immutable instance of IsValidTargetEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.IsValidTargetEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.IsValidTargetEventMatcher(null, targetMatcher);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_MATCHER) != 0) attributes.add("targetMatcher");
        return "Cannot build IsValidTargetEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.AnyInvalidAnswersUpdatedEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher.builder()}.
   */
  @Generated(from = "EventMatchers.AnyInvalidAnswersUpdatedEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class AnyInvalidAnswersUpdatedEventMatcher
      implements EventMatchers.AnyInvalidAnswersUpdatedEventMatcher {

    private AnyInvalidAnswersUpdatedEventMatcher(ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code AnyInvalidAnswersUpdatedEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher
          && equalTo((ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 0;
    }

    /**
     * Prints the immutable value {@code AnyInvalidAnswersUpdatedEventMatcher}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "AnyInvalidAnswersUpdatedEventMatcher{}";
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.AnyInvalidAnswersUpdatedEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable AnyInvalidAnswersUpdatedEventMatcher instance
     */
    public static ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher copyOf(EventMatchers.AnyInvalidAnswersUpdatedEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher) {
        return (ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher) instance;
      }
      return ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher AnyInvalidAnswersUpdatedEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher.builder()
     *    .build();
     * </pre>
     * @return A new AnyInvalidAnswersUpdatedEventMatcher builder
     */
    public static ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher AnyInvalidAnswersUpdatedEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.AnyInvalidAnswersUpdatedEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code AnyInvalidAnswersUpdatedEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.AnyInvalidAnswersUpdatedEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher AnyInvalidAnswersUpdatedEventMatcher}.
       * @return An immutable instance of AnyInvalidAnswersUpdatedEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher build() {
        return new ImmutableEventMatchers.AnyInvalidAnswersUpdatedEventMatcher(this);
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.ItemAddedEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.ItemAddedEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.ItemAddedEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.ItemAddedEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class ItemAddedEventMatcher
      implements EventMatchers.ItemAddedEventMatcher {
    private final ItemId prototypeId;

    private ItemAddedEventMatcher(ItemId prototypeId) {
      this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
    }

    private ItemAddedEventMatcher(
        ImmutableEventMatchers.ItemAddedEventMatcher original,
        ItemId prototypeId) {
      this.prototypeId = prototypeId;
    }

    /**
     * @return The value of the {@code prototypeId} attribute
     */
    @Override
    public ItemId getPrototypeId() {
      return prototypeId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.ItemAddedEventMatcher#getPrototypeId() prototypeId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for prototypeId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.ItemAddedEventMatcher withPrototypeId(ItemId value) {
      if (this.prototypeId == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "prototypeId");
      return new ImmutableEventMatchers.ItemAddedEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ItemAddedEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.ItemAddedEventMatcher
          && equalTo((ImmutableEventMatchers.ItemAddedEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.ItemAddedEventMatcher another) {
      return prototypeId.equals(another.prototypeId);
    }

    /**
     * Computes a hash code from attributes: {@code prototypeId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + prototypeId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ItemAddedEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ItemAddedEventMatcher")
          .omitNullValues()
          .add("prototypeId", prototypeId)
          .toString();
    }

    /**
     * Construct a new immutable {@code ItemAddedEventMatcher} instance.
     * @param prototypeId The value for the {@code prototypeId} attribute
     * @return An immutable ItemAddedEventMatcher instance
     */
    public static ImmutableEventMatchers.ItemAddedEventMatcher of(ItemId prototypeId) {
      return new ImmutableEventMatchers.ItemAddedEventMatcher(prototypeId);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.ItemAddedEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ItemAddedEventMatcher instance
     */
    public static ImmutableEventMatchers.ItemAddedEventMatcher copyOf(EventMatchers.ItemAddedEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.ItemAddedEventMatcher) {
        return (ImmutableEventMatchers.ItemAddedEventMatcher) instance;
      }
      return ImmutableEventMatchers.ItemAddedEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.ItemAddedEventMatcher ItemAddedEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.ItemAddedEventMatcher.builder()
     *    .prototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.ItemAddedEventMatcher#getPrototypeId() prototypeId}
     *    .build();
     * </pre>
     * @return A new ItemAddedEventMatcher builder
     */
    public static ImmutableEventMatchers.ItemAddedEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.ItemAddedEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.ItemAddedEventMatcher ItemAddedEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.ItemAddedEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_PROTOTYPE_ID = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId prototypeId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ItemAddedEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.ItemAddedEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        prototypeId(instance.getPrototypeId());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.ItemAddedEventMatcher#getPrototypeId() prototypeId} attribute.
       * @param prototypeId The value for prototypeId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder prototypeId(ItemId prototypeId) {
        this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        initBits &= ~INIT_BIT_PROTOTYPE_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.ItemAddedEventMatcher ItemAddedEventMatcher}.
       * @return An immutable instance of ItemAddedEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.ItemAddedEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.ItemAddedEventMatcher(null, prototypeId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_PROTOTYPE_ID) != 0) attributes.add("prototypeId");
        return "Cannot build ItemAddedEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.ItemRemovedEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.ItemRemovedEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.ItemRemovedEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.ItemRemovedEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class ItemRemovedEventMatcher
      implements EventMatchers.ItemRemovedEventMatcher {
    private final ItemId prototypeId;

    private ItemRemovedEventMatcher(ItemId prototypeId) {
      this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
    }

    private ItemRemovedEventMatcher(
        ImmutableEventMatchers.ItemRemovedEventMatcher original,
        ItemId prototypeId) {
      this.prototypeId = prototypeId;
    }

    /**
     * @return The value of the {@code prototypeId} attribute
     */
    @Override
    public ItemId getPrototypeId() {
      return prototypeId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.ItemRemovedEventMatcher#getPrototypeId() prototypeId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for prototypeId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.ItemRemovedEventMatcher withPrototypeId(ItemId value) {
      if (this.prototypeId == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "prototypeId");
      return new ImmutableEventMatchers.ItemRemovedEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ItemRemovedEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.ItemRemovedEventMatcher
          && equalTo((ImmutableEventMatchers.ItemRemovedEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.ItemRemovedEventMatcher another) {
      return prototypeId.equals(another.prototypeId);
    }

    /**
     * Computes a hash code from attributes: {@code prototypeId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + prototypeId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ItemRemovedEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ItemRemovedEventMatcher")
          .omitNullValues()
          .add("prototypeId", prototypeId)
          .toString();
    }

    /**
     * Construct a new immutable {@code ItemRemovedEventMatcher} instance.
     * @param prototypeId The value for the {@code prototypeId} attribute
     * @return An immutable ItemRemovedEventMatcher instance
     */
    public static ImmutableEventMatchers.ItemRemovedEventMatcher of(ItemId prototypeId) {
      return new ImmutableEventMatchers.ItemRemovedEventMatcher(prototypeId);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.ItemRemovedEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ItemRemovedEventMatcher instance
     */
    public static ImmutableEventMatchers.ItemRemovedEventMatcher copyOf(EventMatchers.ItemRemovedEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.ItemRemovedEventMatcher) {
        return (ImmutableEventMatchers.ItemRemovedEventMatcher) instance;
      }
      return ImmutableEventMatchers.ItemRemovedEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.ItemRemovedEventMatcher ItemRemovedEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.ItemRemovedEventMatcher.builder()
     *    .prototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.ItemRemovedEventMatcher#getPrototypeId() prototypeId}
     *    .build();
     * </pre>
     * @return A new ItemRemovedEventMatcher builder
     */
    public static ImmutableEventMatchers.ItemRemovedEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.ItemRemovedEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.ItemRemovedEventMatcher ItemRemovedEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.ItemRemovedEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_PROTOTYPE_ID = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId prototypeId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ItemRemovedEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.ItemRemovedEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        prototypeId(instance.getPrototypeId());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.ItemRemovedEventMatcher#getPrototypeId() prototypeId} attribute.
       * @param prototypeId The value for prototypeId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder prototypeId(ItemId prototypeId) {
        this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        initBits &= ~INIT_BIT_PROTOTYPE_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.ItemRemovedEventMatcher ItemRemovedEventMatcher}.
       * @return An immutable instance of ItemRemovedEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.ItemRemovedEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.ItemRemovedEventMatcher(null, prototypeId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_PROTOTYPE_ID) != 0) attributes.add("prototypeId");
        return "Cannot build ItemRemovedEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.RowGroupItemsInitEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.RowGroupItemsInitEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.RowGroupItemsInitEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.RowGroupItemsInitEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class RowGroupItemsInitEventMatcher
      implements EventMatchers.RowGroupItemsInitEventMatcher {
    private final ItemId prototypeId;

    private RowGroupItemsInitEventMatcher(ItemId prototypeId) {
      this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
    }

    private RowGroupItemsInitEventMatcher(
        ImmutableEventMatchers.RowGroupItemsInitEventMatcher original,
        ItemId prototypeId) {
      this.prototypeId = prototypeId;
    }

    /**
     * @return The value of the {@code prototypeId} attribute
     */
    @Override
    public ItemId getPrototypeId() {
      return prototypeId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.RowGroupItemsInitEventMatcher#getPrototypeId() prototypeId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for prototypeId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.RowGroupItemsInitEventMatcher withPrototypeId(ItemId value) {
      if (this.prototypeId == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "prototypeId");
      return new ImmutableEventMatchers.RowGroupItemsInitEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code RowGroupItemsInitEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.RowGroupItemsInitEventMatcher
          && equalTo((ImmutableEventMatchers.RowGroupItemsInitEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.RowGroupItemsInitEventMatcher another) {
      return prototypeId.equals(another.prototypeId);
    }

    /**
     * Computes a hash code from attributes: {@code prototypeId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + prototypeId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code RowGroupItemsInitEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("RowGroupItemsInitEventMatcher")
          .omitNullValues()
          .add("prototypeId", prototypeId)
          .toString();
    }

    /**
     * Construct a new immutable {@code RowGroupItemsInitEventMatcher} instance.
     * @param prototypeId The value for the {@code prototypeId} attribute
     * @return An immutable RowGroupItemsInitEventMatcher instance
     */
    public static ImmutableEventMatchers.RowGroupItemsInitEventMatcher of(ItemId prototypeId) {
      return new ImmutableEventMatchers.RowGroupItemsInitEventMatcher(prototypeId);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.RowGroupItemsInitEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable RowGroupItemsInitEventMatcher instance
     */
    public static ImmutableEventMatchers.RowGroupItemsInitEventMatcher copyOf(EventMatchers.RowGroupItemsInitEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.RowGroupItemsInitEventMatcher) {
        return (ImmutableEventMatchers.RowGroupItemsInitEventMatcher) instance;
      }
      return ImmutableEventMatchers.RowGroupItemsInitEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.RowGroupItemsInitEventMatcher RowGroupItemsInitEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.RowGroupItemsInitEventMatcher.builder()
     *    .prototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.RowGroupItemsInitEventMatcher#getPrototypeId() prototypeId}
     *    .build();
     * </pre>
     * @return A new RowGroupItemsInitEventMatcher builder
     */
    public static ImmutableEventMatchers.RowGroupItemsInitEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.RowGroupItemsInitEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.RowGroupItemsInitEventMatcher RowGroupItemsInitEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.RowGroupItemsInitEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_PROTOTYPE_ID = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId prototypeId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code RowGroupItemsInitEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.RowGroupItemsInitEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        prototypeId(instance.getPrototypeId());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.RowGroupItemsInitEventMatcher#getPrototypeId() prototypeId} attribute.
       * @param prototypeId The value for prototypeId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder prototypeId(ItemId prototypeId) {
        this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        initBits &= ~INIT_BIT_PROTOTYPE_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.RowGroupItemsInitEventMatcher RowGroupItemsInitEventMatcher}.
       * @return An immutable instance of RowGroupItemsInitEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.RowGroupItemsInitEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.RowGroupItemsInitEventMatcher(null, prototypeId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_PROTOTYPE_ID) != 0) attributes.add("prototypeId");
        return "Cannot build RowGroupItemsInitEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.RowsCanBeAddedUpdatedEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher.builder()}.
   */
  @Generated(from = "EventMatchers.RowsCanBeAddedUpdatedEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class RowsCanBeAddedUpdatedEventMatcher
      implements EventMatchers.RowsCanBeAddedUpdatedEventMatcher {

    private RowsCanBeAddedUpdatedEventMatcher(ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code RowsCanBeAddedUpdatedEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher
          && equalTo((ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 0;
    }

    /**
     * Prints the immutable value {@code RowsCanBeAddedUpdatedEventMatcher}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "RowsCanBeAddedUpdatedEventMatcher{}";
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.RowsCanBeAddedUpdatedEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable RowsCanBeAddedUpdatedEventMatcher instance
     */
    public static ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher copyOf(EventMatchers.RowsCanBeAddedUpdatedEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher) {
        return (ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher) instance;
      }
      return ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher RowsCanBeAddedUpdatedEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher.builder()
     *    .build();
     * </pre>
     * @return A new RowsCanBeAddedUpdatedEventMatcher builder
     */
    public static ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher RowsCanBeAddedUpdatedEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.RowsCanBeAddedUpdatedEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code RowsCanBeAddedUpdatedEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.RowsCanBeAddedUpdatedEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher RowsCanBeAddedUpdatedEventMatcher}.
       * @return An immutable instance of RowsCanBeAddedUpdatedEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher build() {
        return new ImmutableEventMatchers.RowsCanBeAddedUpdatedEventMatcher(this);
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.RowCanBeRemovedUpdatedEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher.builder()}.
   */
  @Generated(from = "EventMatchers.RowCanBeRemovedUpdatedEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class RowCanBeRemovedUpdatedEventMatcher
      implements EventMatchers.RowCanBeRemovedUpdatedEventMatcher {

    private RowCanBeRemovedUpdatedEventMatcher(ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code RowCanBeRemovedUpdatedEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher
          && equalTo((ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 0;
    }

    /**
     * Prints the immutable value {@code RowCanBeRemovedUpdatedEventMatcher}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "RowCanBeRemovedUpdatedEventMatcher{}";
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.RowCanBeRemovedUpdatedEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable RowCanBeRemovedUpdatedEventMatcher instance
     */
    public static ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher copyOf(EventMatchers.RowCanBeRemovedUpdatedEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher) {
        return (ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher) instance;
      }
      return ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher RowCanBeRemovedUpdatedEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher.builder()
     *    .build();
     * </pre>
     * @return A new RowCanBeRemovedUpdatedEventMatcher builder
     */
    public static ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher RowCanBeRemovedUpdatedEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.RowCanBeRemovedUpdatedEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code RowCanBeRemovedUpdatedEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.RowCanBeRemovedUpdatedEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher RowCanBeRemovedUpdatedEventMatcher}.
       * @return An immutable instance of RowCanBeRemovedUpdatedEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher build() {
        return new ImmutableEventMatchers.RowCanBeRemovedUpdatedEventMatcher(this);
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.ItemsChangedEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.ItemsChangedEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.ItemsChangedEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.ItemsChangedEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class ItemsChangedEventMatcher
      implements EventMatchers.ItemsChangedEventMatcher {
    private final ItemId targetMatcher;

    private ItemsChangedEventMatcher(ItemId targetMatcher) {
      this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
    }

    private ItemsChangedEventMatcher(
        ImmutableEventMatchers.ItemsChangedEventMatcher original,
        ItemId targetMatcher) {
      this.targetMatcher = targetMatcher;
    }

    /**
     * @return The value of the {@code targetMatcher} attribute
     */
    @Override
    public ItemId getTargetMatcher() {
      return targetMatcher;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.ItemsChangedEventMatcher#getTargetMatcher() targetMatcher} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetMatcher
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.ItemsChangedEventMatcher withTargetMatcher(ItemId value) {
      if (this.targetMatcher == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
      return new ImmutableEventMatchers.ItemsChangedEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ItemsChangedEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.ItemsChangedEventMatcher
          && equalTo((ImmutableEventMatchers.ItemsChangedEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.ItemsChangedEventMatcher another) {
      return targetMatcher.equals(another.targetMatcher);
    }

    /**
     * Computes a hash code from attributes: {@code targetMatcher}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetMatcher.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ItemsChangedEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ItemsChangedEventMatcher")
          .omitNullValues()
          .add("targetMatcher", targetMatcher)
          .toString();
    }

    /**
     * Construct a new immutable {@code ItemsChangedEventMatcher} instance.
     * @param targetMatcher The value for the {@code targetMatcher} attribute
     * @return An immutable ItemsChangedEventMatcher instance
     */
    public static ImmutableEventMatchers.ItemsChangedEventMatcher of(ItemId targetMatcher) {
      return new ImmutableEventMatchers.ItemsChangedEventMatcher(targetMatcher);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.ItemsChangedEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ItemsChangedEventMatcher instance
     */
    public static ImmutableEventMatchers.ItemsChangedEventMatcher copyOf(EventMatchers.ItemsChangedEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.ItemsChangedEventMatcher) {
        return (ImmutableEventMatchers.ItemsChangedEventMatcher) instance;
      }
      return ImmutableEventMatchers.ItemsChangedEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.ItemsChangedEventMatcher ItemsChangedEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.ItemsChangedEventMatcher.builder()
     *    .targetMatcher(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.ItemsChangedEventMatcher#getTargetMatcher() targetMatcher}
     *    .build();
     * </pre>
     * @return A new ItemsChangedEventMatcher builder
     */
    public static ImmutableEventMatchers.ItemsChangedEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.ItemsChangedEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.ItemsChangedEventMatcher ItemsChangedEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.ItemsChangedEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_MATCHER = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId targetMatcher;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ItemsChangedEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.ItemsChangedEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        targetMatcher(instance.getTargetMatcher());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.ItemsChangedEventMatcher#getTargetMatcher() targetMatcher} attribute.
       * @param targetMatcher The value for targetMatcher 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetMatcher(ItemId targetMatcher) {
        this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        initBits &= ~INIT_BIT_TARGET_MATCHER;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.ItemsChangedEventMatcher ItemsChangedEventMatcher}.
       * @return An immutable instance of ItemsChangedEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.ItemsChangedEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.ItemsChangedEventMatcher(null, targetMatcher);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_MATCHER) != 0) attributes.add("targetMatcher");
        return "Cannot build ItemsChangedEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.AnsweredTargetEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.AnsweredTargetEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.AnsweredTargetEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.AnsweredTargetEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class AnsweredTargetEventMatcher
      implements EventMatchers.AnsweredTargetEventMatcher {
    private final ItemId targetMatcher;

    private AnsweredTargetEventMatcher(ItemId targetMatcher) {
      this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
    }

    private AnsweredTargetEventMatcher(
        ImmutableEventMatchers.AnsweredTargetEventMatcher original,
        ItemId targetMatcher) {
      this.targetMatcher = targetMatcher;
    }

    /**
     * @return The value of the {@code targetMatcher} attribute
     */
    @Override
    public ItemId getTargetMatcher() {
      return targetMatcher;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.AnsweredTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetMatcher
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.AnsweredTargetEventMatcher withTargetMatcher(ItemId value) {
      if (this.targetMatcher == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
      return new ImmutableEventMatchers.AnsweredTargetEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code AnsweredTargetEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.AnsweredTargetEventMatcher
          && equalTo((ImmutableEventMatchers.AnsweredTargetEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.AnsweredTargetEventMatcher another) {
      return targetMatcher.equals(another.targetMatcher);
    }

    /**
     * Computes a hash code from attributes: {@code targetMatcher}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetMatcher.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code AnsweredTargetEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("AnsweredTargetEventMatcher")
          .omitNullValues()
          .add("targetMatcher", targetMatcher)
          .toString();
    }

    /**
     * Construct a new immutable {@code AnsweredTargetEventMatcher} instance.
     * @param targetMatcher The value for the {@code targetMatcher} attribute
     * @return An immutable AnsweredTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.AnsweredTargetEventMatcher of(ItemId targetMatcher) {
      return new ImmutableEventMatchers.AnsweredTargetEventMatcher(targetMatcher);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.AnsweredTargetEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable AnsweredTargetEventMatcher instance
     */
    public static ImmutableEventMatchers.AnsweredTargetEventMatcher copyOf(EventMatchers.AnsweredTargetEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.AnsweredTargetEventMatcher) {
        return (ImmutableEventMatchers.AnsweredTargetEventMatcher) instance;
      }
      return ImmutableEventMatchers.AnsweredTargetEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.AnsweredTargetEventMatcher AnsweredTargetEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.AnsweredTargetEventMatcher.builder()
     *    .targetMatcher(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.AnsweredTargetEventMatcher#getTargetMatcher() targetMatcher}
     *    .build();
     * </pre>
     * @return A new AnsweredTargetEventMatcher builder
     */
    public static ImmutableEventMatchers.AnsweredTargetEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.AnsweredTargetEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.AnsweredTargetEventMatcher AnsweredTargetEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.AnsweredTargetEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_MATCHER = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId targetMatcher;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code AnsweredTargetEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.AnsweredTargetEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        targetMatcher(instance.getTargetMatcher());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.AnsweredTargetEventMatcher#getTargetMatcher() targetMatcher} attribute.
       * @param targetMatcher The value for targetMatcher 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetMatcher(ItemId targetMatcher) {
        this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        initBits &= ~INIT_BIT_TARGET_MATCHER;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.AnsweredTargetEventMatcher AnsweredTargetEventMatcher}.
       * @return An immutable instance of AnsweredTargetEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.AnsweredTargetEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.AnsweredTargetEventMatcher(null, targetMatcher);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_MATCHER) != 0) attributes.add("targetMatcher");
        return "Cannot build AnsweredTargetEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.ActivePageEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.ActivePageEventMatcher.builder()}.
   */
  @Generated(from = "EventMatchers.ActivePageEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class ActivePageEventMatcher
      implements EventMatchers.ActivePageEventMatcher {

    private ActivePageEventMatcher(ImmutableEventMatchers.ActivePageEventMatcher.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code ActivePageEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.ActivePageEventMatcher
          && equalTo((ImmutableEventMatchers.ActivePageEventMatcher) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(ImmutableEventMatchers.ActivePageEventMatcher another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 0;
    }

    /**
     * Prints the immutable value {@code ActivePageEventMatcher}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "ActivePageEventMatcher{}";
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.ActivePageEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ActivePageEventMatcher instance
     */
    public static ImmutableEventMatchers.ActivePageEventMatcher copyOf(EventMatchers.ActivePageEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.ActivePageEventMatcher) {
        return (ImmutableEventMatchers.ActivePageEventMatcher) instance;
      }
      return ImmutableEventMatchers.ActivePageEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.ActivePageEventMatcher ActivePageEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.ActivePageEventMatcher.builder()
     *    .build();
     * </pre>
     * @return A new ActivePageEventMatcher builder
     */
    public static ImmutableEventMatchers.ActivePageEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.ActivePageEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.ActivePageEventMatcher ActivePageEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.ActivePageEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ActivePageEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.ActivePageEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.ActivePageEventMatcher ActivePageEventMatcher}.
       * @return An immutable instance of ActivePageEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.ActivePageEventMatcher build() {
        return new ImmutableEventMatchers.ActivePageEventMatcher(this);
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.AvailableItemsEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.AvailableItemsEventMatcher.builder()}.
   */
  @Generated(from = "EventMatchers.AvailableItemsEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class AvailableItemsEventMatcher
      implements EventMatchers.AvailableItemsEventMatcher {

    private AvailableItemsEventMatcher(ImmutableEventMatchers.AvailableItemsEventMatcher.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code AvailableItemsEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.AvailableItemsEventMatcher
          && equalTo((ImmutableEventMatchers.AvailableItemsEventMatcher) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(ImmutableEventMatchers.AvailableItemsEventMatcher another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 0;
    }

    /**
     * Prints the immutable value {@code AvailableItemsEventMatcher}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "AvailableItemsEventMatcher{}";
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.AvailableItemsEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable AvailableItemsEventMatcher instance
     */
    public static ImmutableEventMatchers.AvailableItemsEventMatcher copyOf(EventMatchers.AvailableItemsEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.AvailableItemsEventMatcher) {
        return (ImmutableEventMatchers.AvailableItemsEventMatcher) instance;
      }
      return ImmutableEventMatchers.AvailableItemsEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.AvailableItemsEventMatcher AvailableItemsEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.AvailableItemsEventMatcher.builder()
     *    .build();
     * </pre>
     * @return A new AvailableItemsEventMatcher builder
     */
    public static ImmutableEventMatchers.AvailableItemsEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.AvailableItemsEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.AvailableItemsEventMatcher AvailableItemsEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.AvailableItemsEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code AvailableItemsEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.AvailableItemsEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.AvailableItemsEventMatcher AvailableItemsEventMatcher}.
       * @return An immutable instance of AvailableItemsEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.AvailableItemsEventMatcher build() {
        return new ImmutableEventMatchers.AvailableItemsEventMatcher(this);
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.AnyErrorEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.AnyErrorEventMatcher.builder()}.
   */
  @Generated(from = "EventMatchers.AnyErrorEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class AnyErrorEventMatcher
      implements EventMatchers.AnyErrorEventMatcher {

    private AnyErrorEventMatcher(ImmutableEventMatchers.AnyErrorEventMatcher.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code AnyErrorEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.AnyErrorEventMatcher
          && equalTo((ImmutableEventMatchers.AnyErrorEventMatcher) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(ImmutableEventMatchers.AnyErrorEventMatcher another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 0;
    }

    /**
     * Prints the immutable value {@code AnyErrorEventMatcher}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "AnyErrorEventMatcher{}";
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.AnyErrorEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable AnyErrorEventMatcher instance
     */
    public static ImmutableEventMatchers.AnyErrorEventMatcher copyOf(EventMatchers.AnyErrorEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.AnyErrorEventMatcher) {
        return (ImmutableEventMatchers.AnyErrorEventMatcher) instance;
      }
      return ImmutableEventMatchers.AnyErrorEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.AnyErrorEventMatcher AnyErrorEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.AnyErrorEventMatcher.builder()
     *    .build();
     * </pre>
     * @return A new AnyErrorEventMatcher builder
     */
    public static ImmutableEventMatchers.AnyErrorEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.AnyErrorEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.AnyErrorEventMatcher AnyErrorEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.AnyErrorEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code AnyErrorEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.AnyErrorEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.AnyErrorEventMatcher AnyErrorEventMatcher}.
       * @return An immutable instance of AnyErrorEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.AnyErrorEventMatcher build() {
        return new ImmutableEventMatchers.AnyErrorEventMatcher(this);
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.TargetErrorEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.TargetErrorEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.TargetErrorEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.TargetErrorEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class TargetErrorEventMatcher
      implements EventMatchers.TargetErrorEventMatcher {
    private final ItemId targetId;

    private TargetErrorEventMatcher(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
    }

    private TargetErrorEventMatcher(
        ImmutableEventMatchers.TargetErrorEventMatcher original,
        ItemId targetId) {
      this.targetId = targetId;
    }

    /**
     * @return The value of the {@code targetId} attribute
     */
    @Override
    public ItemId getTargetId() {
      return targetId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.TargetErrorEventMatcher#getTargetId() targetId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for targetId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.TargetErrorEventMatcher withTargetId(ItemId value) {
      if (this.targetId == value) return this;
      ItemId newValue = Objects.requireNonNull(value, "targetId");
      return new ImmutableEventMatchers.TargetErrorEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code TargetErrorEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.TargetErrorEventMatcher
          && equalTo((ImmutableEventMatchers.TargetErrorEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.TargetErrorEventMatcher another) {
      return targetId.equals(another.targetId);
    }

    /**
     * Computes a hash code from attributes: {@code targetId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + targetId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code TargetErrorEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TargetErrorEventMatcher")
          .omitNullValues()
          .add("targetId", targetId)
          .toString();
    }

    /**
     * Construct a new immutable {@code TargetErrorEventMatcher} instance.
     * @param targetId The value for the {@code targetId} attribute
     * @return An immutable TargetErrorEventMatcher instance
     */
    public static ImmutableEventMatchers.TargetErrorEventMatcher of(ItemId targetId) {
      return new ImmutableEventMatchers.TargetErrorEventMatcher(targetId);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.TargetErrorEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TargetErrorEventMatcher instance
     */
    public static ImmutableEventMatchers.TargetErrorEventMatcher copyOf(EventMatchers.TargetErrorEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.TargetErrorEventMatcher) {
        return (ImmutableEventMatchers.TargetErrorEventMatcher) instance;
      }
      return ImmutableEventMatchers.TargetErrorEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.TargetErrorEventMatcher TargetErrorEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.TargetErrorEventMatcher.builder()
     *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link EventMatchers.TargetErrorEventMatcher#getTargetId() targetId}
     *    .build();
     * </pre>
     * @return A new TargetErrorEventMatcher builder
     */
    public static ImmutableEventMatchers.TargetErrorEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.TargetErrorEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.TargetErrorEventMatcher TargetErrorEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.TargetErrorEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TARGET_ID = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ItemId targetId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code TargetErrorEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.TargetErrorEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        targetId(instance.getTargetId());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.TargetErrorEventMatcher#getTargetId() targetId} attribute.
       * @param targetId The value for targetId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder targetId(ItemId targetId) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        initBits &= ~INIT_BIT_TARGET_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.TargetErrorEventMatcher TargetErrorEventMatcher}.
       * @return An immutable instance of TargetErrorEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.TargetErrorEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.TargetErrorEventMatcher(null, targetId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
        return "Cannot build TargetErrorEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.ErrorIdEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.ErrorIdEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.ErrorIdEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.ErrorIdEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class ErrorIdEventMatcher
      implements EventMatchers.ErrorIdEventMatcher {
    private final ErrorId errorId;

    private ErrorIdEventMatcher(ErrorId errorId) {
      this.errorId = Objects.requireNonNull(errorId, "errorId");
    }

    private ErrorIdEventMatcher(
        ImmutableEventMatchers.ErrorIdEventMatcher original,
        ErrorId errorId) {
      this.errorId = errorId;
    }

    /**
     * @return The value of the {@code errorId} attribute
     */
    @Override
    public ErrorId getErrorId() {
      return errorId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.ErrorIdEventMatcher#getErrorId() errorId} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for errorId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.ErrorIdEventMatcher withErrorId(ErrorId value) {
      if (this.errorId == value) return this;
      ErrorId newValue = Objects.requireNonNull(value, "errorId");
      return new ImmutableEventMatchers.ErrorIdEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ErrorIdEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.ErrorIdEventMatcher
          && equalTo((ImmutableEventMatchers.ErrorIdEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.ErrorIdEventMatcher another) {
      return errorId.equals(another.errorId);
    }

    /**
     * Computes a hash code from attributes: {@code errorId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + errorId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ErrorIdEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ErrorIdEventMatcher")
          .omitNullValues()
          .add("errorId", errorId)
          .toString();
    }

    /**
     * Construct a new immutable {@code ErrorIdEventMatcher} instance.
     * @param errorId The value for the {@code errorId} attribute
     * @return An immutable ErrorIdEventMatcher instance
     */
    public static ImmutableEventMatchers.ErrorIdEventMatcher of(ErrorId errorId) {
      return new ImmutableEventMatchers.ErrorIdEventMatcher(errorId);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.ErrorIdEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ErrorIdEventMatcher instance
     */
    public static ImmutableEventMatchers.ErrorIdEventMatcher copyOf(EventMatchers.ErrorIdEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.ErrorIdEventMatcher) {
        return (ImmutableEventMatchers.ErrorIdEventMatcher) instance;
      }
      return ImmutableEventMatchers.ErrorIdEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.ErrorIdEventMatcher ErrorIdEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.ErrorIdEventMatcher.builder()
     *    .errorId(io.dialob.session.engine.session.model.ErrorId) // required {@link EventMatchers.ErrorIdEventMatcher#getErrorId() errorId}
     *    .build();
     * </pre>
     * @return A new ErrorIdEventMatcher builder
     */
    public static ImmutableEventMatchers.ErrorIdEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.ErrorIdEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.ErrorIdEventMatcher ErrorIdEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.ErrorIdEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_ERROR_ID = 0x1L;
      private long initBits = 0x1L;

      private @Nullable ErrorId errorId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ErrorIdEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.ErrorIdEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        errorId(instance.getErrorId());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.ErrorIdEventMatcher#getErrorId() errorId} attribute.
       * @param errorId The value for errorId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder errorId(ErrorId errorId) {
        this.errorId = Objects.requireNonNull(errorId, "errorId");
        initBits &= ~INIT_BIT_ERROR_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.ErrorIdEventMatcher ErrorIdEventMatcher}.
       * @return An immutable instance of ErrorIdEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.ErrorIdEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.ErrorIdEventMatcher(null, errorId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_ERROR_ID) != 0) attributes.add("errorId");
        return "Cannot build ErrorIdEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EventMatchers.ErrorActivityEventMatcher}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEventMatchers.ErrorActivityEventMatcher.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEventMatchers.ErrorActivityEventMatcher.of()}.
   */
  @Generated(from = "EventMatchers.ErrorActivityEventMatcher", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class ErrorActivityEventMatcher
      implements EventMatchers.ErrorActivityEventMatcher {
    private final EventMatchers.ErrorEventMatcher errorEventMatcher;

    private ErrorActivityEventMatcher(EventMatchers.ErrorEventMatcher errorEventMatcher) {
      this.errorEventMatcher = Objects.requireNonNull(errorEventMatcher, "errorEventMatcher");
    }

    private ErrorActivityEventMatcher(
        ImmutableEventMatchers.ErrorActivityEventMatcher original,
        EventMatchers.ErrorEventMatcher errorEventMatcher) {
      this.errorEventMatcher = errorEventMatcher;
    }

    /**
     * @return The value of the {@code errorEventMatcher} attribute
     */
    @Override
    public EventMatchers.ErrorEventMatcher getErrorEventMatcher() {
      return errorEventMatcher;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EventMatchers.ErrorActivityEventMatcher#getErrorEventMatcher() errorEventMatcher} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for errorEventMatcher
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEventMatchers.ErrorActivityEventMatcher withErrorEventMatcher(EventMatchers.ErrorEventMatcher value) {
      if (this.errorEventMatcher == value) return this;
      EventMatchers.ErrorEventMatcher newValue = Objects.requireNonNull(value, "errorEventMatcher");
      return new ImmutableEventMatchers.ErrorActivityEventMatcher(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ErrorActivityEventMatcher} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEventMatchers.ErrorActivityEventMatcher
          && equalTo((ImmutableEventMatchers.ErrorActivityEventMatcher) another);
    }

    private boolean equalTo(ImmutableEventMatchers.ErrorActivityEventMatcher another) {
      return errorEventMatcher.equals(another.errorEventMatcher);
    }

    /**
     * Computes a hash code from attributes: {@code errorEventMatcher}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + errorEventMatcher.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ErrorActivityEventMatcher} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ErrorActivityEventMatcher")
          .omitNullValues()
          .add("errorEventMatcher", errorEventMatcher)
          .toString();
    }

    /**
     * Construct a new immutable {@code ErrorActivityEventMatcher} instance.
     * @param errorEventMatcher The value for the {@code errorEventMatcher} attribute
     * @return An immutable ErrorActivityEventMatcher instance
     */
    public static ImmutableEventMatchers.ErrorActivityEventMatcher of(EventMatchers.ErrorEventMatcher errorEventMatcher) {
      return new ImmutableEventMatchers.ErrorActivityEventMatcher(errorEventMatcher);
    }

    /**
     * Creates an immutable copy of a {@link EventMatchers.ErrorActivityEventMatcher} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ErrorActivityEventMatcher instance
     */
    public static ImmutableEventMatchers.ErrorActivityEventMatcher copyOf(EventMatchers.ErrorActivityEventMatcher instance) {
      if (instance instanceof ImmutableEventMatchers.ErrorActivityEventMatcher) {
        return (ImmutableEventMatchers.ErrorActivityEventMatcher) instance;
      }
      return ImmutableEventMatchers.ErrorActivityEventMatcher.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEventMatchers.ErrorActivityEventMatcher ErrorActivityEventMatcher}.
     * <pre>
     * ImmutableEventMatchers.ErrorActivityEventMatcher.builder()
     *    .errorEventMatcher(io.dialob.session.engine.session.command.EventMatchers.ErrorEventMatcher) // required {@link EventMatchers.ErrorActivityEventMatcher#getErrorEventMatcher() errorEventMatcher}
     *    .build();
     * </pre>
     * @return A new ErrorActivityEventMatcher builder
     */
    public static ImmutableEventMatchers.ErrorActivityEventMatcher.Builder builder() {
      return new ImmutableEventMatchers.ErrorActivityEventMatcher.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEventMatchers.ErrorActivityEventMatcher ErrorActivityEventMatcher}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EventMatchers.ErrorActivityEventMatcher", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_ERROR_EVENT_MATCHER = 0x1L;
      private long initBits = 0x1L;

      private @Nullable EventMatchers.ErrorEventMatcher errorEventMatcher;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ErrorActivityEventMatcher} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EventMatchers.ErrorActivityEventMatcher instance) {
        Objects.requireNonNull(instance, "instance");
        errorEventMatcher(instance.getErrorEventMatcher());
        return this;
      }

      /**
       * Initializes the value for the {@link EventMatchers.ErrorActivityEventMatcher#getErrorEventMatcher() errorEventMatcher} attribute.
       * @param errorEventMatcher The value for errorEventMatcher 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder errorEventMatcher(EventMatchers.ErrorEventMatcher errorEventMatcher) {
        this.errorEventMatcher = Objects.requireNonNull(errorEventMatcher, "errorEventMatcher");
        initBits &= ~INIT_BIT_ERROR_EVENT_MATCHER;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEventMatchers.ErrorActivityEventMatcher ErrorActivityEventMatcher}.
       * @return An immutable instance of ErrorActivityEventMatcher
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEventMatchers.ErrorActivityEventMatcher build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEventMatchers.ErrorActivityEventMatcher(null, errorEventMatcher);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_ERROR_EVENT_MATCHER) != 0) attributes.add("errorEventMatcher");
        return "Cannot build ErrorActivityEventMatcher, some of required attributes are not set " + attributes;
      }
    }
  }
}
