package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DynamicTrigger}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDynamicTrigger.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDynamicTrigger.of()}.
 */
@Generated(from = "DynamicTrigger", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDynamicTrigger<T>
    implements DynamicTrigger<T> {
  private final BiPredicate<T, T> when;
  private final Triggers.EventsProvider<T> eventsProvider;

  private ImmutableDynamicTrigger(
      BiPredicate<T, T> when,
      Triggers.EventsProvider<T> eventsProvider) {
    this.when = Objects.requireNonNull(when, "when");
    this.eventsProvider = Objects.requireNonNull(eventsProvider, "eventsProvider");
  }

  private ImmutableDynamicTrigger(
      ImmutableDynamicTrigger<T> original,
      BiPredicate<T, T> when,
      Triggers.EventsProvider<T> eventsProvider) {
    this.when = when;
    this.eventsProvider = eventsProvider;
  }

  /**
   * @return The value of the {@code when} attribute
   */
  @Override
  public BiPredicate<T, T> getWhen() {
    return when;
  }

  /**
   * @return The value of the {@code eventsProvider} attribute
   */
  @Override
  public Triggers.EventsProvider<T> getEventsProvider() {
    return eventsProvider;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DynamicTrigger#getWhen() when} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for when
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDynamicTrigger<T> withWhen(BiPredicate<T, T> value) {
    if (this.when == value) return this;
    BiPredicate<T, T> newValue = Objects.requireNonNull(value, "when");
    return new ImmutableDynamicTrigger<>(this, newValue, this.eventsProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DynamicTrigger#getEventsProvider() eventsProvider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventsProvider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDynamicTrigger<T> withEventsProvider(Triggers.EventsProvider<T> value) {
    if (this.eventsProvider == value) return this;
    Triggers.EventsProvider<T> newValue = Objects.requireNonNull(value, "eventsProvider");
    return new ImmutableDynamicTrigger<>(this, this.when, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDynamicTrigger} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDynamicTrigger<?>
        && equalTo((ImmutableDynamicTrigger<?>) another);
  }

  private boolean equalTo(ImmutableDynamicTrigger<?> another) {
    return when.equals(another.when)
        && eventsProvider.equals(another.eventsProvider);
  }

  /**
   * Computes a hash code from attributes: {@code when}, {@code eventsProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + when.hashCode();
    h += (h << 5) + eventsProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DynamicTrigger} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DynamicTrigger")
        .omitNullValues()
        .add("when", when)
        .add("eventsProvider", eventsProvider)
        .toString();
  }

  /**
   * Construct a new immutable {@code DynamicTrigger} instance.
 * @param <T> generic parameter T
   * @param when The value for the {@code when} attribute
   * @param eventsProvider The value for the {@code eventsProvider} attribute
   * @return An immutable DynamicTrigger instance
   */
  public static <T> ImmutableDynamicTrigger<T> of(BiPredicate<T, T> when, Triggers.EventsProvider<T> eventsProvider) {
    return new ImmutableDynamicTrigger<>(when, eventsProvider);
  }

  /**
   * Creates an immutable copy of a {@link DynamicTrigger} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable DynamicTrigger instance
   */
  public static <T> ImmutableDynamicTrigger<T> copyOf(DynamicTrigger<T> instance) {
    if (instance instanceof ImmutableDynamicTrigger<?>) {
      return (ImmutableDynamicTrigger<T>) instance;
    }
    return ImmutableDynamicTrigger.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDynamicTrigger ImmutableDynamicTrigger}.
   * <pre>
   * ImmutableDynamicTrigger.&amp;lt;T&amp;gt;builder()
   *    .when(function.BiPredicate&amp;lt;T, T&amp;gt;) // required {@link DynamicTrigger#getWhen() when}
   *    .eventsProvider(io.dialob.session.engine.session.command.Triggers.EventsProvider&amp;lt;T&amp;gt;) // required {@link DynamicTrigger#getEventsProvider() eventsProvider}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableDynamicTrigger builder
   */
  public static <T> ImmutableDynamicTrigger.Builder<T> builder() {
    return new ImmutableDynamicTrigger.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableDynamicTrigger ImmutableDynamicTrigger}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DynamicTrigger", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_WHEN = 0x1L;
    private static final long INIT_BIT_EVENTS_PROVIDER = 0x2L;
    private long initBits = 0x3L;

    private @Nullable BiPredicate<T, T> when;
    private @Nullable Triggers.EventsProvider<T> eventsProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.DynamicTrigger} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(DynamicTrigger<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.Trigger} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Trigger<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof DynamicTrigger<?>) {
        DynamicTrigger<T> instance = (DynamicTrigger<T>) object;
        if ((bits & 0x1L) == 0) {
          when(instance.getWhen());
          bits |= 0x1L;
        }
        eventsProvider(instance.getEventsProvider());
      }
      if (object instanceof Trigger<?>) {
        Trigger<T> instance = (Trigger<T>) object;
        if ((bits & 0x1L) == 0) {
          when(instance.getWhen());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DynamicTrigger#getWhen() when} attribute.
     * @param when The value for when 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> when(BiPredicate<T, T> when) {
      this.when = Objects.requireNonNull(when, "when");
      initBits &= ~INIT_BIT_WHEN;
      return this;
    }

    /**
     * Initializes the value for the {@link DynamicTrigger#getEventsProvider() eventsProvider} attribute.
     * @param eventsProvider The value for eventsProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> eventsProvider(Triggers.EventsProvider<T> eventsProvider) {
      this.eventsProvider = Objects.requireNonNull(eventsProvider, "eventsProvider");
      initBits &= ~INIT_BIT_EVENTS_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDynamicTrigger ImmutableDynamicTrigger}.
     * @return An immutable instance of DynamicTrigger
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDynamicTrigger<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDynamicTrigger<>(null, when, eventsProvider);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WHEN) != 0) attributes.add("when");
      if ((initBits & INIT_BIT_EVENTS_PROVIDER) != 0) attributes.add("eventsProvider");
      return "Cannot build DynamicTrigger, some of required attributes are not set " + attributes;
    }
  }
}
