package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateRowGroupItemsFromPrototypeCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateRowGroupItemsFromPrototypeCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCreateRowGroupItemsFromPrototypeCommand.of()}.
 */
@Generated(from = "CreateRowGroupItemsFromPrototypeCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateRowGroupItemsFromPrototypeCommand
    implements CreateRowGroupItemsFromPrototypeCommand {
  private final ImmutableList<Trigger<ItemStates>> triggers;
  private final ItemId targetId;
  private final ItemId itemPrototypeId;

  private ImmutableCreateRowGroupItemsFromPrototypeCommand(
      ItemId targetId,
      ItemId itemPrototypeId,
      Iterable<? extends Trigger<ItemStates>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.itemPrototypeId = Objects.requireNonNull(itemPrototypeId, "itemPrototypeId");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableCreateRowGroupItemsFromPrototypeCommand(
      ImmutableCreateRowGroupItemsFromPrototypeCommand original,
      ImmutableList<Trigger<ItemStates>> triggers,
      ItemId targetId,
      ItemId itemPrototypeId) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.itemPrototypeId = itemPrototypeId;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemStates>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code itemPrototypeId} attribute
   */
  @Override
  public ItemId getItemPrototypeId() {
    return itemPrototypeId;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateRowGroupItemsFromPrototypeCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableCreateRowGroupItemsFromPrototypeCommand withTriggers(Trigger<ItemStates>... elements) {
    ImmutableList<Trigger<ItemStates>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateRowGroupItemsFromPrototypeCommand(this, newValue, this.targetId, this.itemPrototypeId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateRowGroupItemsFromPrototypeCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCreateRowGroupItemsFromPrototypeCommand withTriggers(Iterable<? extends Trigger<ItemStates>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemStates>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateRowGroupItemsFromPrototypeCommand(this, newValue, this.targetId, this.itemPrototypeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateRowGroupItemsFromPrototypeCommand#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateRowGroupItemsFromPrototypeCommand withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableCreateRowGroupItemsFromPrototypeCommand(this, this.triggers, newValue, this.itemPrototypeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateRowGroupItemsFromPrototypeCommand#getItemPrototypeId() itemPrototypeId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemPrototypeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateRowGroupItemsFromPrototypeCommand withItemPrototypeId(ItemId value) {
    if (this.itemPrototypeId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "itemPrototypeId");
    return new ImmutableCreateRowGroupItemsFromPrototypeCommand(this, this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateRowGroupItemsFromPrototypeCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateRowGroupItemsFromPrototypeCommand
        && equalTo((ImmutableCreateRowGroupItemsFromPrototypeCommand) another);
  }

  private boolean equalTo(ImmutableCreateRowGroupItemsFromPrototypeCommand another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && itemPrototypeId.equals(another.itemPrototypeId);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code itemPrototypeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + itemPrototypeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateRowGroupItemsFromPrototypeCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateRowGroupItemsFromPrototypeCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("itemPrototypeId", itemPrototypeId)
        .toString();
  }

  /**
   * Construct a new immutable {@code CreateRowGroupItemsFromPrototypeCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param itemPrototypeId The value for the {@code itemPrototypeId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable CreateRowGroupItemsFromPrototypeCommand instance
   */
  public static ImmutableCreateRowGroupItemsFromPrototypeCommand of(ItemId targetId, ItemId itemPrototypeId, List<Trigger<ItemStates>> triggers) {
    return of(targetId, itemPrototypeId, (Iterable<? extends Trigger<ItemStates>>) triggers);
  }

  /**
   * Construct a new immutable {@code CreateRowGroupItemsFromPrototypeCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param itemPrototypeId The value for the {@code itemPrototypeId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable CreateRowGroupItemsFromPrototypeCommand instance
   */
  public static ImmutableCreateRowGroupItemsFromPrototypeCommand of(ItemId targetId, ItemId itemPrototypeId, Iterable<? extends Trigger<ItemStates>> triggers) {
    return new ImmutableCreateRowGroupItemsFromPrototypeCommand(targetId, itemPrototypeId, triggers);
  }

  /**
   * Creates an immutable copy of a {@link CreateRowGroupItemsFromPrototypeCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateRowGroupItemsFromPrototypeCommand instance
   */
  public static ImmutableCreateRowGroupItemsFromPrototypeCommand copyOf(CreateRowGroupItemsFromPrototypeCommand instance) {
    if (instance instanceof ImmutableCreateRowGroupItemsFromPrototypeCommand) {
      return (ImmutableCreateRowGroupItemsFromPrototypeCommand) instance;
    }
    return ImmutableCreateRowGroupItemsFromPrototypeCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateRowGroupItemsFromPrototypeCommand ImmutableCreateRowGroupItemsFromPrototypeCommand}.
   * <pre>
   * ImmutableCreateRowGroupItemsFromPrototypeCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ItemStates&amp;gt;) // {@link CreateRowGroupItemsFromPrototypeCommand#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link CreateRowGroupItemsFromPrototypeCommand#getTargetId() targetId}
   *    .itemPrototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link CreateRowGroupItemsFromPrototypeCommand#getItemPrototypeId() itemPrototypeId}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateRowGroupItemsFromPrototypeCommand builder
   */
  public static ImmutableCreateRowGroupItemsFromPrototypeCommand.Builder builder() {
    return new ImmutableCreateRowGroupItemsFromPrototypeCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateRowGroupItemsFromPrototypeCommand ImmutableCreateRowGroupItemsFromPrototypeCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateRowGroupItemsFromPrototypeCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private static final long INIT_BIT_ITEM_PROTOTYPE_ID = 0x2L;
    private long initBits = 0x3L;

    private ImmutableList.Builder<Trigger<ItemStates>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;
    private @Nullable ItemId itemPrototypeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateRowGroupItemsFromPrototypeCommand} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateRowGroupItemsFromPrototypeCommand instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      targetId(instance.getTargetId());
      itemPrototypeId(instance.getItemPrototypeId());
      return this;
    }

    /**
     * Adds one element to {@link CreateRowGroupItemsFromPrototypeCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemStates> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateRowGroupItemsFromPrototypeCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemStates>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateRowGroupItemsFromPrototypeCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemStates>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link CreateRowGroupItemsFromPrototypeCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemStates>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRowGroupItemsFromPrototypeCommand#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRowGroupItemsFromPrototypeCommand#getItemPrototypeId() itemPrototypeId} attribute.
     * @param itemPrototypeId The value for itemPrototypeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemPrototypeId(ItemId itemPrototypeId) {
      this.itemPrototypeId = Objects.requireNonNull(itemPrototypeId, "itemPrototypeId");
      initBits &= ~INIT_BIT_ITEM_PROTOTYPE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateRowGroupItemsFromPrototypeCommand ImmutableCreateRowGroupItemsFromPrototypeCommand}.
     * @return An immutable instance of CreateRowGroupItemsFromPrototypeCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateRowGroupItemsFromPrototypeCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateRowGroupItemsFromPrototypeCommand(null, triggers.build(), targetId, itemPrototypeId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      if ((initBits & INIT_BIT_ITEM_PROTOTYPE_ID) != 0) attributes.add("itemPrototypeId");
      return "Cannot build CreateRowGroupItemsFromPrototypeCommand, some of required attributes are not set " + attributes;
    }
  }
}
