package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Program}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProgram.builder()}.
 */
@Generated(from = "Program", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProgram implements Program {
  private final String id;
  private final Item rootItem;
  private final ImmutableList<Item> items;
  private final ImmutableList<ValueSet> valueSets;

  private ImmutableProgram(
      String id,
      Item rootItem,
      ImmutableList<Item> items,
      ImmutableList<ValueSet> valueSets) {
    this.id = id;
    this.rootItem = rootItem;
    this.items = items;
    this.valueSets = valueSets;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rootItem} attribute
   */
  @Override
  public Item getRootItem() {
    return rootItem;
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @Override
  public ImmutableList<Item> getItems() {
    return items;
  }

  /**
   * @return The value of the {@code valueSets} attribute
   */
  @Override
  public ImmutableList<ValueSet> getValueSets() {
    return valueSets;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Program#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgram withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableProgram(newValue, this.rootItem, this.items, this.valueSets);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Program#getRootItem() rootItem} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rootItem
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgram withRootItem(Item value) {
    if (this.rootItem == value) return this;
    Item newValue = Objects.requireNonNull(value, "rootItem");
    return new ImmutableProgram(this.id, newValue, this.items, this.valueSets);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Program#getItems() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProgram withItems(Item... elements) {
    ImmutableList<Item> newValue = ImmutableList.copyOf(elements);
    return new ImmutableProgram(this.id, this.rootItem, newValue, this.valueSets);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Program#getItems() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProgram withItems(Iterable<? extends Item> elements) {
    if (this.items == elements) return this;
    ImmutableList<Item> newValue = ImmutableList.copyOf(elements);
    return new ImmutableProgram(this.id, this.rootItem, newValue, this.valueSets);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Program#getValueSets() valueSets}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProgram withValueSets(ValueSet... elements) {
    ImmutableList<ValueSet> newValue = ImmutableList.copyOf(elements);
    return new ImmutableProgram(this.id, this.rootItem, this.items, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Program#getValueSets() valueSets}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of valueSets elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProgram withValueSets(Iterable<? extends ValueSet> elements) {
    if (this.valueSets == elements) return this;
    ImmutableList<ValueSet> newValue = ImmutableList.copyOf(elements);
    return new ImmutableProgram(this.id, this.rootItem, this.items, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProgram} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProgram
        && equalTo((ImmutableProgram) another);
  }

  private boolean equalTo(ImmutableProgram another) {
    return id.equals(another.id)
        && rootItem.equals(another.rootItem)
        && items.equals(another.items)
        && valueSets.equals(another.valueSets);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rootItem}, {@code items}, {@code valueSets}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rootItem.hashCode();
    h += (h << 5) + items.hashCode();
    h += (h << 5) + valueSets.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Program} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Program")
        .omitNullValues()
        .add("id", id)
        .add("rootItem", rootItem)
        .add("items", items)
        .add("valueSets", valueSets)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Program} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Program instance
   */
  public static ImmutableProgram copyOf(Program instance) {
    if (instance instanceof ImmutableProgram) {
      return (ImmutableProgram) instance;
    }
    return ImmutableProgram.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProgram ImmutableProgram}.
   * <pre>
   * ImmutableProgram.builder()
   *    .id(String) // required {@link Program#getId() id}
   *    .rootItem(io.dialob.session.engine.program.model.Item) // required {@link Program#getRootItem() rootItem}
   *    .addItems|addAllItems(io.dialob.session.engine.program.model.Item) // {@link Program#getItems() items} elements
   *    .addValueSets|addAllValueSets(io.dialob.session.engine.program.model.ValueSet) // {@link Program#getValueSets() valueSets} elements
   *    .build();
   * </pre>
   * @return A new ImmutableProgram builder
   */
  public static ImmutableProgram.Builder builder() {
    return new ImmutableProgram.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProgram ImmutableProgram}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Program", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_ROOT_ITEM = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable Item rootItem;
    private ImmutableList.Builder<Item> items = ImmutableList.builder();
    private ImmutableList.Builder<ValueSet> valueSets = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Program} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Program instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rootItem(instance.getRootItem());
      addAllItems(instance.getItems());
      addAllValueSets(instance.getValueSets());
      return this;
    }

    /**
     * Initializes the value for the {@link Program#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Program#getRootItem() rootItem} attribute.
     * @param rootItem The value for rootItem 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rootItem(Item rootItem) {
      this.rootItem = Objects.requireNonNull(rootItem, "rootItem");
      initBits &= ~INIT_BIT_ROOT_ITEM;
      return this;
    }

    /**
     * Adds one element to {@link Program#getItems() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(Item element) {
      this.items.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Program#getItems() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(Item... elements) {
      this.items.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Program#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder items(Iterable<? extends Item> elements) {
      this.items = ImmutableList.builder();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link Program#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllItems(Iterable<? extends Item> elements) {
      this.items.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Program#getValueSets() valueSets} list.
     * @param element A valueSets element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValueSets(ValueSet element) {
      this.valueSets.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Program#getValueSets() valueSets} list.
     * @param elements An array of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValueSets(ValueSet... elements) {
      this.valueSets.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Program#getValueSets() valueSets} list.
     * @param elements An iterable of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSets(Iterable<? extends ValueSet> elements) {
      this.valueSets = ImmutableList.builder();
      return addAllValueSets(elements);
    }

    /**
     * Adds elements to {@link Program#getValueSets() valueSets} list.
     * @param elements An iterable of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValueSets(Iterable<? extends ValueSet> elements) {
      this.valueSets.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableProgram ImmutableProgram}.
     * @return An immutable instance of Program
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProgram build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProgram(id, rootItem, items.build(), valueSets.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ROOT_ITEM) != 0) attributes.add("rootItem");
      return "Cannot build Program, some of required attributes are not set " + attributes;
    }
  }
}
