package io.dialob.session.engine.program.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormItem.builder()}.
 */
@Generated(from = "FormItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormItem implements FormItem {
  private final boolean isPrototype;
  private final ItemId id;
  private final String type;
  private final @Nullable ValueType valueType;
  private final @Nullable String valueSetId;
  private final @Nullable Object defaultValue;
  private final @org.jetbrains.annotations.Nullable String view;
  private final @org.jetbrains.annotations.Nullable Map<String, Object> props;
  private final @Nullable Expression className;
  private final @Nullable Expression activeExpression;
  private final @Nullable Expression requiredExpression;
  private final @Nullable Expression disabledExpression;
  private final @Nullable Expression labelExpression;
  private final @Nullable Expression descriptionExpression;
  private final List<Error> errors;

  private ImmutableFormItem(ImmutableFormItem.Builder builder) {
    this.id = builder.id;
    this.type = builder.type;
    this.valueType = builder.valueType;
    this.valueSetId = builder.valueSetId;
    this.defaultValue = builder.defaultValue;
    this.view = builder.view;
    this.props = builder.props == null ? null : createUnmodifiableMap(false, false, builder.props);
    this.className = builder.className;
    this.activeExpression = builder.activeExpression;
    this.requiredExpression = builder.requiredExpression;
    this.disabledExpression = builder.disabledExpression;
    this.labelExpression = builder.labelExpression;
    this.descriptionExpression = builder.descriptionExpression;
    this.errors = createUnmodifiableList(true, builder.errors);
    this.isPrototype = builder.isPrototypeIsSet()
        ? builder.isPrototype
        : FormItem.super.isPrototype();
  }

  private ImmutableFormItem(
      boolean isPrototype,
      ItemId id,
      String type,
      @Nullable ValueType valueType,
      @Nullable String valueSetId,
      @Nullable Object defaultValue,
      @org.jetbrains.annotations.Nullable String view,
      @org.jetbrains.annotations.Nullable Map<String, Object> props,
      @Nullable Expression className,
      @Nullable Expression activeExpression,
      @Nullable Expression requiredExpression,
      @Nullable Expression disabledExpression,
      @Nullable Expression labelExpression,
      @Nullable Expression descriptionExpression,
      List<Error> errors) {
    this.isPrototype = isPrototype;
    this.id = id;
    this.type = type;
    this.valueType = valueType;
    this.valueSetId = valueSetId;
    this.defaultValue = defaultValue;
    this.view = view;
    this.props = props;
    this.className = className;
    this.activeExpression = activeExpression;
    this.requiredExpression = requiredExpression;
    this.disabledExpression = disabledExpression;
    this.labelExpression = labelExpression;
    this.descriptionExpression = descriptionExpression;
    this.errors = errors;
  }

  /**
   * @return The value of the {@code isPrototype} attribute
   */
  @Override
  public boolean isPrototype() {
    return isPrototype;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public ItemId getId() {
    return id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @Override
  public @Nullable ValueType getValueType() {
    return valueType;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @Override
  public Optional<String> getValueSetId() {
    return Optional.ofNullable(valueSetId);
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @Override
  public Optional<Object> getDefaultValue() {
    return Optional.ofNullable(defaultValue);
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @Override
  public @org.jetbrains.annotations.Nullable String getView() {
    return view;
  }

  /**
   * @return The value of the {@code props} attribute
   */
  @Override
  public @org.jetbrains.annotations.Nullable Map<String, Object> getProps() {
    return props;
  }

  /**
   * @return The value of the {@code className} attribute
   */
  @Override
  public Optional<Expression> getClassName() {
    return Optional.ofNullable(className);
  }

  /**
   * @return The value of the {@code activeExpression} attribute
   */
  @Override
  public Optional<Expression> getActiveExpression() {
    return Optional.ofNullable(activeExpression);
  }

  /**
   * @return The value of the {@code requiredExpression} attribute
   */
  @Override
  public Optional<Expression> getRequiredExpression() {
    return Optional.ofNullable(requiredExpression);
  }

  /**
   * @return The value of the {@code disabledExpression} attribute
   */
  @Override
  public Optional<Expression> getDisabledExpression() {
    return Optional.ofNullable(disabledExpression);
  }

  /**
   * @return The value of the {@code labelExpression} attribute
   */
  @Override
  public Optional<Expression> getLabelExpression() {
    return Optional.ofNullable(labelExpression);
  }

  /**
   * @return The value of the {@code descriptionExpression} attribute
   */
  @Override
  public Optional<Expression> getDescriptionExpression() {
    return Optional.ofNullable(descriptionExpression);
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @Override
  public List<Error> getErrors() {
    return errors;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#isPrototype() isPrototype} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPrototype
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withIsPrototype(boolean value) {
    if (this.isPrototype == value) return this;
    return new ImmutableFormItem(
        value,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getId() id} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withId(ItemId value) {
    if (this.id == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "id");
    return new ImmutableFormItem(
        this.isPrototype,
        newValue,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        newValue,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withValueType(@Nullable ValueType value) {
    if (this.valueType == value) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        value,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormItem#getValueSetId() valueSetId} attribute.
   * @param value The value for valueSetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withValueSetId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "valueSetId");
    if (Objects.equals(this.valueSetId, newValue)) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        newValue,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormItem#getValueSetId() valueSetId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for valueSetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withValueSetId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.valueSetId, value)) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        value,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormItem#getDefaultValue() defaultValue} attribute.
   * @param value The value for defaultValue
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withDefaultValue(Object value) {
    @Nullable Object newValue = Objects.requireNonNull(value, "defaultValue");
    if (this.defaultValue == newValue) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        newValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormItem#getDefaultValue() defaultValue} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defaultValue
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFormItem withDefaultValue(Optional<? extends Object> optional) {
    @Nullable Object value = optional.orElse(null);
    if (this.defaultValue == value) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        value,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getView() view} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for view (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withView(@org.jetbrains.annotations.Nullable String value) {
    if (Objects.equals(this.view, value)) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        value,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormItem#getProps() props} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the props map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withProps(@org.jetbrains.annotations.Nullable Map<String, ? extends Object> entries) {
    if (this.props == entries) return this;
    @org.jetbrains.annotations.Nullable Map<String, Object> newValue = entries == null ? null : createUnmodifiableMap(false, false, entries);
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        newValue,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormItem#getClassName() className} attribute.
   * @param value The value for className
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withClassName(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "className");
    if (this.className == newValue) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        newValue,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormItem#getClassName() className} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for className
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFormItem withClassName(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.className == value) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        value,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormItem#getActiveExpression() activeExpression} attribute.
   * @param value The value for activeExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withActiveExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "activeExpression");
    if (this.activeExpression == newValue) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        newValue,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormItem#getActiveExpression() activeExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for activeExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFormItem withActiveExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.activeExpression == value) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        value,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormItem#getRequiredExpression() requiredExpression} attribute.
   * @param value The value for requiredExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withRequiredExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "requiredExpression");
    if (this.requiredExpression == newValue) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        newValue,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormItem#getRequiredExpression() requiredExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for requiredExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFormItem withRequiredExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.requiredExpression == value) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        value,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormItem#getDisabledExpression() disabledExpression} attribute.
   * @param value The value for disabledExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withDisabledExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "disabledExpression");
    if (this.disabledExpression == newValue) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        newValue,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormItem#getDisabledExpression() disabledExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for disabledExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFormItem withDisabledExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.disabledExpression == value) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        value,
        this.labelExpression,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormItem#getLabelExpression() labelExpression} attribute.
   * @param value The value for labelExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withLabelExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "labelExpression");
    if (this.labelExpression == newValue) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        newValue,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormItem#getLabelExpression() labelExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for labelExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFormItem withLabelExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.labelExpression == value) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        value,
        this.descriptionExpression,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormItem#getDescriptionExpression() descriptionExpression} attribute.
   * @param value The value for descriptionExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withDescriptionExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "descriptionExpression");
    if (this.descriptionExpression == newValue) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        newValue,
        this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormItem#getDescriptionExpression() descriptionExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for descriptionExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFormItem withDescriptionExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.descriptionExpression == value) return this;
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        value,
        this.errors);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormItem#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withErrors(Error... elements) {
    List<Error> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormItem#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withErrors(Iterable<? extends Error> elements) {
    if (this.errors == elements) return this;
    List<Error> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFormItem(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormItem
        && equalTo((ImmutableFormItem) another);
  }

  private boolean equalTo(ImmutableFormItem another) {
    return isPrototype == another.isPrototype
        && id.equals(another.id)
        && type.equals(another.type)
        && Objects.equals(valueType, another.valueType)
        && Objects.equals(valueSetId, another.valueSetId)
        && Objects.equals(defaultValue, another.defaultValue)
        && Objects.equals(view, another.view)
        && Objects.equals(props, another.props)
        && Objects.equals(className, another.className)
        && Objects.equals(activeExpression, another.activeExpression)
        && Objects.equals(requiredExpression, another.requiredExpression)
        && Objects.equals(disabledExpression, another.disabledExpression)
        && Objects.equals(labelExpression, another.labelExpression)
        && Objects.equals(descriptionExpression, another.descriptionExpression)
        && errors.equals(another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code isPrototype}, {@code id}, {@code type}, {@code valueType}, {@code valueSetId}, {@code defaultValue}, {@code view}, {@code props}, {@code className}, {@code activeExpression}, {@code requiredExpression}, {@code disabledExpression}, {@code labelExpression}, {@code descriptionExpression}, {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(isPrototype);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(valueType);
    h += (h << 5) + Objects.hashCode(valueSetId);
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + Objects.hashCode(view);
    h += (h << 5) + Objects.hashCode(props);
    h += (h << 5) + Objects.hashCode(className);
    h += (h << 5) + Objects.hashCode(activeExpression);
    h += (h << 5) + Objects.hashCode(requiredExpression);
    h += (h << 5) + Objects.hashCode(disabledExpression);
    h += (h << 5) + Objects.hashCode(labelExpression);
    h += (h << 5) + Objects.hashCode(descriptionExpression);
    h += (h << 5) + errors.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("FormItem{");
    builder.append("isPrototype=").append(isPrototype);
    builder.append(", ");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("type=").append(type);
    if (valueType != null) {
      builder.append(", ");
      builder.append("valueType=").append(valueType);
    }
    if (valueSetId != null) {
      builder.append(", ");
      builder.append("valueSetId=").append(valueSetId);
    }
    if (defaultValue != null) {
      builder.append(", ");
      builder.append("defaultValue=").append(defaultValue);
    }
    if (view != null) {
      builder.append(", ");
      builder.append("view=").append(view);
    }
    if (props != null) {
      builder.append(", ");
      builder.append("props=").append(props);
    }
    if (className != null) {
      builder.append(", ");
      builder.append("className=").append(className);
    }
    if (activeExpression != null) {
      builder.append(", ");
      builder.append("activeExpression=").append(activeExpression);
    }
    if (requiredExpression != null) {
      builder.append(", ");
      builder.append("requiredExpression=").append(requiredExpression);
    }
    if (disabledExpression != null) {
      builder.append(", ");
      builder.append("disabledExpression=").append(disabledExpression);
    }
    if (labelExpression != null) {
      builder.append(", ");
      builder.append("labelExpression=").append(labelExpression);
    }
    if (descriptionExpression != null) {
      builder.append(", ");
      builder.append("descriptionExpression=").append(descriptionExpression);
    }
    builder.append(", ");
    builder.append("errors=").append(errors);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link FormItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormItem instance
   */
  public static ImmutableFormItem copyOf(FormItem instance) {
    if (instance instanceof ImmutableFormItem) {
      return (ImmutableFormItem) instance;
    }
    return ImmutableFormItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormItem ImmutableFormItem}.
   * <pre>
   * ImmutableFormItem.builder()
   *    .isPrototype(boolean) // optional {@link FormItem#isPrototype() isPrototype}
   *    .id(io.dialob.session.engine.session.model.ItemId) // required {@link FormItem#getId() id}
   *    .type(String) // required {@link FormItem#getType() type}
   *    .valueType(io.dialob.rule.parser.api.ValueType | null) // nullable {@link FormItem#getValueType() valueType}
   *    .valueSetId(String) // optional {@link FormItem#getValueSetId() valueSetId}
   *    .defaultValue(Object) // optional {@link FormItem#getDefaultValue() defaultValue}
   *    .view(String | null) // nullable {@link FormItem#getView() view}
   *    .props(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link FormItem#getProps() props}
   *    .className(io.dialob.session.engine.program.model.Expression) // optional {@link FormItem#getClassName() className}
   *    .activeExpression(io.dialob.session.engine.program.model.Expression) // optional {@link FormItem#getActiveExpression() activeExpression}
   *    .requiredExpression(io.dialob.session.engine.program.model.Expression) // optional {@link FormItem#getRequiredExpression() requiredExpression}
   *    .disabledExpression(io.dialob.session.engine.program.model.Expression) // optional {@link FormItem#getDisabledExpression() disabledExpression}
   *    .labelExpression(io.dialob.session.engine.program.model.Expression) // optional {@link FormItem#getLabelExpression() labelExpression}
   *    .descriptionExpression(io.dialob.session.engine.program.model.Expression) // optional {@link FormItem#getDescriptionExpression() descriptionExpression}
   *    .addErrors|addAllErrors(io.dialob.session.engine.program.model.Error) // {@link FormItem#getErrors() errors} elements
   *    .build();
   * </pre>
   * @return A new ImmutableFormItem builder
   */
  public static ImmutableFormItem.Builder builder() {
    return new ImmutableFormItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormItem ImmutableFormItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long OPT_BIT_IS_PROTOTYPE = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private boolean isPrototype;
    private @Nullable ItemId id;
    private @Nullable String type;
    private @Nullable ValueType valueType;
    private @Nullable String valueSetId;
    private @Nullable Object defaultValue;
    private @Nullable String view;
    private Map<String, Object> props = null;
    private @Nullable Expression className;
    private @Nullable Expression activeExpression;
    private @Nullable Expression requiredExpression;
    private @Nullable Expression disabledExpression;
    private @Nullable Expression labelExpression;
    private @Nullable Expression descriptionExpression;
    private List<Error> errors = new ArrayList<Error>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.DisplayItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DisplayItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Item} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Item instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.StructuralNode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StructuralNode instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.FormItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FormItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DisplayItem) {
        DisplayItem instance = (DisplayItem) object;
        @org.jetbrains.annotations.Nullable String viewValue = instance.getView();
        if (viewValue != null) {
          view(viewValue);
        }
        Optional<Expression> activeExpressionOptional = instance.getActiveExpression();
        if (activeExpressionOptional.isPresent()) {
          activeExpression(activeExpressionOptional);
        }
        Optional<Expression> requiredExpressionOptional = instance.getRequiredExpression();
        if (requiredExpressionOptional.isPresent()) {
          requiredExpression(requiredExpressionOptional);
        }
        Optional<Expression> classNameOptional = instance.getClassName();
        if (classNameOptional.isPresent()) {
          className(classNameOptional);
        }
        Optional<Expression> disabledExpressionOptional = instance.getDisabledExpression();
        if (disabledExpressionOptional.isPresent()) {
          disabledExpression(disabledExpressionOptional);
        }
        Optional<Expression> labelExpressionOptional = instance.getLabelExpression();
        if (labelExpressionOptional.isPresent()) {
          labelExpression(labelExpressionOptional);
        }
        addAllErrors(instance.getErrors());
        @org.jetbrains.annotations.Nullable Map<String, Object> propsValue = instance.getProps();
        if (propsValue != null) {
          putAllProps(propsValue);
        }
        Optional<Expression> descriptionExpressionOptional = instance.getDescriptionExpression();
        if (descriptionExpressionOptional.isPresent()) {
          descriptionExpression(descriptionExpressionOptional);
        }
      }
      if (object instanceof Item) {
        Item instance = (Item) object;
        id(instance.getId());
        type(instance.getType());
        Optional<Object> defaultValueOptional = instance.getDefaultValue();
        if (defaultValueOptional.isPresent()) {
          defaultValue(defaultValueOptional);
        }
        Optional<String> valueSetIdOptional = instance.getValueSetId();
        if (valueSetIdOptional.isPresent()) {
          valueSetId(valueSetIdOptional);
        }
        @Nullable ValueType valueTypeValue = instance.getValueType();
        if (valueTypeValue != null) {
          valueType(valueTypeValue);
        }
      }
      if (object instanceof StructuralNode) {
        StructuralNode instance = (StructuralNode) object;
        isPrototype(instance.isPrototype());
      }
    }

    /**
     * Initializes the value for the {@link FormItem#isPrototype() isPrototype} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FormItem#isPrototype() isPrototype}.</em>
     * @param isPrototype The value for isPrototype 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPrototype(boolean isPrototype) {
      this.isPrototype = isPrototype;
      optBits |= OPT_BIT_IS_PROTOTYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(ItemId id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getValueType() valueType} attribute.
     * @param valueType The value for valueType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueType(@Nullable ValueType valueType) {
      this.valueType = valueType;
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getValueSetId() valueSetId} to valueSetId.
     * @param valueSetId The value for valueSetId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(String valueSetId) {
      this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getValueSetId() valueSetId} to valueSetId.
     * @param valueSetId The value for valueSetId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(Optional<String> valueSetId) {
      this.valueSetId = valueSetId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getDefaultValue() defaultValue} to defaultValue.
     * @param defaultValue The value for defaultValue
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultValue(Object defaultValue) {
      this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getDefaultValue() defaultValue} to defaultValue.
     * @param defaultValue The value for defaultValue
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultValue(Optional<? extends Object> defaultValue) {
      this.defaultValue = defaultValue.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getView() view} attribute.
     * @param view The value for view (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder view(@org.jetbrains.annotations.Nullable String view) {
      this.view = view;
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getProps() props} map.
     * @param key The key in the props map
     * @param value The associated value in the props map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProps(@Nullable String key, @Nullable Object value) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      this.props.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getProps() props} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProps(Map.Entry<String, ? extends Object> entry) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.props.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getProps() props} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the props map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder props(@org.jetbrains.annotations.Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.props = null;
        return this;
      }
      this.props = new LinkedHashMap<String, Object>();
      return putAllProps(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormItem#getProps() props} map. Nulls are not permitted
     * @param entries The entries that will be added to the props map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllProps(Map<String, ? extends Object> entries) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.props.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getClassName() className} to className.
     * @param className The value for className
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder className(Expression className) {
      this.className = Objects.requireNonNull(className, "className");
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getClassName() className} to className.
     * @param className The value for className
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder className(Optional<? extends Expression> className) {
      this.className = className.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getActiveExpression() activeExpression} to activeExpression.
     * @param activeExpression The value for activeExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder activeExpression(Expression activeExpression) {
      this.activeExpression = Objects.requireNonNull(activeExpression, "activeExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getActiveExpression() activeExpression} to activeExpression.
     * @param activeExpression The value for activeExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder activeExpression(Optional<? extends Expression> activeExpression) {
      this.activeExpression = activeExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getRequiredExpression() requiredExpression} to requiredExpression.
     * @param requiredExpression The value for requiredExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder requiredExpression(Expression requiredExpression) {
      this.requiredExpression = Objects.requireNonNull(requiredExpression, "requiredExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getRequiredExpression() requiredExpression} to requiredExpression.
     * @param requiredExpression The value for requiredExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder requiredExpression(Optional<? extends Expression> requiredExpression) {
      this.requiredExpression = requiredExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getDisabledExpression() disabledExpression} to disabledExpression.
     * @param disabledExpression The value for disabledExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder disabledExpression(Expression disabledExpression) {
      this.disabledExpression = Objects.requireNonNull(disabledExpression, "disabledExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getDisabledExpression() disabledExpression} to disabledExpression.
     * @param disabledExpression The value for disabledExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder disabledExpression(Optional<? extends Expression> disabledExpression) {
      this.disabledExpression = disabledExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getLabelExpression() labelExpression} to labelExpression.
     * @param labelExpression The value for labelExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder labelExpression(Expression labelExpression) {
      this.labelExpression = Objects.requireNonNull(labelExpression, "labelExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getLabelExpression() labelExpression} to labelExpression.
     * @param labelExpression The value for labelExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder labelExpression(Optional<? extends Expression> labelExpression) {
      this.labelExpression = labelExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getDescriptionExpression() descriptionExpression} to descriptionExpression.
     * @param descriptionExpression The value for descriptionExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder descriptionExpression(Expression descriptionExpression) {
      this.descriptionExpression = Objects.requireNonNull(descriptionExpression, "descriptionExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link FormItem#getDescriptionExpression() descriptionExpression} to descriptionExpression.
     * @param descriptionExpression The value for descriptionExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder descriptionExpression(Optional<? extends Expression> descriptionExpression) {
      this.descriptionExpression = descriptionExpression.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link FormItem#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrors(Error element) {
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link FormItem#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrors(Error... elements) {
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FormItem#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errors(Iterable<? extends Error> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link FormItem#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllErrors(Iterable<? extends Error> elements) {
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormItem ImmutableFormItem}.
     * @return An immutable instance of FormItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormItem(this);
    }

    private boolean isPrototypeIsSet() {
      return (optBits & OPT_BIT_IS_PROTOTYPE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build FormItem, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
